/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.template;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class TemplateHelper {
    private final String basePath;
    private final Charset charset;

    public static TemplateHelper instance(String basePath, Charset charset) {
        return new TemplateHelper(basePath, charset);
    }

    public static TemplateHelper instance(String basePath) {
        return TemplateHelper.instance(basePath, StandardCharsets.UTF_8);
    }

    private TemplateHelper(String basePath, Charset charset) {
        this.basePath = TemplateHelper.adaptBasePath(basePath);
        this.charset = charset;
    }

    public String getXmlMessageTemplate(String templatePath) {
        return this.getMessageTemplate(templatePath, templatePath.endsWith(".xml") ? "" : "xml");
    }

    public String getJsonMessageTemplate(String templatePath) {
        return this.getMessageTemplate(templatePath, templatePath.endsWith(".json") ? "" : "json");
    }

    public String getMessageTemplate(String templatePath, String templateExtension) {
        try {
            return FileUtils.readToString((Resource)this.getFileResource(templatePath, templateExtension), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Error reading template: %s", templatePath), (Throwable)e);
        }
    }

    public Resource getFileResource(String resourcePath, String resourceExtension) {
        String adaptedFileExtension = resourceExtension;
        if (StringUtils.hasLength((String)resourceExtension) && !StringUtils.startsWithIgnoreCase((String)resourceExtension, (String)".")) {
            adaptedFileExtension = "." + resourceExtension;
        }
        return new ClassPathResource(this.basePath + resourcePath + adaptedFileExtension);
    }

    private static String adaptBasePath(String basePath) {
        return StringUtils.endsWithIgnoreCase((String)basePath, (String)"/") ? basePath : basePath + "/";
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

