/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.simulator.SimulatorAutoConfiguration;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointAdapter;
import com.consol.citrus.simulator.scenario.mapper.ContentBasedXPathScenarioMapper;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import com.consol.citrus.simulator.ws.SimulatorWebServiceConfigurationProperties;
import com.consol.citrus.simulator.ws.SimulatorWebServiceConfigurer;
import com.consol.citrus.simulator.ws.SimulatorWebServiceLoggingAutoConfiguration;
import com.consol.citrus.simulator.ws.WsdlScenarioGenerator;
import com.consol.citrus.ws.interceptor.LoggingEndpointInterceptor;
import com.consol.citrus.ws.server.WebServiceEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointMapping;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.server.endpoint.adapter.MessageEndpointAdapter;
import org.springframework.ws.server.endpoint.mapping.UriEndpointMapping;
import org.springframework.ws.transport.http.MessageDispatcherServlet;

@Configuration
@AutoConfigureAfter(value={SimulatorAutoConfiguration.class})
@Import(value={SimulatorWebServiceLoggingAutoConfiguration.class})
@EnableConfigurationProperties(value={SimulatorWebServiceConfigurationProperties.class})
@ConditionalOnProperty(prefix="citrus.simulator.ws", value={"enabled"}, havingValue="true")
@ConditionalOnWebApplication
public class SimulatorWebServiceAutoConfiguration {
    @Autowired(required=false)
    private SimulatorWebServiceConfigurer configurer;
    @Autowired
    private LoggingEndpointInterceptor loggingEndpointInterceptor;
    @Autowired
    private SimulatorWebServiceConfigurationProperties simulatorWebServiceConfiguration;

    @Bean
    public MessageEndpointAdapter messageEndpointAdapter() {
        return new MessageEndpointAdapter();
    }

    @Bean
    public ServletRegistrationBean messageDispatcherServlet(ApplicationContext applicationContext) {
        MessageDispatcherServlet servlet = new MessageDispatcherServlet();
        servlet.setApplicationContext(applicationContext);
        servlet.setTransformWsdlLocations(true);
        return new ServletRegistrationBean((Servlet)servlet, new String[]{this.getServletMapping()});
    }

    @Bean(name={"simulatorWsEndpointMapping"})
    public EndpointMapping endpointMapping(ApplicationContext applicationContext) {
        UriEndpointMapping endpointMapping = new UriEndpointMapping();
        endpointMapping.setOrder(Integer.MIN_VALUE);
        endpointMapping.setDefaultEndpoint((Object)this.webServiceEndpoint(applicationContext));
        endpointMapping.setInterceptors(this.interceptors());
        return endpointMapping;
    }

    @Bean(name={"simulatorWsEndpoint"})
    public MessageEndpoint webServiceEndpoint(ApplicationContext applicationContext) {
        WebServiceEndpoint webServiceEndpoint = new WebServiceEndpoint();
        SimulatorEndpointAdapter endpointAdapter = this.simulatorEndpointAdapter();
        endpointAdapter.setApplicationContext(applicationContext);
        endpointAdapter.setMappingKeyExtractor(this.simulatorScenarioMapper());
        endpointAdapter.setFallbackEndpointAdapter(this.simulatorFallbackEndpointAdapter());
        webServiceEndpoint.setEndpointAdapter((EndpointAdapter)endpointAdapter);
        return webServiceEndpoint;
    }

    @Bean(name={"simulatorWsEndpointAdapter"})
    public SimulatorEndpointAdapter simulatorEndpointAdapter() {
        return new SimulatorEndpointAdapter();
    }

    @Bean(name={"simulatorWsScenarioMapper"})
    public ScenarioMapper simulatorScenarioMapper() {
        if (this.configurer != null) {
            return this.configurer.scenarioMapper();
        }
        return new ContentBasedXPathScenarioMapper().addXPathExpression("local-name(/*)");
    }

    @Bean(name={"simulatorWsFallbackEndpointAdapter"})
    public EndpointAdapter simulatorFallbackEndpointAdapter() {
        if (this.configurer != null) {
            return this.configurer.fallbackEndpointAdapter();
        }
        return new EmptyResponseEndpointAdapter();
    }

    @Bean(name={"simulatorWsdlScenarioGenerator"})
    @ConditionalOnMissingBean(value={WsdlScenarioGenerator.class})
    @ConditionalOnProperty(prefix="citrus.simulator.ws.wsdl", value={"enabled"}, havingValue="true")
    public static WsdlScenarioGenerator scenarioGenerator(Environment environment) {
        return new WsdlScenarioGenerator(environment);
    }

    protected String getServletMapping() {
        if (this.configurer != null) {
            return this.configurer.servletMapping(this.simulatorWebServiceConfiguration);
        }
        return this.simulatorWebServiceConfiguration.getServletMapping();
    }

    protected EndpointInterceptor[] interceptors() {
        ArrayList<LoggingEndpointInterceptor> interceptors = new ArrayList<LoggingEndpointInterceptor>();
        if (this.configurer != null) {
            Collections.addAll(interceptors, this.configurer.interceptors());
        }
        interceptors.add(this.loggingEndpointInterceptor);
        return interceptors.toArray(new EndpointInterceptor[interceptors.size()]);
    }
}

