/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import com.consol.citrus.message.ErrorHandlingStrategy;
import com.consol.citrus.simulator.SimulatorAutoConfiguration;
import com.consol.citrus.simulator.ws.SimulatorWebServiceClientConfigurationProperties;
import com.consol.citrus.simulator.ws.SimulatorWebServiceClientConfigurer;
import com.consol.citrus.simulator.ws.SimulatorWebServiceLoggingAutoConfiguration;
import com.consol.citrus.ws.client.WebServiceClient;
import com.consol.citrus.ws.interceptor.LoggingClientInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapMessageFactory;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;

@Configuration
@AutoConfigureAfter(value={SimulatorAutoConfiguration.class})
@Import(value={SimulatorWebServiceLoggingAutoConfiguration.class})
@EnableConfigurationProperties(value={SimulatorWebServiceClientConfigurationProperties.class})
@ConditionalOnProperty(prefix="citrus.simulator.ws.client", value={"enabled"}, havingValue="true")
public class SimulatorWebServiceClientAutoConfiguration {
    @Autowired(required=false)
    private SimulatorWebServiceClientConfigurer configurer;
    @Autowired
    private LoggingClientInterceptor loggingClientInterceptor;
    @Autowired
    private SimulatorWebServiceClientConfigurationProperties simulatorConfiguration;

    @Bean(name={"simulatorWsClientEndpoint"})
    public WebServiceClient webServiceClientEndpoint() {
        WebServiceClient endpoint = new WebServiceClient();
        endpoint.getEndpointConfiguration().setDefaultUri(this.getRequestUrl());
        endpoint.getEndpointConfiguration().setMessageFactory((WebServiceMessageFactory)this.getMessageFactory());
        endpoint.getEndpointConfiguration().setInterceptors(Arrays.asList(this.interceptors()));
        endpoint.getEndpointConfiguration().setErrorHandlingStrategy(ErrorHandlingStrategy.PROPAGATE);
        return endpoint;
    }

    @Bean
    protected SoapMessageFactory getMessageFactory() {
        return new SaajSoapMessageFactory();
    }

    protected String getRequestUrl() {
        if (this.configurer != null) {
            return this.configurer.requestUrl();
        }
        return this.simulatorConfiguration.getRequestUrl();
    }

    protected ClientInterceptor[] interceptors() {
        ArrayList<LoggingClientInterceptor> interceptors = new ArrayList<LoggingClientInterceptor>();
        if (this.configurer != null) {
            Collections.addAll(interceptors, this.configurer.interceptors());
        }
        interceptors.add(this.loggingClientInterceptor);
        return interceptors.toArray(new ClientInterceptor[interceptors.size()]);
    }
}

