/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="citrus.simulator.ws.client")
public class SimulatorWebServiceClientConfigurationProperties
implements EnvironmentAware {
    private static Logger log = LoggerFactory.getLogger(SimulatorWebServiceClientConfigurationProperties.class);
    private static final String SIMULATOR_WSCLIENT_REQUEST_URL_PROPERTY = "citrus.simulator.ws.client.request.url";
    private static final String SIMULATOR_WSCLIENT_REQUEST_URL_ENV = "SIMULATOR_WS_CLIENT_REQUEST_URL";
    private boolean enabled;
    private String requestUrl = "http://localhost:8080/services/ws/simulator";
    private Environment env;

    @PostConstruct
    private void loadProperties() {
        this.requestUrl = this.env.getProperty(SIMULATOR_WSCLIENT_REQUEST_URL_PROPERTY, this.env.getProperty(SIMULATOR_WSCLIENT_REQUEST_URL_ENV, this.requestUrl));
        log.info("Using the simulator configuration: {}", (Object)this.toString());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled='" + this.enabled + '\'' + ", requestUrl='" + this.requestUrl + '\'' + '}';
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }
}

