/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="citrus.simulator.ws")
public class SimulatorWebServiceConfigurationProperties
implements EnvironmentAware {
    private static Logger log = LoggerFactory.getLogger(SimulatorWebServiceConfigurationProperties.class);
    private static final String SIMULATOR_SERVLET_MAPPING_PROPERTY = "citrus.simulator.ws.servlet.mapping";
    private static final String SIMULATOR_SERVLET_MAPPING_ENV = "CITRUS_SIMULATOR_WS_SERVLET_MAPPING";
    private boolean enabled;
    private String servletMapping = "/services/ws/*";
    private Environment env;

    @PostConstruct
    private void loadProperties() {
        this.servletMapping = this.env.getProperty(SIMULATOR_SERVLET_MAPPING_PROPERTY, this.env.getProperty(SIMULATOR_SERVLET_MAPPING_ENV, this.servletMapping));
        log.info("Using the simulator configuration: {}", (Object)this.toString());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServletMapping() {
        return this.servletMapping;
    }

    public void setServletMapping(String servletMapping) {
        this.servletMapping = servletMapping;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled='" + this.enabled + '\'' + ", servletMapping='" + this.servletMapping + '\'' + '}';
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }
}

