/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.ws.interceptor.LoggingClientInterceptor;
import com.consol.citrus.ws.interceptor.LoggingEndpointInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={LoggingEndpointInterceptor.class, LoggingClientInterceptor.class})
@ConditionalOnWebApplication
public class SimulatorWebServiceLoggingAutoConfiguration {
    @Autowired
    private MessageListeners messageListeners;

    @Bean
    @ConditionalOnMissingBean(name={"simulatorLoggingEndpointInterceptor"})
    public LoggingEndpointInterceptor loggingEndpointInterceptor() {
        LoggingEndpointInterceptor loggingEndpointInterceptor = new LoggingEndpointInterceptor();
        loggingEndpointInterceptor.setMessageListener(this.messageListeners);
        return loggingEndpointInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean(name={"simulatorLoggingClientInterceptor"})
    public LoggingClientInterceptor loggingClientInterceptor() {
        LoggingClientInterceptor loggingClientInterceptor = new LoggingClientInterceptor();
        loggingClientInterceptor.setMessageListener(this.messageListeners);
        return loggingClientInterceptor;
    }
}

