/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapMessageFactory;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

public class SoapMessageHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SoapMessageHelper.class);
    @Autowired
    private SoapMessageFactory soapMessageFactory;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public String getSoapBody(Message request) throws SOAPException, IOException, TransformerException {
        MessageFactory msgFactory = MessageFactory.newInstance();
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type", "text/xml; charset=" + Charset.forName(System.getProperty("citrus.file.encoding", "UTF-8")));
        SOAPMessage message = msgFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(request.getPayload().toString().getBytes(System.getProperty("citrus.file.encoding", "UTF-8"))));
        SOAPBody soapBody = message.getSOAPBody();
        Document body = soapBody.extractContentAsDocument();
        StringResult result = new StringResult();
        this.transformerFactory.newTransformer().transform(new DOMSource(body), (Result)result);
        return result.toString();
    }

    public Message createSoapMessage(Message message) {
        try {
            String payload = message.getPayload().toString();
            LOG.info("Creating SOAP message from payload: " + payload);
            SoapMessage soapMessage = this.soapMessageFactory.createWebServiceMessage();
            this.transformerFactory.newTransformer().transform((Source)new StringSource(payload), soapMessage.getPayloadResult());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)bos);
            return new com.consol.citrus.ws.message.SoapMessage((Object)new String(bos.toByteArray()), message.getHeaders());
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to create SOAP message from payload resource", (Throwable)e);
        }
    }
}

