/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.simulator.exception.SimulatorException;
import com.consol.citrus.simulator.ws.WsdlOperationScenario;
import com.consol.citrus.xml.schema.locator.JarWSDLLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;

public class WsdlScenarioGenerator
implements BeanFactoryPostProcessor {
    private static Logger log = LoggerFactory.getLogger(WsdlScenarioGenerator.class);
    private final Resource wsdlResource;
    private WsdlScenarioNamingStrategy namingStrategy = WsdlScenarioNamingStrategy.INPUT;
    private static final String SIMULATOR_WSDL_LOCATION_PROPERTY = "citrus.simulator.ws.wsdl.location";
    private static final String SIMULATOR_WSDL_LOCATION_ENV = "CITRUS_SIMULATOR_WS_WSDL_LOCATION";

    public WsdlScenarioGenerator(Environment environment) {
        this.wsdlResource = new PathMatchingResourcePatternResolver().getResource(environment.getProperty(SIMULATOR_WSDL_LOCATION_PROPERTY, environment.getProperty(SIMULATOR_WSDL_LOCATION_ENV, "")));
    }

    public WsdlScenarioGenerator(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)this.wsdlResource, (String)"Missing either WSDL location system property setting or explicit WSDL resource for scenario auto generation");
        Definition wsdl = this.getWsdlDefinition(this.wsdlResource);
        XmlObject wsdlObject = this.compileWsdl(this.wsdlResource);
        SchemaTypeSystem schemaTypeSystem = this.compileXsd(wsdlObject);
        for (Object item : wsdl.getBindings().values()) {
            Binding binding = (Binding)item;
            for (Object operationItem : binding.getBindingOperations()) {
                String scenarioName;
                BindingOperation operation = (BindingOperation)operationItem;
                SchemaType requestElem = this.getSchemaType(schemaTypeSystem, operation.getName(), operation.getOperation().getInput().getName());
                SchemaType responseElem = this.getSchemaType(schemaTypeSystem, operation.getName(), operation.getOperation().getOutput().getName());
                String soapAction = "";
                List extensions = operation.getExtensibilityElements();
                if (extensions != null) {
                    for (int i = 0; i < extensions.size(); ++i) {
                        ExtensibilityElement extElement = (ExtensibilityElement)extensions.get(i);
                        if (!(extElement instanceof SOAPOperation)) continue;
                        SOAPOperation soapOp = (SOAPOperation)extElement;
                        soapAction = soapOp.getSoapActionURI();
                    }
                }
                switch (this.namingStrategy) {
                    case INPUT: {
                        scenarioName = operation.getOperation().getInput().getName();
                        break;
                    }
                    case OPERATION: {
                        scenarioName = operation.getOperation().getName();
                        break;
                    }
                    case SOAP_ACTION: {
                        scenarioName = soapAction;
                        break;
                    }
                    default: {
                        throw new SimulatorException("Unknown scenario naming strategy");
                    }
                }
                if (beanFactory instanceof BeanDefinitionRegistry) {
                    log.info("Register auto generated scenario as bean definition: " + scenarioName);
                    BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(WsdlOperationScenario.class).addConstructorArgValue((Object)operation).addPropertyValue("soapAction", (Object)soapAction).addPropertyValue("input", (Object)this.generateRequest(operation, SampleXmlUtil.createSampleForType((SchemaType)requestElem))).addPropertyValue("output", (Object)this.generateResponse(operation, SampleXmlUtil.createSampleForType((SchemaType)responseElem)));
                    if (beanFactory.containsBeanDefinition("inboundXmlDataDictionary")) {
                        beanDefinitionBuilder.addPropertyReference("inboundDataDictionary", "inboundXmlDataDictionary");
                    }
                    if (beanFactory.containsBeanDefinition("outboundXmlDataDictionary")) {
                        beanDefinitionBuilder.addPropertyReference("outboundDataDictionary", "outboundXmlDataDictionary");
                    }
                    ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(scenarioName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
                    continue;
                }
                log.info("Register auto generated scenario as singleton: " + scenarioName);
                WsdlOperationScenario scenario = this.createScenario(operation, soapAction, this.generateRequest(operation, SampleXmlUtil.createSampleForType((SchemaType)requestElem)), this.generateResponse(operation, SampleXmlUtil.createSampleForType((SchemaType)responseElem)));
                beanFactory.registerSingleton(scenarioName, (Object)scenario);
            }
        }
    }

    protected WsdlOperationScenario createScenario(BindingOperation operation, String soapAction, String input, String output) {
        return new WsdlOperationScenario(operation).withInput(input).withOutput(output).withSoapAction(soapAction);
    }

    protected String generateRequest(BindingOperation operation, String body) {
        return body;
    }

    protected String generateResponse(BindingOperation operation, String body) {
        return body;
    }

    private SchemaType getSchemaType(SchemaTypeSystem schemaTypeSystem, String operation, String elementName) {
        for (SchemaType elem : schemaTypeSystem.documentTypes()) {
            if (!elem.getContentModel().getName().getLocalPart().equals(elementName)) continue;
            return elem;
        }
        throw new SimulatorException("Unable to find schema type declaration '" + elementName + "' for WSDL operation '" + operation + "'");
    }

    private Definition getWsdlDefinition(Resource wsdl) {
        try {
            Definition definition = wsdl.getURI().toString().startsWith("jar:") ? WSDLFactory.newInstance().newWSDLReader().readWSDL((WSDLLocator)new JarWSDLLocator(wsdl)) : WSDLFactory.newInstance().newWSDLReader().readWSDL(wsdl.getURI().getPath(), new InputSource(wsdl.getInputStream()));
            return definition;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read wsdl file resource", (Throwable)e);
        }
        catch (WSDLException e) {
            throw new CitrusRuntimeException("Failed to create wsdl schema instance", (Throwable)e);
        }
    }

    private XmlObject compileWsdl(Resource wsdlResource) {
        try {
            File wsdlFile = wsdlResource.getFile();
            return XmlObject.Factory.parse((File)wsdlFile, (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
        }
        catch (XmlException e) {
            for (Object error : e.getErrors()) {
                log.error(((XmlError)error).getLine() + "" + error.toString());
            }
            throw new SimulatorException("WSDL could not be parsed", e);
        }
        catch (Exception e) {
            throw new SimulatorException("WSDL could not be parsed", e);
        }
    }

    private SchemaTypeSystem compileXsd(XmlObject wsdl) {
        String[] namespacesWsdl = this.extractNamespacesOnWsdlLevel(wsdl);
        String schemaNsPrefix = this.extractSchemaNamespacePrefix(wsdl);
        String[] schemas = this.getNestedSchemas(wsdl, namespacesWsdl, schemaNsPrefix);
        XmlObject[] xsd = new XmlObject[schemas.length];
        try {
            for (int i = 0; i < schemas.length; ++i) {
                xsd[i] = XmlObject.Factory.parse((String)schemas[i], (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
            }
        }
        catch (Exception e) {
            throw new SimulatorException("Failed to parse XSD schema", e);
        }
        SchemaTypeSystem schemaTypeSystem = null;
        try {
            schemaTypeSystem = XmlBeans.compileXsd((XmlObject[])xsd, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), (XmlOptions)new XmlOptions());
        }
        catch (XmlException e) {
            for (Object error : e.getErrors()) {
                log.error("Line " + ((XmlError)error).getLine() + ": " + error.toString());
            }
            throw new SimulatorException("Failed to compile XSD schema", e);
        }
        catch (Exception e) {
            throw new SimulatorException("Failed to compile XSD schema", e);
        }
        return schemaTypeSystem;
    }

    private String[] extractNamespacesOnWsdlLevel(XmlObject wsdl) {
        int cursor = wsdl.xmlText().indexOf(":") + ":definitions ".length();
        String nsWsdlOrig = wsdl.xmlText().substring(cursor, wsdl.xmlText().indexOf(">", cursor));
        int noNs = StringUtils.countOccurrencesOf((String)nsWsdlOrig, (String)"xmlns:");
        String[] namespacesWsdl = new String[noNs];
        cursor = 0;
        for (int i = 0; i < noNs; ++i) {
            int begin = nsWsdlOrig.indexOf("xmlns:", cursor);
            int end = nsWsdlOrig.indexOf("\"", begin + 20);
            namespacesWsdl[i] = nsWsdlOrig.substring(begin, end) + "\"";
            cursor = end;
        }
        return namespacesWsdl;
    }

    private String extractSchemaNamespacePrefix(XmlObject wsdl) {
        String schemaNsPrefix = "";
        if (wsdl.xmlText().contains(":schema")) {
            int cursor;
            for (int i = cursor = wsdl.xmlText().indexOf(":schema"); i > cursor - 100; --i) {
                schemaNsPrefix = wsdl.xmlText().substring(i, cursor);
                if (!schemaNsPrefix.startsWith("<")) continue;
                return schemaNsPrefix.substring(1) + ":";
            }
        }
        return schemaNsPrefix;
    }

    private String[] getNestedSchemas(XmlObject wsdl, String[] namespacesWsdl, String schemaNsPrefix) {
        ArrayList<String> schemas = new ArrayList<String>();
        String openedStartTag = "<" + schemaNsPrefix + "schema";
        String endTag = "</" + schemaNsPrefix + "schema>";
        int cursor = 0;
        while (wsdl.xmlText().indexOf(openedStartTag, cursor) != -1) {
            int begin = wsdl.xmlText().indexOf(openedStartTag, cursor);
            int end = wsdl.xmlText().indexOf(endTag, begin) + endTag.length();
            int insertPointNamespacesWsdl = wsdl.xmlText().indexOf(" ", begin);
            StringBuffer buf = new StringBuffer();
            buf.append(wsdl.xmlText().substring(begin, insertPointNamespacesWsdl)).append(" ");
            for (String nsWsdl : namespacesWsdl) {
                String nsPrefix = nsWsdl.substring(0, nsWsdl.indexOf("="));
                if (wsdl.xmlText().substring(begin, end).contains(nsPrefix)) continue;
                buf.append(nsWsdl).append(" ");
            }
            buf.append(wsdl.xmlText().substring(insertPointNamespacesWsdl, end));
            schemas.add(buf.toString());
            cursor = end;
        }
        return schemas.toArray(new String[0]);
    }

    public WsdlScenarioNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(WsdlScenarioNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public static enum WsdlScenarioNamingStrategy {
        INPUT,
        OPERATION,
        SOAP_ACTION;

    }
}

