/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent;

import com.contrastsecurity.agent.ContrastStarter;
import com.contrastsecurity.agent.boot.DenylistedProcessCheck;
import com.contrastsecurity.agent.injection.ClassInjector;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeModule;
import com.contrastsecurity.agent.scope.ScopeProvider;
import java.io.File;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ContrastLoaderAgent {
    private static final AtomicBoolean ATTACHED;
    private static final String BASE_INJECTIONS = "/com/contrastsecurity/agent/lib/contrast-agent-base-injections.jar";
    public static final File AGENT_JAR_FILE;

    public static void main(String[] args) {
        ContrastStarter.diagnostics(args);
    }

    public static void agentmain(String args, Instrumentation inst) {
        ContrastLoaderAgent.premain(args, inst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String args, Instrumentation inst) {
        if (ATTACHED.getAndSet(true)) {
            System.err.println("The Contrast Agent is already attached, verify that your VM arguments don't include `-javaagent` twice for the Contrast Agent.");
            return;
        }
        if (DenylistedProcessCheck.isDenied(ContrastLoaderAgent.getStartCommand())) {
            return;
        }
        ScopeProvider scopeProvider = ScopeModule.scopeProvider();
        ScopeAggregator scope = scopeProvider.scope();
        scope.enterScope();
        long premainStart = System.nanoTime();
        long jvmUptime = ContrastLoaderAgent.getJvmUptime();
        try {
            try {
                ClassInjector.inject(inst);
            }
            catch (AccessControlException e2) {
                throw e2;
            }
            catch (Exception e3) {
                e3.printStackTrace(System.err);
                System.err.println("Unexpected error during Contrast Agent initialization. Continuing application startup without Contrast Agent....");
                scope.leaveScope();
                return;
            }
            ContrastStarter.start(args, inst, premainStart, jvmUptime);
        }
        catch (AccessControlException e4) {
            System.err.println("When using a Java SecurityManager, the Contrast agent requires the java.security.AllPermission. Continuing without Contrast...");
            e4.printStackTrace(System.err);
        }
        finally {
            scope.leaveScope();
        }
    }

    public static InputStream getBaseInjectionsAsStream() {
        return ContrastLoaderAgent.class.getResourceAsStream(BASE_INJECTIONS);
    }

    private static long getJvmUptime() {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        return mxBean != null ? mxBean.getUptime() : 0L;
    }

    private static String getStartCommand() {
        try {
            return System.getSecurityManager() == null ? System.getProperty("sun.java.command") : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("sun.java.command");
                }
            });
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private ContrastLoaderAgent() {
    }

    static {
        File agentJar;
        ATTACHED = new AtomicBoolean();
        try {
            agentJar = new File(ContrastLoaderAgent.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        }
        catch (NullPointerException e2) {
            agentJar = new File(System.getProperty("contrast.agent.location"));
        }
        AGENT_JAR_FILE = agentJar;
    }
}

