/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.action.analyzelog;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.action.analyzelog.b;
import com.contrastsecurity.agent.action.analyzelog.i;
import com.contrastsecurity.agent.http.n;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.apache.commons.io.FileUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.io.LineIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

@DontObfuscate
final class TimelineFilter
implements b {
    private final File timelineJsonFile;
    private final File tmp;
    private static boolean ALREADY_ERRORED;
    private static final String LM_TOKEN = "!LM!";

    TimelineFilter(File file) {
        this.timelineJsonFile = file;
        try {
            this.tmp = File.createTempFile("timeline", "dat");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to create temporary file", iOException);
        }
    }

    @Override
    public void onLineRead(String string, boolean bl) {
        if (!bl && this.isLogMarkerLine(string)) {
            try {
                this.process(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void process(String string) {
        i i2 = i.a(string);
        Event event = this.parseEvent(i2.g());
        event.time = i2.c();
        this.saveEventToTimeline(event);
    }

    Event parseEvent(String string) {
        Event event = new Event();
        String[] stringArray = string.split("\\|", 5);
        event.category = stringArray[0].substring(4);
        event.subcategory = stringArray[1];
        try {
            event.supportingData = this.convertToMap(stringArray[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return event;
    }

    boolean isLogMarkerLine(String string) {
        return string.contains(LM_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLogFinished() {
        FileWriter fileWriter = null;
        PrintWriter printWriter = null;
        try {
            fileWriter = new FileWriter(this.timelineJsonFile);
            printWriter = new PrintWriter(fileWriter);
            printWriter.println(" { ");
            printWriter.println(" \"data\":[");
            if (this.tmp.exists() && this.tmp.canRead()) {
                this.writeToJsonFile(printWriter, this.tmp);
            }
            printWriter.println(" ]");
            printWriter.println("}");
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                IOUtils.closeQuietly(printWriter);
                throw throwable;
            }
            IOUtils.closeQuietly(fileWriter);
            IOUtils.closeQuietly(printWriter);
        }
        IOUtils.closeQuietly(fileWriter);
        IOUtils.closeQuietly(printWriter);
    }

    private void writeToJsonFile(PrintWriter printWriter, File file) throws IOException {
        LineIterator lineIterator = FileUtils.lineIterator(file);
        while (lineIterator.hasNext()) {
            String string = lineIterator.next();
            printWriter.print("\t");
            printWriter.print(string);
            if (lineIterator.hasNext()) {
                printWriter.print(",");
            }
            printWriter.println();
        }
    }

    void saveEventToTimeline(Event event) {
        block3: {
            String string = ObjectShare.GSON.toJson(event);
            if (!string.endsWith("\n")) {
                string = string + ObjectShare.LINE_SEPARATOR;
            }
            try {
                FileUtils.writeStringToFile(this.tmp, string, true);
            }
            catch (IOException iOException) {
                if (ALREADY_ERRORED) break block3;
                ALREADY_ERRORED = true;
                iOException.printStackTrace();
            }
        }
    }

    private Map<String, String[]> convertToMap(String string) {
        return n.a(string);
    }

    @DontObfuscate
    static final class Event {
        @DontObfuscate
        long time;
        @DontObfuscate
        String category;
        @DontObfuscate
        String subcategory;
        @DontObfuscate
        Map<String, String[]> supportingData;

        Event() {
        }
    }
}

