/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.f;
import com.contrastsecurity.agent.apps.h;
import com.contrastsecurity.agent.apps.java.c;
import com.contrastsecurity.agent.apps.java.codeinfo.b;
import com.contrastsecurity.agent.apps.java.codeinfo.d;
import com.contrastsecurity.agent.apps.java.e;
import com.contrastsecurity.agent.c.b;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.s;
import com.contrastsecurity.agent.config.v;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.frameworks.G;
import com.contrastsecurity.agent.plugins.frameworks.p;
import com.contrastsecurity.agent.plugins.g;
import com.contrastsecurity.agent.services.Purgeable;
import com.contrastsecurity.agent.telemetry.b.i;
import com.contrastsecurity.agent.u;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Sensor
public class ApplicationManager
implements Purgeable {
    private static final Logger b = LoggerFactory.getLogger(ApplicationManager.class);
    private final ThreadLocal<Application> c = new ThreadLocal();
    private final AtomicReference<Application.a> d;
    private final Map<String, Application> e;
    private final ConcurrentReferenceHashMap<ClassLoader, Set<Application>> f;
    private final g g;
    private final com.contrastsecurity.agent.config.g h;
    private final a i;
    private final h j;
    private boolean k;
    private final com.contrastsecurity.agent.c.b l;
    private final s m;
    @z
    static final String a = "numberOfApplications";

    public ApplicationManager(com.contrastsecurity.agent.config.g g2, b b2, g g3, com.contrastsecurity.agent.commons.d d2, h h2, s s2, i i2) {
        this(g2, b2, g3, d2, h2, new Application.a(g2), s2, i2);
    }

    @z
    ApplicationManager(com.contrastsecurity.agent.config.g g2, b b2, g g3, com.contrastsecurity.agent.commons.d d2, h h2, Application.a a2, s s2, i i2) {
        this.g = Objects.requireNonNull(g3);
        this.h = Objects.requireNonNull(g2);
        this.j = Objects.requireNonNull(h2);
        this.d = new AtomicReference<Application.a>(Objects.requireNonNull(a2));
        this.i = new a(Objects.requireNonNull(b2), d2, g2);
        this.e = new ConcurrentHashMap<String, Application>();
        this.f = new ConcurrentReferenceHashMap(10, ConcurrentReferenceHashMap.c.b, ConcurrentReferenceHashMap.c.a);
        this.l = new b.a();
        if (this.d.get().a()) {
            this.enableStandaloneMode(null, null);
        }
        this.m = s2;
        g2.a(this.m);
        i2.b(a, i.a.b).a("Describes the number of applications currently served by this Agent instance.").a(this, (T object) -> this.size()).a();
    }

    @Override
    public void purgeStale() {
        this.i.purgeStale();
        this.f.purgeStaleEntries();
    }

    @Override
    public int purgeableCount() {
        return this.i.purgeableCount();
    }

    public Application enableStandaloneMode(String string, String string2) {
        if (this.k) {
            b.debug("Standalone mode already turned on");
            return this.d.get().b();
        }
        Application application = this.d.get().b();
        this.d.get().a(string, string2);
        this.a(application);
        this.k = true;
        return this.d.get().b();
    }

    public void current(Application application) {
        if (application == null) {
            this.c.remove();
            return;
        }
        if (application == this.d.get().b()) {
            return;
        }
        this.c.set(application);
    }

    public Application current() {
        Application application = this.a();
        return application == null || application.isUnwantedOnServer() ? null : application;
    }

    private Application a() {
        if (this.k) {
            return this.d.get().b();
        }
        Application application = this.c.get();
        if (application != null) {
            return application;
        }
        Collection<Application> collection = this.findByClassLoader(u.a(Thread.currentThread()));
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return null;
    }

    public Application createApplication(String string, String string2, String string3, String string4, String string5, String string6, ClassLoader classLoader, Application.b b2) {
        com.contrastsecurity.agent.e.c c2 = new com.contrastsecurity.agent.e.c();
        if (StringUtils.isNotBlank(string4)) {
            if (v.a(string4)) {
                this.h.a((com.contrastsecurity.agent.e.b)c2, string4);
            } else {
                b.error(v.c(string4));
            }
        }
        ClassLoader classLoader2 = classLoader == null ? u.a(Thread.currentThread()) : classLoader;
        Application application = new Application(string, string2, string3, this.h, string5, string6, b2, c2, classLoader2);
        b.debug("Created new application {}", (Object)application);
        this.e.put(application.c(), application);
        this.a(application, classLoader2);
        if (this.k) {
            application.markUnwantedOnServer();
            this.d.get().c();
        }
        this.m.a(application);
        b.debug("App {} has been created and is ready for creation on remote server", (Object)application);
        return application;
    }

    public Application findByKey(String string) {
        if (string == null || this.e.isEmpty()) {
            b.trace("Key was null or there were no applications, key: {}", (Object)string);
            return null;
        }
        Application application = this.e.get(string);
        b.trace("ApplicationManager#findByKey: key: {}, app: {}", (Object)string, (Object)application);
        return application;
    }

    public Collection<Application> findByClassLoader(ClassLoader classLoader) {
        Collection collection;
        if (!this.f.keys().hasMoreElements()) {
            return Collections.emptySet();
        }
        if (classLoader == null) {
            b.trace("ClassLoader was null, assuming Bootstrap ClassLoader and returning all apps");
            collection = this.e.values();
        } else {
            collection = this.f.getOrDefault(classLoader, Collections.emptySet());
        }
        b.trace("ApplicationManager#findByClassLoader: classLoader: {}, apps: {}", (Object)classLoader, (Object)collection);
        return Collections.unmodifiableCollection(collection);
    }

    public int size() {
        return this.k ? 1 : this.e.size();
    }

    public Collection<Application> getApplications() {
        return this.k ? Collections.singleton(this.d.get().b()) : Collections.unmodifiableCollection(this.e.values());
    }

    public void onApplicationUpdate(Application application) {
        if (application == null || application.isUnwantedOnServer()) {
            return;
        }
        this.j.a(application.a(), application);
    }

    public void inventory(p p2, Application application) {
        if (!application.getState().a() && !this.k) {
            b.debug("Application is not ready or has already been inventoried: {}", (Object)application);
        }
        if (this.k) {
            Application.a a2 = this.d.get();
            for (Application application2 : this.e.values()) {
                application2.created();
                if ((!application2.getState().a() || !this.b(p2, application2)) && !application2.isDirty()) continue;
                a2.a(application2);
            }
        } else {
            this.d.get().d();
        }
        this.b(p2, application);
    }

    private boolean b(p p2, Application application) {
        if (application.f()) {
            if (com.contrastsecurity.agent.apps.f.a(this.h, ConfigProperty.INVENTORY_LIBRARIES)) {
                this.c(p2, application);
            } else {
                b.debug("Ignoring framework library analysis");
            }
            application.e();
            b.debug("Application successfully inventoried: {}", (Object)application);
            for (ContrastPlugin contrastPlugin : this.g.getPlugins()) {
                contrastPlugin.onApplicationInventoried(application);
            }
            return true;
        }
        return false;
    }

    private void a(Application application) {
        this.a(application, null);
    }

    private void a(Application application, ClassLoader classLoader2) {
        ClassLoader classLoader3;
        ClassLoader classLoader4 = classLoader3 = classLoader2 == null ? u.a(Thread.currentThread()) : classLoader2;
        if (classLoader3 == null) {
            b.debug("ClassLoader was null, assuming Bootstrap ClassLoader");
            return;
        }
        this.l.a(classLoader3).forEach(classLoader -> this.f.merge((ClassLoader)classLoader, Collections.singleton(application), (set, set2) -> Stream.of(set, set2).flatMap(Collection::stream).collect(Collectors.toSet())));
    }

    @z
    Set<d> a(p p2, Application application) {
        LinkedHashSet<d> linkedHashSet = new LinkedHashSet<d>();
        List<G> list = p2.c();
        com.contrastsecurity.agent.apps.java.codeinfo.a a2 = this.i.a();
        if (this.k || this.h.e(application.context(), ConfigProperty.CLASSPATH_LIBS)) {
            linkedHashSet.add(new c(a2));
        }
        for (G object : list) {
            object.a(linkedHashSet, application, a2);
        }
        String string = this.h.b(application.context(), ConfigProperty.EXTERNAL_LIB_DIR);
        if (StringUtils.isNotBlank(string)) {
            List<String> list2 = Collections.unmodifiableList(Arrays.asList(string.split(File.pathSeparator)));
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string2 : list2) {
                File file = new File(string2);
                if (file.exists() && file.isDirectory()) {
                    arrayList.add(new File(string2));
                    continue;
                }
                b.warn("Skipping external library directory: {} because it does not exist or is not a directory.", (Object)string2);
            }
            linkedHashSet.add(new e(a2, arrayList));
        }
        b.debug("Application {} will use the following LibraryFinders: {}", (Object)application, (Object)linkedHashSet);
        return linkedHashSet;
    }

    private void c(p p2, Application application) {
        Set<d> set = this.a(p2, application);
        for (d d2 : set) {
            d2.a(application);
        }
    }

    private static final class a
    implements Purgeable {
        private final b a;
        private final long b;
        private final com.contrastsecurity.agent.commons.d c;
        private com.contrastsecurity.agent.apps.java.codeinfo.a d;
        private long e;

        private a(b b2, com.contrastsecurity.agent.commons.d d2, com.contrastsecurity.agent.config.g g2) {
            this.a = b2;
            this.c = d2;
            this.b = g2.e(ConfigProperty.APPMGR_JARANALYZER_TTL);
        }

        private synchronized com.contrastsecurity.agent.apps.java.codeinfo.a a() {
            if (this.d == null) {
                this.e = this.c.a();
                this.d = this.a.a();
            }
            return this.d;
        }

        @Override
        public synchronized void purgeStale() {
            if (this.c.a() - this.e >= this.b) {
                this.d = null;
            }
        }

        @Override
        public int purgeableCount() {
            return this.d == null ? 0 : 1;
        }
    }
}

