/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.contrastapi_v1_0;

import com.contrastsecurity.agent.commons.i;
import com.contrastsecurity.agent.messages.HTTPRequestID;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class HttpRequestDTM {
    private final String body;
    private final String contextPath;
    private final Map<String, List<String>> headers;
    private final String method;
    private final transient HTTPRequestID requestID;
    private final String normalizedUri;
    private final Map<String, List<String>> parameters;
    private final Integer port;
    private final Protocol protocol;
    private final String queryString;
    private final String serverVersionInfo;
    private final String uri;
    private final HttpVersion version;

    private HttpRequestDTM(Builder builder) {
        this.body = builder.body;
        this.contextPath = builder.contextPath;
        this.headers = builder.headers;
        this.method = builder.method;
        this.requestID = builder.requestID;
        this.normalizedUri = builder.normalizedUri;
        this.parameters = builder.parameters;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.queryString = builder.queryString;
        this.serverVersionInfo = builder.serverVersionInfo;
        this.uri = builder.uri;
        this.version = builder.version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String body() {
        return this.body;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String method() {
        return this.method;
    }

    public String normalizedUri() {
        return this.normalizedUri;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Integer port() {
        return this.port;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String queryString() {
        return this.queryString;
    }

    public String serverVersionInfo() {
        return this.serverVersionInfo;
    }

    public String uri() {
        return this.uri;
    }

    public HttpVersion version() {
        return this.version;
    }

    public HTTPRequestID requestID() {
        return this.requestID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpRequestDTM httpRequestDTM = (HttpRequestDTM)object;
        if (this.body != null ? !this.body.equals(httpRequestDTM.body) : httpRequestDTM.body != null) {
            return false;
        }
        if (this.contextPath != null ? !this.contextPath.equals(httpRequestDTM.contextPath) : httpRequestDTM.contextPath != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(httpRequestDTM.headers) : httpRequestDTM.headers != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(httpRequestDTM.method) : httpRequestDTM.method != null) {
            return false;
        }
        if (this.normalizedUri != null ? !this.normalizedUri.equals(httpRequestDTM.normalizedUri) : httpRequestDTM.normalizedUri != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(httpRequestDTM.parameters) : httpRequestDTM.parameters != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(httpRequestDTM.port) : httpRequestDTM.port != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals((Object)httpRequestDTM.protocol) : httpRequestDTM.protocol != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(httpRequestDTM.queryString) : httpRequestDTM.queryString != null) {
            return false;
        }
        if (this.serverVersionInfo != null ? !this.serverVersionInfo.equals(httpRequestDTM.serverVersionInfo) : httpRequestDTM.serverVersionInfo != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(httpRequestDTM.uri) : httpRequestDTM.uri != null) {
            return false;
        }
        return this.version != null ? this.version.equals((Object)httpRequestDTM.version) : httpRequestDTM.version == null;
    }

    public int hashCode() {
        int n2 = this.body != null ? this.body.hashCode() : 0;
        n2 = 31 * n2 + (this.contextPath != null ? this.contextPath.hashCode() : 0);
        n2 = 31 * n2 + (this.headers != null ? this.headers.hashCode() : 0);
        n2 = 31 * n2 + (this.method != null ? this.method.hashCode() : 0);
        n2 = 31 * n2 + (this.normalizedUri != null ? this.normalizedUri.hashCode() : 0);
        n2 = 31 * n2 + (this.parameters != null ? this.parameters.hashCode() : 0);
        n2 = 31 * n2 + (this.port != null ? this.port.hashCode() : 0);
        n2 = 31 * n2 + (this.protocol != null ? this.protocol.hashCode() : 0);
        n2 = 31 * n2 + (this.queryString != null ? this.queryString.hashCode() : 0);
        n2 = 31 * n2 + (this.serverVersionInfo != null ? this.serverVersionInfo.hashCode() : 0);
        n2 = 31 * n2 + (this.uri != null ? this.uri.hashCode() : 0);
        n2 = 31 * n2 + (this.version != null ? this.version.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "HttpRequestDTM{body='" + this.body + '\'' + ", headers=" + this.headers + ", method='" + this.method + '\'' + ", parameters=" + this.parameters + ", port=" + this.port + ", protocol='" + (Object)((Object)this.protocol) + '\'' + ", queryString='" + this.queryString + '\'' + ", uri='" + this.uri + '\'' + ", version='" + (Object)((Object)this.version) + '\'' + '}';
    }

    public static final class Builder {
        private String body;
        private String contextPath;
        private Map<String, List<String>> headers;
        private String method;
        private HTTPRequestID requestID;
        private String normalizedUri;
        private Map<String, List<String>> parameters;
        private Integer port;
        private Protocol protocol;
        private String queryString;
        private String serverVersionInfo;
        private String uri;
        private HttpVersion version;

        public Builder() {
        }

        public Builder(HttpRequestDTM httpRequestDTM) {
            this.body = httpRequestDTM.body;
            this.contextPath = httpRequestDTM.contextPath;
            this.headers = httpRequestDTM.headers;
            this.method = httpRequestDTM.method;
            this.requestID = httpRequestDTM.requestID;
            this.normalizedUri = httpRequestDTM.normalizedUri;
            this.parameters = httpRequestDTM.parameters;
            this.port = httpRequestDTM.port;
            this.protocol = httpRequestDTM.protocol;
            this.queryString = httpRequestDTM.queryString;
            this.serverVersionInfo = httpRequestDTM.serverVersionInfo;
            this.uri = httpRequestDTM.uri;
            this.version = httpRequestDTM.version;
        }

        public Builder body(String string) {
            this.body = string;
            return this;
        }

        public Builder contextPath(String string) {
            this.contextPath = string;
            return this;
        }

        public Builder headers(Map<String, List<String>> map) {
            if (map == null) {
                this.headers = Collections.emptyMap();
                return this;
            }
            this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(map);
            return this;
        }

        public Builder method(String string) {
            this.method = string;
            return this;
        }

        public Builder requestID(HTTPRequestID hTTPRequestID) {
            this.requestID = hTTPRequestID;
            return this;
        }

        public Builder normalizedUri(String string) {
            this.normalizedUri = string;
            return this;
        }

        public Builder parameters(Map<String, List<String>> map) {
            this.parameters = map != null ? i.a(map) : Collections.emptyMap();
            return this;
        }

        public Builder port(Integer n2) {
            this.port = n2;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder queryString(String string) {
            this.queryString = string;
            return this;
        }

        public Builder serverVersionInfo(String string) {
            this.serverVersionInfo = string;
            return this;
        }

        public Builder uri(String string) {
            this.uri = string;
            return this;
        }

        public Builder version(HttpVersion httpVersion) {
            this.version = httpVersion;
            return this;
        }

        public HttpRequestDTM build() {
            return new HttpRequestDTM(this);
        }
    }
}

