/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.eventbus;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.java.codeinfo.LibraryFacts;
import com.contrastsecurity.agent.eventbus.c;
import com.contrastsecurity.agent.messages.mq.HttpRequestResponseDTM;
import com.contrastsecurity.agent.messages.mq.MQProtectSampleDTM;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Objects;

@DontObfuscate
public class EventBus
implements c {
    static final EventBus INSTANCE = new EventBus();
    private c listener;
    private static final Logger logger = LoggerFactory.getLogger(EventBus.class);

    public static EventBus get() {
        return INSTANCE;
    }

    private EventBus() {
    }

    public void setEventListener(c c2) {
        Objects.requireNonNull(c2);
        this.listener = c2;
    }

    @Override
    public void onApplicationResolved(Application application) {
        if (this.listener != null) {
            try {
                this.listener.onApplicationResolved(application);
            }
            catch (Exception exception) {
                logger.error("Problem handling app profiling event: app {}", (Object)application, (Object)exception);
            }
        }
    }

    @Override
    public void onFindingDiscovered(Finding finding) {
        if (this.listener != null) {
            try {
                this.listener.onFindingDiscovered(finding);
            }
            catch (Exception exception) {
                logger.error("Problem handling new vulnerability event: {}/{}", finding.getRuleId(), finding.getHash(), exception);
            }
        }
    }

    @Override
    public void onProtectSampleCollected(MQProtectSampleDTM mQProtectSampleDTM) {
        if (this.listener != null) {
            this.listener.onProtectSampleCollected(mQProtectSampleDTM);
        }
    }

    @Override
    public void onLibraryFound(Application application, LibraryFacts libraryFacts) {
        if (this.listener != null) {
            this.listener.onLibraryFound(application, libraryFacts);
        }
    }

    @Override
    public void onSuccessfulURIActivity(String string) {
        if (this.listener != null) {
            this.listener.onSuccessfulURIActivity(string);
        }
    }

    @Override
    public void onNewHttpRequestResponse(HttpRequestResponseDTM httpRequestResponseDTM) {
        if (this.listener != null) {
            this.listener.onNewHttpRequestResponse(httpRequestResponseDTM);
        }
    }
}

