/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.eventbus.EventBus;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.a;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.http.o;
import com.contrastsecurity.agent.messages.mq.HttpRequestResponseDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.g;
import com.contrastsecurity.agent.plugins.protect.d.k;
import com.contrastsecurity.agent.util.F;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.org.apache.commons.io.FileUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@DontObfuscate
public class HttpManager
implements a {
    private final g config;
    private final com.contrastsecurity.agent.plugins.g pluginManager;
    private final ApplicationManager applicationManager;
    private final StartupTiming startupTiming;
    private final AtomicBoolean isFirstRequestAndProfilingStartup;
    private final ThreadLocal<HttpRequest> httpRequest = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<HttpResponse> httpResponse = ThreadLocal.withInitial(() -> null);
    private final int maxRetainedBufferSize;
    private static final Logger logger = LoggerFactory.getLogger(HttpManager.class);

    public HttpManager(g g2, com.contrastsecurity.agent.plugins.g g3, ApplicationManager applicationManager, StartupTiming startupTiming) {
        this.config = g2;
        this.pluginManager = g3;
        this.applicationManager = applicationManager;
        this.startupTiming = startupTiming;
        this.isFirstRequestAndProfilingStartup = new AtomicBoolean(startupTiming != null);
        this.maxRetainedBufferSize = g2.d(ConfigProperty.MAX_RETAINED_BUFFER_SIZE);
    }

    public HttpRequest getCurrentRequest() {
        return this.httpRequest.get();
    }

    public HttpRequest cloneCurrentRequest() {
        HttpRequest httpRequest = this.getCurrentRequest();
        return httpRequest == null ? null : httpRequest.copy();
    }

    public void setCurrentRequest(HttpRequest httpRequest) {
        try {
            this.updateRequestCrumbs(httpRequest);
        }
        catch (Exception exception) {
            logger.error("Problem updating HTTP request crumbs", exception);
        }
        if (httpRequest == null) {
            this.httpRequest.remove();
        } else {
            this.httpRequest.set(httpRequest);
        }
    }

    public void setCurrentResponse(HttpResponse httpResponse) {
        try {
            this.updateResponseBreadCrumbs(httpResponse);
        }
        catch (Exception exception) {
            logger.error("Problem updating HTTP response crumbs", exception);
        }
        if (httpResponse == null) {
            this.httpResponse.remove();
        } else {
            this.httpResponse.set(httpResponse);
        }
    }

    public HttpResponse getCurrentResponse() {
        return this.httpResponse.get();
    }

    private void updateRequestCrumbs(HttpRequest httpRequest) {
        if (httpRequest == null) {
            HttpRequest httpRequest2 = this.httpRequest.get();
            if (httpRequest2 != null) {
                httpRequest2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpRequest.updateBreadCrumbs(b.b.b);
        }
    }

    private void updateResponseBreadCrumbs(HttpResponse httpResponse) {
        if (httpResponse == null) {
            HttpResponse httpResponse2 = this.httpResponse.get();
            if (httpResponse2 != null) {
                httpResponse2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpResponse.updateBreadCrumbs(b.b.b);
        }
    }

    public void onRequestStart(HttpRequest httpRequest) {
        httpRequest.reset(this.maxRetainedBufferSize);
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        this.onRequestStartAction(list, httpRequest, true);
        List<ContrastPlugin> list2 = a2.b();
        this.onRequestStartAction(list2, httpRequest, false);
    }

    private void onRequestStartAction(List<ContrastPlugin> list, HttpRequest httpRequest, boolean bl) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                if (bl) {
                    o2.a(httpRequest);
                    continue;
                }
                o2.a();
            }
        }
    }

    public void onResponseStart(HttpRequest httpRequest, HttpResponse httpResponse) {
        httpResponse.getMemoryBuffer().a(this.maxRetainedBufferSize);
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                o2.a(httpRequest, httpResponse);
            }
        }
    }

    public void onRequestEnd() {
        Object object;
        HttpRequest httpRequest = this.getCurrentRequest();
        HttpResponse httpResponse = this.getCurrentResponse();
        if (httpRequest != null && httpResponse != null) {
            EventBus.get().onNewHttpRequestResponse(new HttpRequestResponseDTM(httpRequest.toMqHttpRequestDTM(), httpResponse.toHttpResponseDTM()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Request ending for {} - response is {} and output mechanism is {}", httpRequest != null ? httpRequest.getUri() : "(null)", N.a(httpResponse), httpResponse != null ? N.a(httpResponse.getOutputMechanism()) : "response-null");
            if (httpResponse != null && httpResponse.getOutputMechanism() != null) {
                object = httpResponse.getOutputMechanism();
                logger.debug("De-assigning output mechanism {}", (Object)N.a(object));
            }
        }
        if (httpResponse != null && httpResponse.isCapturingInFile()) {
            logger.debug("Closing response file");
            try {
                httpResponse.closeFileBuffer();
            }
            catch (IOException iOException) {
                logger.error("Problem closing response file buffer", iOException);
            }
        }
        if (httpRequest != null && httpRequest.isScanningResponse()) {
            this.analyzeResponseContents(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled() && (httpRequest == null || httpResponse == null)) {
            this.logCrumbData(httpRequest, httpResponse);
        }
        object = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = ((g.a)object).a();
        this.onRequestEndAction(list, httpRequest, httpResponse, true);
        List<ContrastPlugin> list2 = ((g.a)object).b();
        this.onRequestEndAction(list2, httpRequest, httpResponse, false);
        if (httpRequest != null) {
            httpRequest.reset(this.maxRetainedBufferSize);
        }
        if (httpResponse != null) {
            httpResponse.getMemoryBuffer().a(this.maxRetainedBufferSize);
        }
        this.setCurrentRequest(null);
        this.setCurrentResponse(null);
        this.applicationManager.current(null);
        if (httpRequest == null) {
            return;
        }
        httpRequest.markEndTime();
        long l2 = httpRequest.elapsedTimeMs();
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|RequestEnded|uri={}&elapsed={}", "!LM!", "RequestTime", httpRequest.getNormalizedUri(), l2);
        }
        if (this.isFirstRequestAndProfilingStartup.getAndSet(false)) {
            PerfUtil.writeStartupStats(this.startupTiming, l2, this.config);
        }
    }

    private void onRequestEndAction(List<ContrastPlugin> list, HttpRequest httpRequest, HttpResponse httpResponse, boolean bl) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                try {
                    if (bl) {
                        o2.b(httpRequest, httpResponse);
                        continue;
                    }
                    o2.b();
                    continue;
                }
                catch (Throwable throwable) {
                    logger.warn("Problem ending request watching with {}", (Object)o2, (Object)throwable);
                }
            }
        }
    }

    @z
    void analyzeResponseContents(HttpRequest httpRequest, HttpResponse httpResponse) {
        byte[] byArray;
        if (httpRequest == null) {
            logger.debug("HttpRequest was null");
            return;
        }
        String string = httpRequest.getUri();
        if (httpResponse == null || httpResponse.isEmpty()) {
            logger.debug("Response was null or empty for URI {}", (Object)string);
            return;
        }
        logger.debug("Scanning response for {}", (Object)string);
        F f2 = httpResponse.getMemoryBuffer().a(Charset.defaultCharset());
        if (httpResponse.isCapturingInMemory()) {
            byArray = f2.b();
        } else if (httpResponse.isCapturingInFile()) {
            byArray = this.readFile(httpResponse.getFileBufferPath());
        } else {
            logger.warn("Problem scanning response to {}: nothing captured in memory or file!", (Object)string);
            byArray = ObjectShare.EMPTY_BYTE_ARRAY;
        }
        String string2 = httpResponse.getCharacterEncoding();
        try {
            if (string2 == null || !Charset.isSupported(string2)) {
                string2 = Charset.defaultCharset().name();
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            String string3 = Charset.defaultCharset().name();
            logger.error("Encountered a strange charset encoding of '{}', falling back to '{}'", (Object)string2, (Object)string3);
            string2 = string3;
        }
        try {
            String string4 = httpResponse.isCapturingInMemory() ? new String(byArray, 0, f2.a(), string2) : new String(byArray, string2);
            logger.debug("Scanning {} response text with length {}/charset {}", string, string4.length(), string2);
            this.delegateResponseWrittenEvent(httpRequest, httpResponse, string4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Couldn't parse response body because of weird encoding", unsupportedEncodingException);
        }
    }

    private void logCrumbData(HttpRequest httpRequest, HttpResponse httpResponse) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\t\t").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")\n");
        }
        logger.debug("Unexpected null(s) - request=[{}], response=[{}], CRUMB:\n{}", httpRequest, httpResponse, stringBuilder);
    }

    private void delegateResponseWrittenEvent(HttpRequest httpRequest, HttpResponse httpResponse, String string) {
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                try {
                    o2.a(httpRequest, httpResponse, string);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.warn("Problem ending request watching with {}", (Object)o2, (Object)throwable);
                }
            }
        }
    }

    public void onMultipartHeaderRead(HttpRequest httpRequest, MultipartItem multipartItem) {
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                o2.a(httpRequest, multipartItem);
            }
        }
    }

    public void onMultipartBodyRead(HttpRequest httpRequest, MultipartItem multipartItem) {
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                o2.b(httpRequest, multipartItem);
            }
        }
    }

    public void onParametersResolved(HttpRequest httpRequest) {
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                o2.b(httpRequest);
            }
        }
    }

    public void onMoreParametersResolved(HttpRequest httpRequest, Map<String, String[]> map) {
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                o2.a(httpRequest, map);
            }
        }
    }

    @Override
    public void onBodyInputReceived(k k2, String string, String string2) {
        g.a a2 = this.pluginManager.getPluginsByRequest(this.applicationManager.current(), this.getCurrentRequest());
        List<ContrastPlugin> list = a2.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            List<o> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                o o2 = list2.get(i3);
                o2.a(string, string2, k2);
            }
        }
    }

    private byte[] readFile(String string) {
        byte[] byArray = ObjectShare.EMPTY_BYTE_ARRAY;
        try {
            byArray = FileUtils.readFileToByteArray(new File(string));
        }
        catch (IOException iOException) {
            logger.error("Problem reading response file", iOException);
        }
        return byArray;
    }
}

