/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.injection;

import com.contrastsecurity.agent.ContrastLoaderAgent;
import com.contrastsecurity.agent.injection.Injector;
import com.contrastsecurity.agent.injection.MethodHandlesInjector;
import com.contrastsecurity.agent.injection.UnsafeInjector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ClassInjector {
    private static final Pattern DISPATCHER_REGEX = Pattern.compile("^java/lang/(.+)Dispatcher$");
    private static final Pattern MODEL_REGEX = Pattern.compile("^java/lang/(.+)Model$");
    private static final Pattern LOCATOR_INTERFACE_REGEX = Pattern.compile("^java/lang/(.+)Locator$");
    private static final Pattern LOCATOR_SINGLETON_REGEX = Pattern.compile("^java/lang/(.+)Locator\\$Singleton$");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static void inject(Instrumentation inst) {
        if (!ClassInjector.doesSupportModules()) {
            ClassInjector.injectBaseInjections(new UnsafeInjector());
        } else {
            ClassInjector.redefineJavaBaseModule(inst);
            ClassInjector.injectBaseInjections(new MethodHandlesInjector());
        }
    }

    public static boolean doesSupportModules() {
        try {
            Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        return true;
    }

    private static void redefineJavaBaseModule(Instrumentation instrumentation) {
        if (!ClassInjector.doesSupportModules()) {
            return;
        }
        try {
            Instrumentation.class.getMethod("redefineModule", Class.forName("java.lang.Module"), Set.class, Map.class, Map.class, Set.class, Map.class).invoke((Object)instrumentation, ClassInjector.getModule(Object.class), Collections.emptySet(), Collections.emptyMap(), Collections.singletonMap("java.lang", Collections.singleton(ClassInjector.getModule(MethodHandlesInjector.class))), Collections.emptySet(), Collections.emptyMap());
        }
        catch (Exception e2) {
            throw new IllegalStateException("There was a problem redefining the java.base module", e2);
        }
    }

    private static Object getModule(Class<?> clazz) {
        try {
            return Class.class.getMethod("getModule", new Class[0]).invoke(clazz, new Object[0]);
        }
        catch (Exception e2) {
            throw new IllegalStateException("There was a problem while getting the module of the class", e2);
        }
    }

    public static void injectBaseInjections(final Injector injector) {
        LinkedList<1> dispatcherInterfaceInjections = new LinkedList<1>();
        LinkedList<1> locatorInterfaceInjections = new LinkedList<1>();
        LinkedList<1> locatorSingletonInjections = new LinkedList<1>();
        ZipInputStream zis = null;
        try {
            ZipEntry zipEntry;
            zis = new ZipInputStream(ContrastLoaderAgent.getBaseInjectionsAsStream());
            while ((zipEntry = zis.getNextEntry()) != null) {
                String name = zipEntry.getName();
                String string = ".class";
                if (!name.endsWith(".class")) continue;
                final String typeName = name.substring(0, name.length() - ".class".length());
                int entrySize = (int)zipEntry.getSize();
                final byte[] bytecode = ClassInjector.consumeCurrentEntry(zis, entrySize);
                Runnable injectRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            injector.inject(typeName, bytecode);
                        }
                        catch (Exception e2) {
                            throw new IllegalStateException(e2);
                        }
                    }
                };
                if ("java/lang/ContrastPreconditions".equals(typeName) || "java/lang/ContrastObjectShare".equals(typeName) || MODEL_REGEX.matcher(typeName).matches()) {
                    injectRunnable.run();
                    continue;
                }
                if (DISPATCHER_REGEX.matcher(typeName).matches()) {
                    dispatcherInterfaceInjections.add(injectRunnable);
                    continue;
                }
                if (LOCATOR_INTERFACE_REGEX.matcher(typeName).matches()) {
                    locatorInterfaceInjections.add(injectRunnable);
                    continue;
                }
                if (LOCATOR_SINGLETON_REGEX.matcher(typeName).matches()) {
                    locatorSingletonInjections.add(injectRunnable);
                    continue;
                }
                throw new IllegalArgumentException("Contrast java-agent-base-injections jar contains type with unexpected name " + typeName);
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException("Unexpected exception reading classes from java-agent-base-injections jar", e2);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (Runnable runnable : dispatcherInterfaceInjections) {
            runnable.run();
        }
        for (Runnable runnable : locatorInterfaceInjections) {
            runnable.run();
        }
        for (Runnable runnable : locatorSingletonInjections) {
            runnable.run();
        }
    }

    private static byte[] consumeCurrentEntry(ZipInputStream zis, int entrySize) throws IOException {
        if (entrySize == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return entrySize > 0 ? ClassInjector.doConsumeEntry(zis, entrySize) : ClassInjector.doConsumeEntry(zis);
    }

    private static byte[] doConsumeEntry(ZipInputStream zis, int entrySize) throws IOException {
        int len;
        byte[] entry = new byte[entrySize];
        byte[] buf = new byte[8192];
        int offset = 0;
        while ((len = zis.read(buf)) > 0) {
            int available = Math.min(len, entrySize - offset);
            System.arraycopy(buf, 0, entry, offset, available);
            offset += available;
        }
        return entry;
    }

    private static byte[] doConsumeEntry(ZipInputStream zis) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8000);
        byte[] buf = new byte[8192];
        while ((len = zis.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        return baos.toByteArray();
    }

    private ClassInjector() {
    }
}

