/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum HttpVersion {
    HTTP_0_9(0, 9),
    HTTP_1_0(1, 0),
    HTTP_1_1(1, 1),
    HTTP_2_0(2, 0);

    private final int major;
    private final int minor;
    private static final Pattern VERSION_REGEX;
    public static final HttpVersion FALLBACK_VALUE;

    private HttpVersion(int n3, int n4) {
        this.major = n3;
        this.minor = n4;
    }

    public static HttpVersion parse(String string) {
        Matcher matcher = VERSION_REGEX.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string + " is not a valid HTTP protocol version string");
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        return HttpVersion.fromMajorMinor(Integer.parseInt(string2), Integer.parseInt(string3));
    }

    public static HttpVersion fromMajorMinor(int n2, int n3) {
        if (n2 == 0 && n3 == 9) {
            return HTTP_0_9;
        }
        if (n2 == 1 && n3 == 0) {
            return HTTP_1_0;
        }
        if (n2 == 1 && n3 == 1) {
            return HTTP_1_1;
        }
        if (n2 == 2 && n3 == 0) {
            return HTTP_2_0;
        }
        throw new IllegalArgumentException("Unrecognized HTTP version " + n2 + "." + n3);
    }

    public String toVersionString() {
        return this.major + "." + this.minor;
    }

    public String toString() {
        return "HTTP/" + this.toVersionString();
    }

    static {
        VERSION_REGEX = Pattern.compile("HTTP/(\\d)\\.(\\d)", 2);
        FALLBACK_VALUE = HTTP_1_1;
    }
}

