/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.activity.protect;

import com.contrastsecurity.agent.commons.h;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.messages.TimestampDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.AttackResult;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ProtectRuleSampleDTM<T> {
    private HttpRequestDTM request;
    private T details;
    protected List<StackTraceElement> stack;
    private boolean blocked;
    private UserInputDTM input;
    private TimestampDTM timestamp;
    private transient AttackResult result;

    public static <T> ProtectRuleSampleDTM<T> createBlockedAtPerimeter(HttpRequestDTM httpRequestDTM, T t2, List<StackTraceElement> list, UserInputDTM userInputDTM, TimestampDTM timestampDTM) {
        return new ProtectRuleSampleDTM<T>(httpRequestDTM, t2, list, userInputDTM, timestampDTM, AttackResult.BLOCKED_AT_PERIMETER);
    }

    public static <T> ProtectRuleSampleDTM<T> create(HttpRequestDTM httpRequestDTM, T t2, List<StackTraceElement> list, UserInputDTM userInputDTM, TimestampDTM timestampDTM, AttackResult attackResult) {
        Objects.requireNonNull(userInputDTM);
        return new ProtectRuleSampleDTM<T>(httpRequestDTM, t2, list, userInputDTM, timestampDTM, attackResult);
    }

    private ProtectRuleSampleDTM(HttpRequestDTM httpRequestDTM, T t2, List<StackTraceElement> list, UserInputDTM userInputDTM, TimestampDTM timestampDTM, AttackResult attackResult) {
        this.request = httpRequestDTM;
        this.details = t2;
        this.stack = list != null ? h.a(list) : Collections.emptyList();
        this.input = userInputDTM;
        this.timestamp = timestampDTM;
        this.result = attackResult;
        this.blocked = attackResult == AttackResult.BLOCKED || attackResult == AttackResult.BLOCKED_AT_PERIMETER;
    }

    private ProtectRuleSampleDTM() {
    }

    public AttackResult getResult() {
        return this.result;
    }

    public TimestampDTM getTimestamp() {
        return this.timestamp;
    }

    public HttpRequestDTM getRequest() {
        return this.request;
    }

    public T getDetails() {
        return this.details;
    }

    public List<StackTraceElement> getStack() {
        return this.stack;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public UserInputDTM getInput() {
        return this.input;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProtectRuleSampleDTM protectRuleSampleDTM = (ProtectRuleSampleDTM)object;
        if (this.blocked != protectRuleSampleDTM.blocked) {
            return false;
        }
        if (this.request != null ? !this.request.equals(protectRuleSampleDTM.request) : protectRuleSampleDTM.request != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(protectRuleSampleDTM.details) : protectRuleSampleDTM.details != null) {
            return false;
        }
        if (this.stack != null ? !this.stack.equals(protectRuleSampleDTM.stack) : protectRuleSampleDTM.stack != null) {
            return false;
        }
        if (this.input != null ? !this.input.equals(protectRuleSampleDTM.input) : protectRuleSampleDTM.input != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(protectRuleSampleDTM.timestamp) : protectRuleSampleDTM.timestamp != null) {
            return false;
        }
        return this.result == protectRuleSampleDTM.result;
    }

    public int hashCode() {
        int n2 = this.request != null ? this.request.hashCode() : 0;
        n2 = 31 * n2 + (this.details != null ? this.details.hashCode() : 0);
        n2 = 31 * n2 + this.stack.hashCode();
        n2 = 31 * n2 + (this.blocked ? 1 : 0);
        n2 = 31 * n2 + (this.input != null ? this.input.hashCode() : 0);
        n2 = 31 * n2 + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        n2 = 31 * n2 + (this.result != null ? this.result.hashCode() : 0);
        return n2;
    }
}

