/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.info;

import com.contrastsecurity.agent.contrastapi_v1_0.inventory.DiscoveredRouteDTM;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class HTTPRoute {
    private final String verb;
    private final String uri;
    private final String signature;
    private String applicationContextPath;
    public static final String ALL_VERBS = null;
    private static final String ALL_VERBS_INTERNAL_DESCRIPTOR = "*";

    public static HTTPRoute of(String string, String string2, String string3) {
        return new HTTPRoute(string, string2, string3);
    }

    public static HTTPRoute of(String string, String string2, Method method) {
        String string3 = method.getDeclaringClass().getName() + "." + method.getName() + "(" + Arrays.stream(method.getGenericParameterTypes()).map(Type::getTypeName).collect(Collectors.joining(",")) + ")";
        return new HTTPRoute(string, string2, string3);
    }

    private HTTPRoute(String string, String string2, String string3) {
        Objects.requireNonNull(string2);
        Objects.requireNonNull(string3);
        this.verb = string;
        this.uri = string2;
        this.signature = string3;
    }

    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    public HTTPRoute setApplicationContextPath(String string) {
        this.applicationContextPath = string;
        return this;
    }

    public String getVerb() {
        return this.verb;
    }

    public String getURI() {
        return this.uri;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        return "HTTPRoute{verb='" + (this.verb != null ? this.verb : ALL_VERBS_INTERNAL_DESCRIPTOR) + '\'' + ", URI='" + this.uri + '\'' + ", signature='" + this.signature + '\'' + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HTTPRoute hTTPRoute = (HTTPRoute)object;
        if (this.verb == null ? hTTPRoute.verb != null : !this.verb.equals(hTTPRoute.verb)) {
            return false;
        }
        if (!this.uri.equals(hTTPRoute.uri)) {
            return false;
        }
        return this.signature.equals(hTTPRoute.signature);
    }

    public int hashCode() {
        int n2 = this.verb != null ? this.verb.hashCode() : ALL_VERBS_INTERNAL_DESCRIPTOR.hashCode();
        n2 = 31 * n2 + this.uri.hashCode();
        n2 = 31 * n2 + this.signature.hashCode();
        return n2;
    }

    public DiscoveredRouteDTM toDiscoveredRouteDTM() {
        return DiscoveredRouteDTM.builder().verb(this.verb).uri(this.uri).signature(this.signature).build();
    }
}

