/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.info;

import com.contrastsecurity.agent.messages.app.info.HTTPRouteObservation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RouteBasedCoverageDTM {
    private final String signature;
    private final List<HTTPRouteObservation> observations;
    private final int count;

    private RouteBasedCoverageDTM(Builder builder) {
        this.observations = builder.httpURIVerbs;
        this.signature = builder.signature;
        this.count = builder.count;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RouteBasedCoverageDTM routeBasedCoverageDTM = (RouteBasedCoverageDTM)object;
        if (this.count != routeBasedCoverageDTM.count) {
            return false;
        }
        if (!this.signature.equals(routeBasedCoverageDTM.signature)) {
            return false;
        }
        return this.observations.equals(routeBasedCoverageDTM.observations);
    }

    public int hashCode() {
        int n2 = this.signature.hashCode();
        n2 = 31 * n2 + this.observations.hashCode();
        n2 = 31 * n2 + this.count;
        return n2;
    }

    public static final class Builder {
        private List<HTTPRouteObservation> httpURIVerbs = Collections.emptyList();
        private String signature;
        private int count;

        public Builder observations(List<HTTPRouteObservation> list) {
            Objects.requireNonNull(list);
            this.httpURIVerbs = list;
            return this;
        }

        public Builder signature(String string) {
            Objects.requireNonNull(string);
            this.signature = string;
            return this;
        }

        public Builder count(int n2) {
            this.count = n2;
            return this;
        }

        public RouteBasedCoverageDTM build() {
            return new RouteBasedCoverageDTM(this);
        }
    }
}

