/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.finding.trace;

import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceTypeDTM;
import java.util.Objects;

public final class EventSource {
    private final EventSourceTypeDTM type;
    private final String name;

    public static EventSource fromEventSourceDTM(EventSourceDTM eventSourceDTM) {
        return new EventSource(eventSourceDTM.getSourceType(), eventSourceDTM.getSourceName());
    }

    public EventSource(EventSourceTypeDTM eventSourceTypeDTM, String string) {
        this.type = Objects.requireNonNull(eventSourceTypeDTM);
        this.name = string;
    }

    public EventSourceTypeDTM getSourceType() {
        return this.type;
    }

    public String getSourceName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EventSource eventSource = (EventSource)object;
        if (this.type != eventSource.type) {
            return false;
        }
        return this.name != null ? this.name.equals(eventSource.name) : eventSource.name == null;
    }

    public int hashCode() {
        int n2 = this.type != null ? this.type.hashCode() : 0;
        n2 = 31 * n2 + (this.name != null ? this.name.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "EventSource{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + '}';
    }
}

