/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.mq;

import com.contrastsecurity.agent.commons.o;
import com.contrastsecurity.agent.contrastapi_v1_0.library.LibraryUsageDTM;
import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentDTM;
import com.contrastsecurity.agent.messages.app.info.HTTPRoute;
import com.contrastsecurity.agent.messages.app.info.LibraryDTM;
import com.contrastsecurity.agent.messages.finding.FindingDTM;
import com.contrastsecurity.agent.messages.mq.ApplicationStartupDTM;
import com.contrastsecurity.agent.messages.mq.HttpRequestResponseDTM;
import com.contrastsecurity.agent.messages.mq.MQProtectSampleDTM;
import com.contrastsecurity.agent.messages.mq.VulnerabilityDTM;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class EventType<T> {
    public static final EventType<ApplicationStartupDTM> APPLICATION_CREATED = EventType.of("APPLICATION_CREATED", ApplicationStartupDTM.class);
    public static final EventType<LibraryDTM> LIBRARY_FOUND = EventType.of("LIBRARY_FOUND", LibraryDTM.class);
    public static final EventType<LibraryUsageDTM> LIBRARY_USAGE = EventType.of("LIBRARY_USAGE", LibraryUsageDTM.class);
    public static final EventType<MQProtectSampleDTM> PROTECT_SAMPLE_COLLECTED = EventType.of("PROTECT_SAMPLE_COLLECTED", MQProtectSampleDTM.class);
    public static final EventType<HTTPRoute> ROUTE_DISCOVERED = EventType.of("ROUTE_DISCOVERED", HTTPRoute.class);
    public static final EventType<HttpRequestResponseDTM> HTTP_REQUEST_RESPONSE = EventType.of("HTTP_REQUEST_RESPONSE", HttpRequestResponseDTM.class);
    public static final EventType<String> URI_ACTIVITY = EventType.of("URI_ACTIVITY", String.class);
    public static final EventType<VulnerabilityDTM> VULNERABILITY_DISCOVERED = EventType.of("VULNERABILITY_DISCOVERED", VulnerabilityDTM.class);
    public static final EventType<FindingDTM> FINDING_DISCOVERED = EventType.of("FINDING_DISCOVERED", FindingDTM.class);
    public static final EventType<ObservedRoute> OBSERVED_ROUTE_EVENT = EventType.of("OBSERVED_ROUTE_EVENT", ObservedRoute.class);
    public static final EventType<ArchitectureComponentDTM> ARCHITECTURE_COMPONENT_DISCOVERED = EventType.of("ARCHITECTURE_COMPONENT_DISCOVERED", ArchitectureComponentDTM.class);
    private static final Set<EventType<?>> TYPES = o.b(APPLICATION_CREATED, VULNERABILITY_DISCOVERED, PROTECT_SAMPLE_COLLECTED, ROUTE_DISCOVERED, HTTP_REQUEST_RESPONSE, URI_ACTIVITY, LIBRARY_FOUND, LIBRARY_USAGE, FINDING_DISCOVERED, OBSERVED_ROUTE_EVENT, ARCHITECTURE_COMPONENT_DISCOVERED);
    private String id;
    private Class<T> token;

    public static Set<EventType<?>> values() {
        return TYPES;
    }

    private static <T> EventType<T> of(String string, Class<T> clazz) {
        return new EventType<T>(string, clazz);
    }

    public static EventType<?> fromId(String string) {
        for (EventType<?> eventType : EventType.values()) {
            if (!eventType.id().equals(string)) continue;
            return eventType;
        }
        throw new NoSuchElementException(string + " does not match any known event type");
    }

    private EventType(String string, Class<T> clazz) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(clazz);
        this.id = string;
        this.token = clazz;
    }

    private EventType() {
    }

    public String id() {
        return this.id;
    }

    public Class<T> token() {
        return this.token;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EventType eventType = (EventType)object;
        return this.id.equals(eventType.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "EventType{id=" + this.id + ", token=" + this.token + '}';
    }
}

