/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.mq;

import com.contrastsecurity.agent.commons.i;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HttpResponseDTM {
    private final int statusCode;
    private final String contentType;
    private final String characterEncoding;
    private final Map<String, List<String>> headers;

    private HttpResponseDTM(Builder builder) {
        this.statusCode = builder.status;
        this.contentType = builder.contentType;
        this.characterEncoding = builder.characterEncoding;
        this.headers = builder.headers == null ? null : i.d(builder.headers);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpResponseDTM)) {
            return false;
        }
        HttpResponseDTM httpResponseDTM = (HttpResponseDTM)object;
        if (this.statusCode != httpResponseDTM.statusCode) {
            return false;
        }
        if (!Objects.equals(this.contentType, httpResponseDTM.contentType)) {
            return false;
        }
        if (!Objects.equals(this.headers, httpResponseDTM.headers)) {
            return false;
        }
        return this.characterEncoding != null ? this.characterEncoding.equalsIgnoreCase(httpResponseDTM.characterEncoding) : httpResponseDTM.characterEncoding == null;
    }

    public int hashCode() {
        int n2 = this.statusCode;
        n2 = 31 * n2 + (this.contentType != null ? this.contentType.hashCode() : 0);
        n2 = 31 * n2 + (this.characterEncoding != null ? this.characterEncoding.toLowerCase().hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "HttpResponseDTM{statusCode=" + this.statusCode + ", contentType='" + this.contentType + '\'' + ", characterEncoding='" + this.characterEncoding + '\'' + ", headers=" + this.headers + '\'' + '}';
    }

    public static final class Builder {
        private int status;
        private String contentType;
        private String characterEncoding;
        private Map<String, List<String>> headers;

        public Builder status(int n2) {
            this.status = n2;
            return this;
        }

        public Builder contentType(String string) {
            this.contentType = string;
            return this;
        }

        public Builder characterEncoding(String string) {
            this.characterEncoding = string;
            return this;
        }

        public Builder headers(Map<String, List<String>> map) {
            this.headers = map;
            return this;
        }

        public HttpResponseDTM build() {
            return new HttpResponseDTM(this);
        }
    }
}

