/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.routes;

import com.contrastsecurity.agent.commons.o;
import com.contrastsecurity.agent.messages.app.info.HTTPRoute;
import com.contrastsecurity.agent.messages.finding.trace.EventSource;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class ObservedRoute {
    @SerializedName(value="session_id")
    private final String sessionId;
    private final String verb;
    @SerializedName(value="url")
    private final String uri;
    private final String signature;
    private final Set<EventSource> sources;

    public static Builder builderFromRoute(HTTPRoute hTTPRoute) {
        return ObservedRoute.builder().verb(hTTPRoute.getVerb()).uri(hTTPRoute.getURI()).signature(hTTPRoute.getSignature());
    }

    public static Builder builderFromObservedRoute(ObservedRoute observedRoute) {
        return ObservedRoute.builder().verb(observedRoute.verb()).uri(observedRoute.uri()).signature(observedRoute.signature()).sessionId(observedRoute.sessionId()).addSources(observedRoute.sources());
    }

    private ObservedRoute(Builder builder) {
        this.sessionId = Objects.requireNonNull(builder.sessionId);
        this.verb = builder.verb;
        this.uri = Objects.requireNonNull(builder.uri);
        this.signature = Objects.requireNonNull(builder.signature);
        this.sources = o.a(builder.sources);
    }

    public static synchronized Builder builder() {
        return new Builder();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String verb() {
        return this.verb;
    }

    public String uri() {
        return this.uri;
    }

    public String signature() {
        return this.signature;
    }

    public Set<EventSource> sources() {
        return this.sources;
    }

    public String toString() {
        return "ObservedRoute{sessionId='" + this.sessionId + '\'' + ", verb='" + this.verb + '\'' + ", URI='" + this.uri + '\'' + ", signature='" + this.signature + '\'' + ", sources=" + this.sources + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObservedRoute observedRoute = (ObservedRoute)object;
        if (!Objects.equals(this.sessionId, observedRoute.sessionId)) {
            return false;
        }
        if (!Objects.equals(this.verb, observedRoute.verb)) {
            return false;
        }
        if (!this.uri.equals(observedRoute.uri)) {
            return false;
        }
        if (!this.signature.equals(observedRoute.signature)) {
            return false;
        }
        return this.sources.equals(observedRoute.sources);
    }

    public int hashCode() {
        int n2 = this.sessionId != null ? this.sessionId.hashCode() : 0;
        n2 = 31 * n2 + (this.verb != null ? this.verb.hashCode() : 0);
        n2 = 31 * n2 + this.uri.hashCode();
        n2 = 31 * n2 + this.signature.hashCode();
        n2 = 31 * n2 + this.sources.hashCode();
        return n2;
    }

    public static final class Builder {
        private String sessionId;
        private String verb;
        private String uri;
        private String signature;
        private final Set<EventSource> sources = new HashSet<EventSource>();

        public synchronized boolean requiredPropertiesSet() {
            return this.hasRoute() && this.sessionId != null;
        }

        public synchronized boolean hasRoute() {
            return this.verb != null && this.uri != null && this.uri.trim().length() > 0 && this.signature != null && this.signature.trim().length() > 0;
        }

        public synchronized Builder sessionId(String string) {
            this.sessionId = string;
            return this;
        }

        public synchronized Builder verb(String string) {
            this.verb = string;
            return this;
        }

        public synchronized Builder uri(String string) {
            this.uri = string;
            return this;
        }

        public synchronized Builder signature(String string) {
            this.signature = string;
            return this;
        }

        public synchronized Builder addSource(EventSource eventSource) {
            Objects.requireNonNull(eventSource);
            this.sources.add(eventSource);
            return this;
        }

        public synchronized Builder addSources(Collection<EventSource> collection) {
            Objects.requireNonNull(collection);
            this.sources.addAll(collection);
            return this;
        }

        public synchronized ObservedRoute build() {
            return new ObservedRoute(this);
        }
    }
}

