/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.architecture.controller;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.plugins.architecture.controller.DbInfoBlock;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Sensor
public class DbHelper {
    private static final Map<String, DbInfoBlock> a = new ConcurrentLinkedHashMap.Builder().initialCapacity(50).maximumWeightedCapacity(100L).build();
    private static final String[] b = new String[]{"hsql", "hsqls"};
    private static final String[] c = new String[]{"http", "https"};
    public static final int UNKNOWN_PORT = -1;
    private static final Pattern d = Pattern.compile("^\\d+");
    private static final String e = "In Memory (alias): ";
    private static final String f = "File: ";
    private static final String g = "Local Resource: ";
    private static final Logger h = LoggerFactory.getLogger(DbHelper.class);

    public static DbInfoBlock parseDbUrl(String string) {
        if (string == null) {
            return null;
        }
        DbInfoBlock dbInfoBlock = a.get(string);
        if (dbInfoBlock == null) {
            String[] stringArray = string.split(":", 3);
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            try {
                if ("mysql".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parseMySQLPath(string3);
                } else if ("postgresql".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parsePostgreSQLPath(string3);
                } else if ("microsoft".equalsIgnoreCase(string2) || "jtds".equalsIgnoreCase(string2) && !StringUtils.containsIgnoreCase(string3, "sybase")) {
                    dbInfoBlock = DbHelper.parseSQLServerPath(string3);
                } else if ("sqlserver".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parseDirectSQLServerPath(string3);
                } else if ("oracle".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parseOraclePath(string3);
                } else if ("informix-sqli".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parseInformixPath(string3);
                } else if ("hsqldb".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parseHSQLPath(string3, "hsqldb");
                } else if ("h2".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parseHSQLPath(string3, "h2");
                } else if ("db2".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.parseDB2Path(string3);
                } else if ("sybase".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.c(string3);
                } else if ("sqlite".equalsIgnoreCase(string2)) {
                    dbInfoBlock = DbHelper.b(string3);
                }
            }
            catch (Exception exception) {
                dbInfoBlock = new DbInfoBlock();
                dbInfoBlock.host = "(unknown)";
                dbInfoBlock.port = -1;
            }
            if (dbInfoBlock != null) {
                a.put(string, dbInfoBlock);
            } else {
                h.debug("Unknown database: {}/{} on URL {}", string2, string3, string);
            }
        }
        return dbInfoBlock;
    }

    private static DbInfoBlock b(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        dbInfoBlock.vendor = "SQLite";
        dbInfoBlock.port = -1;
        if (string.isEmpty() || ":memory:".equals(string)) {
            dbInfoBlock.host = "In Memory";
            return dbInfoBlock;
        }
        String[] stringArray = string.split(":");
        if (string.startsWith(":resource:")) {
            String string2;
            boolean bl = string.startsWith(":resource:jar:");
            String string3 = string2 = bl ? stringArray[3] : stringArray[2];
            if (N.b(c, string2)) {
                String string4 = bl ? string.substring(":resource:jar:".length()) : string.substring(":resource:".length());
                DbHelper.a(dbInfoBlock, string4);
            } else {
                dbInfoBlock.host = g + string2;
            }
        } else {
            int n2 = string.indexOf("?");
            dbInfoBlock.host = f + (n2 != -1 ? string.substring(0, n2) : string);
        }
        return dbInfoBlock;
    }

    private static DbInfoBlock c(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        dbInfoBlock.vendor = "Sybase";
        String[] stringArray = string.split(":");
        if ("Tds".equals(stringArray[0])) {
            dbInfoBlock.host = stringArray[1];
            int n2 = stringArray[2].indexOf("?");
            dbInfoBlock.port = DbHelper.a(stringArray[2]);
            if (n2 != -1) {
                dbInfoBlock.name = stringArray[2].substring(n2 + 1);
                if (dbInfoBlock.name.startsWith("ServiceName=")) {
                    dbInfoBlock.name = dbInfoBlock.name.substring(12);
                }
            }
        }
        return dbInfoBlock;
    }

    public static DbInfoBlock parseMySQLPath(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        dbInfoBlock.vendor = "MySQL";
        String string2 = "http://" + string;
        try {
            URL uRL = new URL(string2);
            dbInfoBlock.host = uRL.getHost();
            dbInfoBlock.port = uRL.getPort() == -1 ? 3306 : uRL.getPort();
            dbInfoBlock.name = uRL.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            dbInfoBlock.host = string.split("(:|/")[0];
            dbInfoBlock.port = 3306;
        }
        return dbInfoBlock;
    }

    public static DbInfoBlock parsePostgreSQLPath(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        String string2 = string.replace("//", "http://");
        try {
            URL uRL = new URL(string2);
            dbInfoBlock.vendor = "PostgreSQL";
            dbInfoBlock.host = uRL.getHost();
            dbInfoBlock.port = uRL.getPort() == -1 ? 5432 : uRL.getPort();
            dbInfoBlock.name = uRL.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            dbInfoBlock.host = string.split("(:|/")[0];
            dbInfoBlock.port = 3306;
        }
        return dbInfoBlock;
    }

    public static DbInfoBlock parseDirectSQLServerPath(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        int n2 = 2;
        int n3 = string.indexOf(";");
        dbInfoBlock.host = n3 == -1 ? string.substring(2) : string.substring(2, n3);
        int n4 = dbInfoBlock.host.indexOf(":");
        if (n4 != -1) {
            dbInfoBlock.port = DbHelper.a(dbInfoBlock.host.substring(n4 + 1));
            dbInfoBlock.host = dbInfoBlock.host.substring(0, n4);
        } else {
            dbInfoBlock.port = 1433;
        }
        dbInfoBlock.vendor = "SQL Server";
        return dbInfoBlock;
    }

    public static DbInfoBlock parseSQLServerPath(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        int n2 = 12;
        int n3 = string.indexOf(";");
        dbInfoBlock.host = n3 == -1 ? string.substring(12) : string.substring(12, n3);
        int n4 = dbInfoBlock.host.indexOf(":");
        if (n4 != -1) {
            dbInfoBlock.port = DbHelper.a(dbInfoBlock.host.substring(n4 + 1));
            dbInfoBlock.host = dbInfoBlock.host.substring(0, n4);
        } else {
            dbInfoBlock.port = 1433;
        }
        dbInfoBlock.vendor = "SQL Server";
        return dbInfoBlock;
    }

    public static DbInfoBlock parseHSQLPath(String string, String string2) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        dbInfoBlock.vendor = string2;
        String[] stringArray = string.split(":");
        if (string.startsWith("mem:")) {
            dbInfoBlock.host = e + stringArray[1];
            dbInfoBlock.port = -1;
        } else if (string.startsWith("file:")) {
            dbInfoBlock.host = f + string.substring("file:".length());
            dbInfoBlock.port = -1;
        } else if (string.startsWith("res:")) {
            dbInfoBlock.host = g + stringArray[1];
            dbInfoBlock.port = -1;
        } else if (N.b(b, stringArray[0])) {
            String string3 = string.replace(stringArray[0], "http");
            DbHelper.a(dbInfoBlock, string3);
        } else if (N.b(c, stringArray[0])) {
            DbHelper.a(dbInfoBlock, string);
        } else {
            dbInfoBlock.host = "In Memory (alias): localhost";
            dbInfoBlock.port = -1;
        }
        return dbInfoBlock;
    }

    public static DbInfoBlock parseInformixPath(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        dbInfoBlock.vendor = "Informix";
        String string2 = string.replace("//", "http://");
        try {
            URL uRL = new URL(string2);
            dbInfoBlock.host = uRL.getHost();
            dbInfoBlock.port = uRL.getPort() == 80 || uRL.getPort() == -1 ? 1526 : uRL.getPort();
            dbInfoBlock.name = uRL.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            dbInfoBlock.host = string.split("(:|/")[0];
            dbInfoBlock.port = 1526;
        }
        return dbInfoBlock;
    }

    public static DbInfoBlock parseOraclePath(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        dbInfoBlock.vendor = "Oracle";
        String[] stringArray = string.split(":");
        String string2 = "localhost";
        int n2 = 1521;
        if (stringArray.length > 1) {
            String[] stringArray2 = stringArray[1].split("@");
            string2 = stringArray2[1];
        }
        if (stringArray.length > 2) {
            n2 = DbHelper.a(stringArray[2]);
        }
        if (stringArray.length > 3) {
            dbInfoBlock.name = stringArray[3];
        }
        dbInfoBlock.host = string2.startsWith("//") ? string2.substring(2) : string2;
        dbInfoBlock.port = n2;
        return dbInfoBlock;
    }

    public static DbInfoBlock parseDB2Path(String string) {
        DbInfoBlock dbInfoBlock = new DbInfoBlock();
        dbInfoBlock.vendor = "DB2";
        String string2 = string.startsWith("//") ? string.replace("//", "http://") : "http://" + string;
        try {
            URL uRL = new URL(string2);
            dbInfoBlock.host = uRL.getHost();
            dbInfoBlock.port = uRL.getPort() == -1 ? 60000 : uRL.getPort();
            dbInfoBlock.name = uRL.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            dbInfoBlock.host = string.split("(:|/")[0];
            dbInfoBlock.port = 1526;
        }
        return dbInfoBlock;
    }

    private static void a(DbInfoBlock dbInfoBlock, String string) {
        try {
            URL uRL = new URL(string);
            dbInfoBlock.host = uRL.getHost();
            dbInfoBlock.port = uRL.getPort() != -1 ? uRL.getPort() : 80;
            dbInfoBlock.name = uRL.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            dbInfoBlock.host = string.split("(:|/")[0];
            dbInfoBlock.port = 80;
        }
    }

    static int a(String string) {
        Matcher matcher = d.matcher(string);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(0));
        }
        return -1;
    }
}

