/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.ldap;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.f;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.plugins.architecture.controller.a;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.architecture.util.ArchitectureScope;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;

@Sensor
public final class ContrastLdapQueryDispatcherImpl
implements ContrastLdapQueryDispatcher {
    private final g a;
    private final ApplicationManager b;
    private final a c;
    private static final Logger d = LoggerFactory.getLogger(ContrastLdapQueryDispatcherImpl.class);

    @Inject
    public ContrastLdapQueryDispatcherImpl(g g2, ApplicationManager applicationManager, a a2) {
        this.a = g2;
        this.b = applicationManager;
        this.c = a2;
    }

    @Sensor
    public void onLdapQuerying(Hashtable<?, ?> hashtable) {
        if (ArchitectureScope.getTrackerScope().inScope() || ArchitectureScope.getSamplerScope().inScope()) {
            return;
        }
        Application application = this.b.current();
        if (application == null || hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("java.naming.provider.url");
        if (StringUtils.isEmpty(string)) {
            return;
        }
        this.a(application, string);
    }

    @z
    void a(Application application, String string) {
        if (!f.a(this.a, ConfigProperty.INVENTORY_MONITOR_LDAP)) {
            return;
        }
        if (string == null) {
            d.debug("Invalid LDAP URL: NULL");
            return;
        }
        for (String string2 : StringUtils.split(string, " ,")) {
            try {
                URI uRI = new URI(string2);
                String string3 = uRI.getScheme();
                if (StringUtils.equalsIgnoreCase("ldap", string3) || StringUtils.equalsIgnoreCase("ldaps", string3)) {
                    String string4 = uRI.getHost();
                    String string5 = String.valueOf(uRI.getPort());
                    this.c.a(application, ArchitectureComponent.ldapFrom(string2, string4, string5));
                    continue;
                }
                d.debug("Invalid LDAP URL: {}", (Object)string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                d.debug("Invalid LDAP URL: {}", (Object)string2, (Object)uRISyntaxException);
            }
        }
    }
}

