/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.enums.LogContextSwitch;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.plugins.security.ImmutableObjectSnapshotCache;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.o;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.util.O;
import com.contrastsecurity.agent.util.Q;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@DontObfuscate
public class AssessmentContext {
    private volatile long updated;
    private final ImmutableObjectSnapshotCache snapshotCache;
    private final Map<Integer, Integer> lengthMap = new HashMap<Integer, Integer>();
    private final Set<Object> trackedObjects = Collections.newSetFromMap(new ConcurrentReferenceHashMap());
    private final Map<Thread, String> threadDescCache = new ConcurrentReferenceHashMap<Thread, String>();
    private final Map<Object, Trace> traceMap;
    private final ConcurrentHashMap<Integer, Set<String>> identityTagMap;
    private final ConcurrentHashMap<Integer, List<Trace>> identityTraceMap;
    private final boolean identityTaggingEnabled;
    private volatile TriggerEvent lastTriggerEvent;
    private final AtomicBoolean jumpedContexts;
    private final int maxPropagationEvents;
    private final int maxSourceEvents;
    private final d clock;
    private volatile int sourceEvents;
    private volatile int propagationEvents;
    private static final Logger logger = LoggerFactory.getLogger(AssessmentContext.class);
    private static final Integer TRACKED_MARKER = 1;
    private static final o HASH = new o();

    AssessmentContext(g g2, d d2, int n2) {
        this.clock = d2;
        this.updated = d2.a();
        this.traceMap = EventContext.buildTraceMap(n2);
        this.identityTagMap = new ConcurrentHashMap(n2 / 4);
        this.identityTraceMap = new ConcurrentHashMap(n2 / 2);
        this.jumpedContexts = new AtomicBoolean(false);
        this.sourceEvents = 0;
        this.propagationEvents = 0;
        this.snapshotCache = new ImmutableObjectSnapshotCache();
        this.maxSourceEvents = g2.d(ConfigProperty.MAX_CONTEXT_SOURCE_EVENTS);
        this.maxPropagationEvents = g2.d(ConfigProperty.MAX_CONTEXT_PROPAGATION_EVENTS);
        this.identityTaggingEnabled = g2.f(ConfigProperty.IDENTITYTAGS);
        if (LogContextSwitch.enabled()) {
            logger.debug("Created context: {}", (Object)this);
        }
    }

    long lastUpdatedMillis() {
        return this.updated;
    }

    public boolean hasAlreadyTracked(Object object) {
        return this.trackedObjects.contains(object);
    }

    public void markTracked(Object object) {
        this.trackedObjects.add(object);
    }

    public Set<String> getTags(Integer n2) {
        return this.identityTagMap.get(n2);
    }

    public void addTags(Integer n3, String ... stringArray) {
        Collections.addAll(this.identityTagMap.computeIfAbsent(n3, n2 -> Collections.synchronizedSet(new HashSet())), stringArray);
    }

    public Integer getLength(Object object) {
        Integer n2 = object == null ? Integer.valueOf(0) : this.lengthMap.get(object.hashCode());
        return n2;
    }

    public void saveLength(Object object, Integer n2) {
        if (object != null) {
            this.lengthMap.put(object.hashCode(), n2);
        }
    }

    public void clear() {
        this.identityTagMap.clear();
        this.identityTraceMap.clear();
        this.trackedObjects.clear();
        this.threadDescCache.clear();
        this.traceMap.clear();
        if (LogContextSwitch.enabled()) {
            logger.debug("Cleared context: {}", (Object)this);
        }
    }

    public void applyTags(int n2, String string, int n3) throws InvalidTagRangeException {
        this.applyTags(n2, O.a(string), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTags(int n3, String[] stringArray, int n4) throws InvalidTagRangeException {
        Set set = this.identityTagMap.computeIfAbsent(n3, n2 -> Collections.synchronizedSet(new HashSet()));
        Collection<Object> collection = set;
        synchronized (collection) {
            Collections.addAll(set, stringArray);
            if (logger.isDebugEnabled()) {
                logger.debug("Adding {} to existing map for future use under identity {}, new set is {}", N.a(stringArray), n3, set);
            }
        }
        collection = this.identityTraceMap.get(n3);
        if (collection != null && !collection.isEmpty()) {
            logger.debug("Applying tags to {} traces", (Object)collection.size());
            for (int i2 = 0; i2 < collection.size(); ++i2) {
                Trace trace = (Trace)collection.get(i2);
                CodeEvent codeEvent = trace.getLastEvent();
                if (codeEvent == null) continue;
                codeEvent.addTags(stringArray, n4);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Adding {} to existing identity {} / trace ID {}", N.a(stringArray), n3, trace.getId());
            }
        } else {
            logger.debug("Found no traces under identity {}", (Object)n3);
        }
    }

    @z
    List<Trace> getTraces(Integer n2) {
        return this.identityTraceMap.get(n2);
    }

    public void addTrace(Integer n3, Trace trace) {
        this.identityTraceMap.computeIfAbsent(n3, n2 -> Collections.synchronizedList(new ArrayList())).add(trace);
    }

    public int getIdentity(int n2, int n3) {
        return HASH.a(n2, n3);
    }

    public String getThreadDescription(Thread thread) {
        String string = this.threadDescCache.get(thread);
        if (string == null) {
            string = Q.a(thread);
            this.threadDescCache.put(thread, string);
        }
        return string;
    }

    public void clearLastMethodEvent() {
        this.lastTriggerEvent = null;
    }

    public void setLastTriggerEvent(TriggerEvent triggerEvent) {
        this.lastTriggerEvent = triggerEvent;
    }

    public TriggerEvent getLastTriggerEvent() {
        return this.lastTriggerEvent;
    }

    public Map<Object, Trace> getTraceMap() {
        return this.traceMap;
    }

    public void refresh() {
        this.updated = this.clock.a();
    }

    public boolean isJumpedContexts() {
        return this.jumpedContexts.get();
    }

    public void jumpingContexts() {
        this.jumpedContexts.set(true);
        if (LogContextSwitch.enabled()) {
            logger.debug("Preparing to jump context: {}", (Object)this);
        }
        this.refresh();
    }

    public void onSourceRecorded() {
        ++this.sourceEvents;
    }

    public boolean hasReachedMaximumSourceEvents() {
        return this.sourceEvents >= this.maxSourceEvents;
    }

    public int sourceEvents() {
        return this.sourceEvents;
    }

    public void onPropagationRecorded() {
        ++this.propagationEvents;
    }

    public boolean hasReachedMaximumPropagationEvents() {
        return this.propagationEvents >= this.maxPropagationEvents;
    }

    public int propagationEvents() {
        return this.propagationEvents;
    }

    public boolean isIdentityTaggingEnabled() {
        return this.identityTaggingEnabled;
    }

    public ImmutableObjectSnapshotCache getSnapshotCache() {
        return this.snapshotCache;
    }

    public String toString() {
        return AssessmentContext.toString(this, LogContextSwitch.get());
    }

    @z
    static String toString(AssessmentContext assessmentContext, LogContextSwitch logContextSwitch) {
        String string = N.a(assessmentContext);
        if (logContextSwitch != LogContextSwitch.FULL || assessmentContext == null) {
            return string;
        }
        return string + ":\ntraceMap=\n" + assessmentContext.traceMap + "\ntrackedObjects=\n" + assessmentContext.trackedObjects + "\nthreadDescCache=\n" + assessmentContext.threadDescCache + "\nidentityTagMap=\n" + assessmentContext.identityTagMap + "\nidentityTraceMap=\n" + assessmentContext.identityTraceMap + "\nsnapshotCache=\n" + assessmentContext.snapshotCache;
    }
}

