/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.commons.u;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.config.i;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.reloadable.ChannelSubscriber;
import com.contrastsecurity.agent.services.Purgeable;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@Singleton
@DontObfuscate
public class EventContext
implements ChannelSubscriber,
Purgeable {
    private final AssessmentManager assessmentManager;
    private boolean enabled;
    private final TraceMapStrategy traceMapStrategy;
    private final d clock;
    private final Map<Object, Trace> globalTraceMap;
    private final long maxStronglyReachableTraceTtl;
    private static final Logger logger = LoggerFactory.getLogger(EventContext.class);

    @Inject
    public EventContext(g g2, d d2, AssessmentManager assessmentManager) {
        Objects.requireNonNull(g2);
        this.clock = Objects.requireNonNull(d2);
        this.assessmentManager = Objects.requireNonNull(assessmentManager);
        this.enabled = false;
        this.maxStronglyReachableTraceTtl = g2.e(ConfigProperty.MAX_TRACE_TTL);
        this.traceMapStrategy = EventContext.traceMapStrategyFromConfig(g2);
        this.globalTraceMap = EventContext.buildTraceMap(10000);
    }

    static TraceMapStrategy traceMapStrategyFromConfig(g g2) {
        String string = g2.b(ConfigProperty.TRACE_MAP_STRATEGY);
        TraceMapStrategy traceMapStrategy = TraceMapStrategy.valueOfIgnoreCase(string);
        if (traceMapStrategy == null) {
            throw new i("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.TRACE_MAP_STRATEGY) + ". Valid values are GLOBAL, CONTEXT, BOTH.");
        }
        return traceMapStrategy;
    }

    public static Map<Object, Trace> buildTraceMap(int n2) {
        return new ConcurrentReferenceHashMap<Object, Trace>(n2, 0.75f, 32, ConcurrentReferenceHashMap.c.b, ConcurrentReferenceHashMap.c.a, EnumSet.range(ConcurrentReferenceHashMap.b.a, ConcurrentReferenceHashMap.b.a));
    }

    @Override
    public void onMessageReceived(Map<String, Object> map) {
        this.globalTraceMap.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Map<Object, Trace> getTraceMap() {
        Map<Object, Trace> map = null;
        if (TraceMapStrategy.GLOBAL == this.traceMapStrategy) {
            map = this.globalTraceMap;
        } else if (TraceMapStrategy.CONTEXT == this.traceMapStrategy) {
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null) {
                map = assessmentContext.getTraceMap();
            }
        } else {
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null) {
                map = assessmentContext.getTraceMap();
            }
            if (map == null) {
                map = this.globalTraceMap;
            }
        }
        return map;
    }

    @Override
    public void purgeStale() {
        AssessmentContext assessmentContext;
        Map<Object, Trace> map = this.getTraceMap();
        if (map != null) {
            this.removeDeadTraces(map);
            this.removeExpiredTraces(map);
        }
        if ((assessmentContext = this.assessmentManager.currentContext()) != null) {
            assessmentContext.clearLastMethodEvent();
        }
    }

    private void removeDeadTraces(Map<Object, Trace> map) {
        ConcurrentReferenceHashMap concurrentReferenceHashMap = (ConcurrentReferenceHashMap)map;
        concurrentReferenceHashMap.dumpStats();
        concurrentReferenceHashMap.purgeStaleEntries();
    }

    private void removeExpiredTraces(Map<Object, Trace> map) {
        Iterator<Map.Entry<Object, Trace>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Trace> entry = iterator.next();
            Trace trace = entry.getValue();
            try {
                if (!this.shouldRemoveTrace(trace)) continue;
                Object object = entry.getKey();
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing expired key=[{}] with identity=[{}] and value=[{}] from trace map=[{}].", object, N.a(object), N.a(trace), N.a(map));
                }
                iterator.remove();
            }
            catch (Throwable throwable) {
                logger.error("Problem pruning old trace {}", (Object)trace.getId(), (Object)throwable);
                u.a(throwable);
            }
        }
    }

    private boolean shouldRemoveTrace(Trace trace) {
        CodeEvent codeEvent = trace.getFirstEvent();
        if (codeEvent == null) {
            return true;
        }
        long l2 = codeEvent.getTimestamp();
        long l3 = this.clock.a() - l2;
        return l3 > this.maxStronglyReachableTraceTtl;
    }

    @Override
    public int purgeableCount() {
        Map<Object, Trace> map = this.getTraceMap();
        return map != null ? map.size() : 0;
    }

    public Integer getTrackedItemHash(Object[] objectArray) {
        Map<Object, Trace> map = this.getTraceMap();
        if (map == null) {
            return null;
        }
        Trace trace = map.get(objectArray);
        if (trace != null) {
            return Arrays.hashCode(objectArray);
        }
        for (Object object : objectArray) {
            Integer n2;
            if (object != null && object.getClass().isArray() && (n2 = this.getTrackedItemHash((Object[])object)) != null) {
                return n2;
            }
            trace = map.get(object);
            if (trace == null || object == null) continue;
            return object.hashCode();
        }
        return null;
    }
}

