/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.propagators;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.plugins.security.controller.propagate.ContrastDataFlowPropagationDispatcherImpl;
import com.contrastsecurity.agent.plugins.security.policy.f;
import com.contrastsecurity.agent.plugins.security.policy.m;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.t;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@Sensor
public class Propagator
extends f
implements Cloneable {
    private String propagationType;
    private final Command cmd;
    private m[] sources;
    private final String[] cmdArguments;
    private int[] integerCmdArguments;
    private boolean[] isLiteralCmdArguments;
    private final String[] tags;
    private final String[] untags;
    private final boolean cloneOnUnchangedCloneableSource;
    private final boolean shouldTagsApplyWhenInvokedDuringSources;
    private final AtomicInteger totalTimesHit;
    private final AtomicBoolean currentlyDeadzoning;
    private Set<String> requiredParameterTypes;
    private static final String TYPE_A2A = "A2A";
    private static final String TYPE_A2O = "A2O";
    private static final String TYPE_A2P = "A2P";
    private static final String TYPE_A2R = "A2R";
    private static final String TYPE_O2A = "O2A";
    private static final String TYPE_O2O = "O2O";
    private static final String TYPE_O2P = "O2P";
    private static final String TYPE_O2R = "O2R";
    private static final String TYPE_P2A = "P2A";
    private static final String TYPE_P2O = "P2O";
    private static final String TYPE_P2P = "P2P";
    private static final String TYPE_P2R = "P2R";
    private static final Logger logger = LoggerFactory.getLogger(Propagator.class);

    public Propagator(int n2, String string, String string2, m[] mArray, m[] mArray2, Command command, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl, boolean bl2, n n3) {
        super(n2, string, string2, mArray2, n3);
        this.sources = Objects.requireNonNull(mArray);
        com.contrastsecurity.agent.commons.m.a(mArray.length > 0, "Propagator with ID=%s has no sources", string2);
        this.isLiteralCmdArguments = new boolean[2];
        this.cmd = command;
        this.cmdArguments = stringArray;
        this.totalTimesHit = new AtomicInteger();
        this.currentlyDeadzoning = new AtomicBoolean();
        this.requiredParameterTypes = Collections.emptySet();
        this.tags = stringArray2 != null ? stringArray2 : ObjectShare.EMPTY_STRING_ARRAY;
        this.untags = stringArray3 != null ? stringArray3 : ObjectShare.EMPTY_STRING_ARRAY;
        com.contrastsecurity.agent.commons.m.a(Collections.disjoint(Arrays.asList(this.tags), Arrays.asList(this.untags)), "Propagator with ID=%s has overlapping tags (%s) and untags (%s)", string2, this.tags, this.untags);
        this.cloneOnUnchangedCloneableSource = bl;
        if (bl2) {
            com.contrastsecurity.agent.commons.m.a(this.tags.length + this.untags.length > 0, "Propagator with ID=%s has no tags, but is configured to apply during sources", string2);
        }
        this.shouldTagsApplyWhenInvokedDuringSources = bl2;
        this.parseCommandArguments();
        this.calculatePropagationType();
    }

    public m[] getSources() {
        return this.sources;
    }

    public Set<String> getRequiredParameterTypes() {
        return this.requiredParameterTypes;
    }

    public void setSources(m[] mArray) {
        this.sources = mArray;
    }

    public int getCountOfArgSources() {
        int n2 = 0;
        if (this.sources != null) {
            for (m m2 : this.sources) {
                n2 += m2.c() ? 1 : 0;
            }
        }
        return n2;
    }

    public int getCountOfArgTargets() {
        int n2 = 0;
        if (this.targets != null) {
            for (m m2 : this.targets) {
                n2 += m2.c() ? 1 : 0;
            }
        }
        return n2;
    }

    public String[] getTags() {
        return this.tags;
    }

    public String[] getUntags() {
        return this.untags;
    }

    public boolean isCloneOnUnchangedCloneableSource() {
        return this.cloneOnUnchangedCloneableSource;
    }

    public boolean isShouldTagsApplyWhenInvokedDuringSources() {
        return this.shouldTagsApplyWhenInvokedDuringSources;
    }

    public int onHit() {
        return this.totalTimesHit.incrementAndGet();
    }

    @z
    int calculateStackDepthOffset(int n2, List<StackTraceElement> list) {
        return this.isIBMJava() ? this.adjustOffsetIfNeeded(list, n2) : n2;
    }

    @z
    int adjustOffsetIfNeeded(List<StackTraceElement> list, int n2) {
        if (list.size() >= 3) {
            String string = list.get(1).getClassName();
            if (string.equals(ContrastDataFlowPropagationDispatcherImpl.class.getName())) {
                String string2 = list.get(1).getMethodName();
                if ("propagate".equals(string2)) {
                    logger.debug("Adjusting frame depth due to IBM weirdness");
                    return 2;
                }
                logger.trace("No need to adjust frame depth, method name was: {}", (Object)string2);
            } else {
                logger.trace("No need to adjust frame depth, class was: {}", (Object)string);
            }
        }
        return n2;
    }

    public boolean attemptToEnterExclusiveAccess() {
        return this.currentlyDeadzoning.compareAndSet(false, true);
    }

    public void exitExclusiveAccess() {
        boolean bl = this.currentlyDeadzoning.compareAndSet(true, false);
        if (!bl) {
            logger.warn("Leaving adaptive optimisation for propagation deadzoning, exclusive check failed on exit: {}", (Object)this.getId());
        }
    }

    public void setTargetDescription(String string) {
        this.targetType = string;
    }

    public String getPropagationType() {
        return this.propagationType;
    }

    public String[] getCommandArguments() {
        return this.cmdArguments;
    }

    public int getParameterValue(int n2, Object[] objectArray) {
        if (this.cmdArguments == null || this.cmdArguments.length == 0 || this.integerCmdArguments == null || this.integerCmdArguments.length == 0) {
            logger.error("Configuration problem 1 with command parameters for {}", (Object)this.getId());
        }
        if (this.isLiteralCmdArguments != null && this.isLiteralCmdArguments[n2]) {
            return this.integerCmdArguments[n2];
        }
        if (objectArray == null || n2 > this.integerCmdArguments.length || this.integerCmdArguments[n2] > objectArray.length) {
            logger.error("Configuration problem 2 with command parameters for {}", (Object)this.getId());
        }
        return (Integer)objectArray[this.integerCmdArguments[n2]];
    }

    public Command getCommand() {
        return this.cmd;
    }

    private void parseCommandArguments() {
        boolean bl = this.cmdArguments != null;
        int n2 = bl ? this.cmdArguments.length : 0;
        this.integerCmdArguments = new int[n2];
        this.isLiteralCmdArguments = new boolean[n2];
        if (bl && (n2 != 1 || this.cmdArguments[0].length() > 0)) {
            for (int i2 = 0; i2 < this.cmdArguments.length; ++i2) {
                if (this.cmdArguments[i2].charAt(0) == 'P') {
                    this.cmdArguments[i2] = this.cmdArguments[i2].substring(1);
                    this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]) - 1;
                    continue;
                }
                this.isLiteralCmdArguments[i2] = true;
                this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]);
            }
        }
    }

    private void setLiteralCommandArguments(boolean[] blArray) {
        this.isLiteralCmdArguments = blArray;
    }

    private void setIntegerCommandArguments(int[] nArray) {
        this.integerCmdArguments = nArray;
    }

    public Propagator clone() {
        Propagator propagator = new Propagator(this.policyId, this.policyLocation, this.getId(), this.sources, this.targets, this.cmd, this.cmdArguments != null ? (String[])this.cmdArguments.clone() : null, this.tags, this.untags, this.cloneOnUnchangedCloneableSource, this.shouldTagsApplyWhenInvokedDuringSources, this.getMethodMatcher());
        propagator.setLiteralCommandArguments(this.isLiteralCmdArguments != null ? (boolean[])this.isLiteralCmdArguments.clone() : null);
        propagator.setIntegerCommandArguments(this.integerCmdArguments != null ? (int[])this.integerCmdArguments.clone() : null);
        propagator.deep = this.deep;
        propagator.scoped = this.scoped;
        propagator.operation = this.operation;
        return propagator;
    }

    void setRequiredParameterTypes(Set<String> set) {
        this.requiredParameterTypes = set;
    }

    private void calculatePropagationType() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (m m2 : this.sources) {
            bl = bl || m2.a();
            bl2 = bl2 || m2.c();
        }
        m[] mArray = this.targets;
        int n2 = mArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            m m2;
            m2 = mArray[i2];
            bl3 = bl3 || m2.a();
            bl4 = bl4 || m2.c();
            bl5 = bl5 || m2.b();
        }
        boolean bl6 = bl && bl2;
        int n3 = n2 = bl3 && bl4 || bl3 && bl5 || bl4 && bl5 ? 1 : 0;
        if (bl6) {
            if (n2 != 0) {
                this.propagationType = TYPE_A2A;
            } else if (bl3) {
                this.propagationType = TYPE_A2O;
            } else if (bl4) {
                this.propagationType = TYPE_A2P;
            } else if (bl5) {
                this.propagationType = TYPE_A2R;
            }
        } else if (bl) {
            if (n2 != 0) {
                this.propagationType = TYPE_O2A;
            } else if (bl3) {
                this.propagationType = TYPE_O2O;
            } else if (bl4) {
                this.propagationType = TYPE_O2P;
            } else if (bl5) {
                this.propagationType = TYPE_O2R;
            }
        } else if (bl2) {
            if (n2 != 0) {
                this.propagationType = TYPE_P2A;
            } else if (bl3) {
                this.propagationType = TYPE_P2O;
            } else if (bl4) {
                this.propagationType = TYPE_P2P;
            } else if (bl5) {
                this.propagationType = TYPE_P2R;
            }
        }
    }

    @Override
    protected String getTypeLabel() {
        return "propagator";
    }

    @z
    boolean isIBMJava() {
        return t.c();
    }

    @Sensor
    public static enum Command {
        ALL,
        INSERT,
        APPEND,
        REMOVE,
        REPLACE,
        SUBSET,
        KEEP,
        GUESS,
        CONCAT,
        PREPEND,
        OVERWRITE,
        STRIP_WHITESPACE,
        STRIP_TRAILING_WHITESPACE,
        STRIP_LEADING_WHITESPACE;

    }
}

