/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.sessiontimeout;

import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.r;
import com.contrastsecurity.agent.commons.s;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.e.b;
import com.contrastsecurity.agent.e.e;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.sessiontimeout.e;
import com.contrastsecurity.agent.plugins.security.t;
import com.contrastsecurity.agent.s.i;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.IXMLElement;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.XMLElement;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.XMLException;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;

@Singleton
@Sensor
final class ContrastSessionTimeoutRuleDispatcherImpl
implements ContrastSessionTimeoutRuleDispatcher {
    private static final Logger a = LoggerFactory.getLogger(ContrastSessionTimeoutRuleDispatcherImpl.class);
    private static final e.b<r> b = e.b.a(r.class);
    private final ApplicationManager c;
    private final ProviderUtil d;
    private final com.contrastsecurity.agent.plugins.frameworks.j2ee.e e;
    private final long f;

    @Inject
    public ContrastSessionTimeoutRuleDispatcherImpl(ApplicationManager applicationManager, ProviderUtil providerUtil, com.contrastsecurity.agent.plugins.frameworks.j2ee.e e2, g g2) {
        this.c = applicationManager;
        this.d = providerUtil;
        this.e = e2;
        this.f = com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.sessiontimeout.e.a(g2);
    }

    @z
    static int a(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 % 60 == 0) {
            return n2 / 60;
        }
        if (n2 < 0) {
            return n2 / 60 - 1;
        }
        return n2 / 60 + 1;
    }

    @z
    static String a(com.contrastsecurity.agent.plugins.frameworks.j2ee.e e2, int n2, Object object, Application application) {
        IXMLElement iXMLElement = ContrastSessionTimeoutRuleDispatcherImpl.a(e2, object, application);
        if (iXMLElement == null) {
            return null;
        }
        return ContrastSessionTimeoutRuleDispatcherImpl.a(n2, iXMLElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IXMLElement a(com.contrastsecurity.agent.plugins.frameworks.j2ee.e e2, Object object, Application application) {
        InputStreamReader inputStreamReader;
        InputStream inputStream;
        block8: {
            IXMLElement iXMLElement;
            XMLElement xMLElement;
            block7: {
                Object object2 = e2.d(object);
                if (object2 == null) {
                    return null;
                }
                inputStream = e2.a(object2, "/WEB-INF/web.xml");
                if (inputStream == null) {
                    return null;
                }
                inputStreamReader = null;
                inputStreamReader = new InputStreamReader(inputStream);
                xMLElement = i.a(inputStreamReader);
                if (xMLElement != null) break block7;
                IXMLElement iXMLElement2 = null;
                IOUtils.closeQuietly(inputStream, inputStreamReader);
                return iXMLElement2;
            }
            try {
                IXMLElement iXMLElement3 = xMLElement.getFirstChildNamed("session-config");
                if (iXMLElement3 == null) break block8;
                iXMLElement = iXMLElement3.getFirstChildNamed("session-timeout");
            }
            catch (XMLException xMLException) {
                try {
                    a.debug("Unable to parse /WEB-INF/web.xml for app with name={}.", (Object)application, (Object)xMLException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream, inputStreamReader);
                    throw throwable;
                }
                IOUtils.closeQuietly(inputStream, inputStreamReader);
            }
            IOUtils.closeQuietly(inputStream, inputStreamReader);
            return iXMLElement;
        }
        IOUtils.closeQuietly(inputStream, inputStreamReader);
        return null;
    }

    private static String a(int n2, IXMLElement iXMLElement) {
        int n3;
        String string = StringUtils.trimToNull(iXMLElement.getContent());
        if (string == null) {
            return null;
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n2 == n3) {
            return ContrastSessionTimeoutRuleDispatcherImpl.a(iXMLElement);
        }
        if (!(n2 != 0 && n2 != -1 || n3 != 0 && n3 != -1)) {
            return ContrastSessionTimeoutRuleDispatcherImpl.a(iXMLElement);
        }
        return null;
    }

    private static String a(IXMLElement iXMLElement) {
        return iXMLElement.getLineNr() + ": <" + iXMLElement.getName() + ">" + StringUtils.trimToEmpty(iXMLElement.getContent()) + "</" + iXMLElement.getName() + ">\n";
    }

    @ScopedSensor
    public void onSessionObtained(Object object) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        ContrastSessionTimeoutRuleDispatcherImpl contrastSessionTimeoutRuleDispatcherImpl = this;
        Object object2 = object;
        try {
            if (object2 == null) {
                a.debug("Session provided to {} was null. Skipping checks for overly-long session timeout.", (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
            } else {
                Application application = contrastSessionTimeoutRuleDispatcherImpl.c.current();
                if (application == null) {
                    a.debug("Current application provided to {} was null. Skipping checks for overly-long session timeout.", (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
                } else if (!application.getState().b()) {
                    a.debug("Current application {} provided to {} was not resolved. Skipping checks for overly-long session timeout.", (Object)application, (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
                } else {
                    b b2 = application.context();
                    if (b2.a(b) == null) {
                        Integer n2 = contrastSessionTimeoutRuleDispatcherImpl.e.c(object2);
                        if (n2 == null) {
                            a.debug("HttpSession.getMaxInactiveInterval() threw an error or returned null. Skipping checks for overly-long session timeout.");
                        } else {
                            b2.b(b, s.a(() -> {
                                boolean bl;
                                boolean bl2 = bl = n2 < 1;
                                if (bl || (long)n2.intValue() > this.f) {
                                    long l2 = t.b.a("session-timeout", application.getResolvedFilePath() + File.separatorChar + "WEB-INF" + File.separatorChar + "web.xml");
                                    int n3 = ContrastSessionTimeoutRuleDispatcherImpl.a(n2);
                                    String string = ContrastSessionTimeoutRuleDispatcherImpl.a(this.e, n3, object2, application);
                                    boolean bl3 = string == null;
                                    this.d.reportFinding(application, "session-timeout", bl3 ? "servletContext.setSessionTimeout(" + n3 + ")" : string, l2, null, false, null);
                                    a.debug("Found vulnerable session timeout value {} (a timeout of zero or less indicates an unlimited timeout) for application: {}. Session timeout values must be less than configured value of {} from {}.", new Object[]{n2, application, this.f, ConfigProperty.WEB_SESSION_TIMEOUT});
                                } else {
                                    a.debug("Found safe session timeout value {} for application: {}. Session timeout values must be less than configured value of {} from {}.", new Object[]{n2, application, this.f, ConfigProperty.WEB_SESSION_TIMEOUT});
                                }
                                return null;
                            }));
                            b2.a(b).get();
                        }
                    }
                }
            }
            contrastSessionTimeoutRuleDispatcherImpl = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (contrastSessionTimeoutRuleDispatcherImpl != null) {
            throw contrastSessionTimeoutRuleDispatcherImpl;
        }
    }
}

