/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.p;
import com.contrastsecurity.agent.commons.q;
import com.contrastsecurity.agent.commons.u;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.services.Purgeable;
import com.contrastsecurity.agent.services.h;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.util.E;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Objects;

@DontObfuscate
public final class PurgeThread
extends Thread {
    private final h service;
    private final List<Purgeable> purgeables;
    private final boolean profilePurgeables;
    private final q sleeper;
    private final o errorEmitter;
    private static final Logger logger = LoggerFactory.getLogger(PurgeThread.class);

    PurgeThread(h h2, g g2, List<Purgeable> list, o o2) {
        this.service = h2;
        this.purgeables = list;
        this.profilePurgeables = g2.f(ConfigProperty.PROFILE_PURGEABLES);
        this.sleeper = new p();
        this.errorEmitter = Objects.requireNonNull(o2);
    }

    @Override
    @ScopedSensor
    public void run() {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        PurgeThread purgeThread = this;
        try {
            while (purgeThread.service.a) {
                int n2 = 0;
                int n3 = 0;
                for (Purgeable purgeable : purgeThread.purgeables) {
                    int n4 = purgeable.purgeableCount();
                    try {
                        purgeable.purgeStale();
                    }
                    catch (Throwable throwable) {
                        u.a(throwable);
                        purgeThread.errorEmitter.a(throwable);
                        logger.error("Problem clearing purgeable {}", (Object)N.a(purgeable), (Object)throwable);
                    }
                    int n5 = purgeable.purgeableCount();
                    n2 += n5 - n4;
                    n3 += n5;
                    if (purgeThread.profilePurgeables) {
                        E.a("Purgeable: [" + N.a(purgeable) + "], before=" + n4 + ", after=" + n5);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Purgeable={}, before={}, after={}", N.a(purgeable), n4, n5);
                }
                logger.debug("Total purged={}, total still alive={}", (Object)n2, (Object)n3);
                purgeThread.sleeper.a(30000L);
            }
            logger.info("Stopped purging thread.");
            purgeThread = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (purgeThread != null) {
            throw purgeThread;
        }
    }
}

