/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.java.codeinfo.LibraryFacts;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.commons.u;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.d.e;
import com.contrastsecurity.agent.eventbus.EventBus;
import com.contrastsecurity.agent.g.a;
import com.contrastsecurity.agent.messages.app.ApplicationResponse;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.plugins.a.h;
import com.contrastsecurity.agent.plugins.a.k;
import com.contrastsecurity.agent.plugins.frameworks.p;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.i;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.services.ngreporting.j;
import com.contrastsecurity.agent.services.ngreporting.m;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.thirdparty.com.google.gson.Gson;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Objects;

public class c
extends m {
    private static final String c = "Contrast Application Updater";
    private final k d;
    private final g e;
    private final Gson f;
    private final d g;
    private final f h;
    private final a i;
    private final long j;
    private final p k;
    private final o l;
    private static final Logger m = LoggerFactory.getLogger(c.class);

    c(a a2, ApplicationManager applicationManager, p p2, k k2, ContrastEngine contrastEngine, g g2, Gson gson, d d2, f f2, ScopeProvider scopeProvider, o o2) {
        super(c, g2.e(ConfigProperty.APP_UPDATE_PERIOD), applicationManager, contrastEngine, scopeProvider, o2);
        this.k = p2;
        this.d = k2;
        this.i = a2;
        this.e = g2;
        this.f = gson;
        this.g = d2;
        this.j = g2.e(ConfigProperty.APP_UPDATE_STALE_THRESHOLD);
        this.h = f2;
        this.l = Objects.requireNonNull(o2);
    }

    @Override
    void a() {
        Collection<Application> collection = this.b.getApplications();
        for (Application application : collection) {
            if (application.isUnwantedOnServer()) continue;
            try {
                this.b(application);
                this.b.inventory(this.k, application);
                if (this.a(application)) {
                    if (m.isDebugEnabled()) {
                        m.debug("Sending app update for {} [dirty={}]", (Object)application, (Object)application.isDirty());
                    }
                    this.c(application);
                    continue;
                }
                m.debug("Not sending an app update for {} [dirty={},lastReport={},lastChange={}]", application, application.isDirty(), application.getLastReportedTime(), application.getLastChangeOccurred());
            }
            catch (Throwable throwable) {
                u.a(throwable);
                this.i.a(m, "Problem with app updater process", throwable);
                this.l.a(throwable);
            }
        }
    }

    boolean a(Application application) {
        if (!this.e.f(ConfigProperty.INVENTORY_ENABLED)) {
            m.debug("Inventory disabled by config... skipping");
            return false;
        }
        return application.getState().c() && !application.isUnwantedOnServer() && (application.isDirty() || this.d(application));
    }

    private boolean d(Application application) {
        long l2 = application.getLastReportedTime();
        long l3 = this.g.a();
        return l3 - l2 > this.j;
    }

    void b(Application application) {
        if (!application.getState().f()) {
            return;
        }
        m.debug("Sending appcreate for: {}", (Object)application);
        j j2 = new j(application, this.e);
        e<String> e2 = this.h.b(j2);
        int n2 = e2 != null ? e2.a() : -1;
        switch (n2) {
            case 200: {
                m.info("Successfully created app on TeamServer: {}", (Object)application);
                application.created();
                ApplicationResponse applicationResponse = this.f.fromJson(e2.b(), ApplicationResponse.class);
                ApplicationSettingsDTM applicationSettingsDTM = applicationResponse.getSettings();
                if (applicationSettingsDTM != null) {
                    this.d.a(application, applicationSettingsDTM, this.g.a());
                }
                EventBus.get().onApplicationResolved(application);
                break;
            }
            case 409: {
                com.contrastsecurity.agent.services.i.a(n2, e2.b(), application, "appcreate");
                break;
            }
            case -1: {
                m.info("Can't send appcreate to TeamServer - nobody's answering. Marking as created.");
                EventBus.get().onApplicationResolved(application);
                application.created();
                break;
            }
            default: {
                m.error("Problem creating app on TeamServer: {}, status={}", (Object)application, (Object)n2);
            }
        }
    }

    void c(Application application) {
        m.debug("Generating app report for {}", (Object)application);
        h h2 = new h(application);
        this.h.a(h2);
        this.b.onApplicationUpdate(application);
        application.markClean();
        application.setLastReportedTime(this.g.a());
        m.debug("Queued app update report for {}", (Object)application);
        Collection<LibraryFacts> collection = application.getAllLibraryFacts();
        for (LibraryFacts libraryFacts : collection) {
            if (libraryFacts.getUsedClasses().isEmpty()) continue;
            application.getActivity().addUpdatedLibrary(libraryFacts);
        }
    }
}

