/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.u;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.config.i;
import com.contrastsecurity.agent.d.e;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.reloadable.AgentChannelHub;
import com.contrastsecurity.agent.services.a;
import com.contrastsecurity.agent.services.ngreporting.LegacyReport;
import com.contrastsecurity.agent.services.ngreporting.d;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.services.ngreporting.l;
import com.contrastsecurity.agent.services.ngreporting.n;
import com.contrastsecurity.agent.services.ngreporting.o;
import com.contrastsecurity.agent.services.ngreporting.p;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class g
implements a,
f,
o {
    private final Map<Long, Long> a = new ConcurrentHashMap<Long, Long>();
    private final Queue<LegacyReport> b = new ConcurrentLinkedQueue<LegacyReport>();
    private volatile boolean c;
    private Thread d;
    private final d e;
    private final long f;
    private final boolean g;
    private final com.contrastsecurity.agent.config.g h;
    private final n i;
    private final com.contrastsecurity.agent.commons.d j;
    private final com.contrastsecurity.agent.b.i k;
    private final long l;
    private final com.contrastsecurity.agent.telemetry.errors.o m;
    private static final String n = "clearReportingQueues";
    private static final Logger o = LoggerFactory.getLogger(g.class);

    public g(com.contrastsecurity.agent.config.g g2, com.contrastsecurity.agent.commons.d d2, n n2, com.contrastsecurity.agent.b.i i2, com.contrastsecurity.agent.config.z z2, com.contrastsecurity.agent.telemetry.errors.o o2) {
        this.h = Objects.requireNonNull(g2);
        this.j = Objects.requireNonNull(d2);
        this.k = Objects.requireNonNull(i2);
        this.i = n2;
        this.m = Objects.requireNonNull(o2);
        this.l = g2.e(ConfigProperty.DUP_DELAY);
        this.e = new d(g2, z2);
        this.f = g2.e(ConfigProperty.LEGACY_REPORTING_PERIOD);
        this.g = g2.f(ConfigProperty.PREFLIGHT_FAIL_OPEN);
        this.d();
        this.c = true;
    }

    void d() {
        AgentChannelHub agentChannelHub = AgentChannelHub.get();
        agentChannelHub.listenForMessage(n, object -> {
            o.debug("Received request to clear reporting queues");
            Object object2 = this.a;
            synchronized (object2) {
                if (o.isDebugEnabled()) {
                    o.debug("Clearing {} events from trace cache {}", (Object)this.a.size(), (Object)this.a);
                }
                this.a.clear();
            }
            object2 = this.b;
            synchronized (object2) {
                o.debug("Clearing {} events from report queue", (Object)this.b.size());
                this.b.clear();
            }
            return null;
        });
    }

    Queue<LegacyReport> e() {
        return this.b;
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public String b() {
        return "LegacyReporting";
    }

    @Override
    public synchronized void a(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        if (this.d != null) {
            return;
        }
        this.c = true;
        this.d = new Thread(() -> {
            while (this.c) {
                try {
                    this.f();
                }
                catch (Throwable throwable) {
                    u.a(throwable);
                    this.m.a(throwable);
                    o.error("Problem sending reports to Contrast TeamServer", throwable);
                }
                try {
                    Thread.sleep(this.f);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.f();
        });
        o.info("Starting reporting thread...");
        this.d.setName("Contrast Reporting");
        this.d.setPriority(2);
        this.d.setDaemon(true);
        this.d.start();
    }

    @Override
    public synchronized void c() {
        if (this.d == null) {
            return;
        }
        this.c = false;
        Thread thread = this.d;
        this.d = null;
        thread.interrupt();
        o.debug("Processing remaining elements in the reporting queue");
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            o.debug("Processing remaining elements in the queue - interrupted");
            return;
        }
        o.debug("Processing remaining elements in the queue - done");
    }

    @Override
    public a.a i() {
        return a.a.b;
    }

    private boolean c(LegacyReport legacyReport) {
        long l2 = legacyReport.getHash();
        if (this.a(l2)) {
            legacyReport.onIgnoredAsAlreadyReported();
            if (o.isDebugEnabled()) {
                o.debug("LegacyReport {} already reported to server: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return false;
        }
        if (this.b.offer(legacyReport)) {
            this.a.put(l2, this.j.a());
            legacyReport.onAcceptedIntoReportingQueue();
            if (o.isDebugEnabled()) {
                o.debug("Trace {} added to reporting queue: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return true;
        }
        if (o.isDebugEnabled()) {
            o.debug("Trace {} was skipped as reporting queue was full: {}", (Object)l2, (Object)legacyReport.getShortDescription());
        }
        return false;
    }

    @Override
    public boolean a(long l2) {
        if (l2 == 0L) {
            return false;
        }
        long l3 = this.j.a();
        Long l4 = this.a.get(l2);
        return l4 != null && l3 - l4 <= this.l;
    }

    @z
    void f() {
        int n2;
        ArrayList<LegacyReport> arrayList;
        SaveReportMode saveReportMode;
        boolean bl;
        block20: {
            LegacyReport legacyReport;
            ArrayList<LegacyReport> arrayList2 = new ArrayList<LegacyReport>();
            ArrayList<LegacyReport> arrayList3 = new ArrayList<LegacyReport>();
            bl = false;
            saveReportMode = com.contrastsecurity.agent.services.ngreporting.g.a(this.h);
            boolean bl2 = SaveReportMode.Always.equals((Object)saveReportMode);
            while ((legacyReport = this.b.poll()) != null) {
                Application application = legacyReport.getApplication();
                if (application == null) {
                    arrayList3.add(legacyReport);
                } else if (!application.isUnwantedOnServer()) {
                    if (!application.getState().c()) {
                        arrayList2.add(legacyReport);
                    } else {
                        arrayList3.add(legacyReport);
                    }
                }
                if (!bl2) continue;
                this.e.a(legacyReport);
                bl = true;
            }
            int n3 = arrayList2.size();
            if (n3 > 0) {
                this.b.addAll(arrayList2);
                o.debug("Held back {} reports until app created.", (Object)n3);
            }
            if (arrayList3.size() == 0) {
                return;
            }
            if (this.i == null) {
                return;
            }
            arrayList = new ArrayList<LegacyReport>();
            HashMap<Integer, LegacyReport> hashMap = new HashMap<Integer, LegacyReport>();
            n2 = 0;
            for (LegacyReport object2 : arrayList3) {
                if (object2.requiresPreflight()) {
                    hashMap.put(n2++, object2);
                    if (!(object2 instanceof h)) continue;
                    this.a((h)object2);
                    continue;
                }
                o.debug("Adding {} to preflight approved reports", (Object)object2.getHash());
                arrayList.add(object2);
            }
            if (!hashMap.isEmpty()) {
                try {
                    arrayList.addAll(this.i.a(hashMap));
                }
                catch (IOException iOException) {
                    if (saveReportMode.equals((Object)SaveReportMode.OnError)) {
                        for (Object object : hashMap.values()) {
                            this.e.a((LegacyReport)object);
                        }
                        bl = true;
                    }
                    if (o.isDebugEnabled()) {
                        String string = this.g ? "adding all" : "not adding any";
                        o.debug("Problem asking for preflight acceptance of reports - {} to approved list", (Object)string, (Object)iOException);
                    }
                    if (!this.g) break block20;
                    arrayList.addAll(hashMap.values());
                }
            }
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            int n3;
            Object object;
            LegacyReport legacyReport = (LegacyReport)arrayList.get(i2);
            if (legacyReport instanceof h) {
                this.b((h)legacyReport);
            }
            int n4 = n3 = (object = this.i.a(legacyReport)) != null ? ((e)object).a() : -1;
            if (saveReportMode.equals((Object)SaveReportMode.OnError) && n3 == -1 && !bl) {
                this.e.a(legacyReport);
            }
            ++n2;
            if (!this.h()) continue;
            o.warn("Received bad response after sending {} of {} approved reports. Dumping the queue and pausing service.", (Object)n2, (Object)arrayList.size());
            this.j();
            break;
        }
        o.trace("Sent out {} reports to server", (Object)n2);
    }

    private void a(h h2) {
        p p2 = h2.getListener();
        if (p2 != null) {
            p2.a(h2);
        }
    }

    private void b(h h2) {
        p p2 = h2.getListener();
        if (p2 != null) {
            p2.b(h2);
        }
    }

    @Override
    public e<String> b(LegacyReport legacyReport) {
        e<String> e2 = null;
        if (this.g()) {
            o.debug("Not sending report because reporting service is still paused");
        } else if (!this.c) {
            o.debug("Not sending report because reporting service is stopped");
        } else if (this.i != null) {
            e2 = this.i.a(legacyReport);
            int n2 = e2 != null ? e2.a() : -1;
            SaveReportMode saveReportMode = com.contrastsecurity.agent.services.ngreporting.g.a(this.h);
            if (SaveReportMode.OnError.equals((Object)saveReportMode) && n2 == -1 || SaveReportMode.Always.equals((Object)saveReportMode)) {
                this.e.a(legacyReport);
            }
        }
        if (this.h()) {
            this.j();
        }
        return e2;
    }

    @Override
    public boolean a(LegacyReport legacyReport) {
        if (this.g()) {
            o.debug("Not queuing report because reporting service is still paused by an earlier 401 or 412");
            return false;
        }
        if (!this.c) {
            o.debug("Not queueing report because reporting service is stopped");
            return false;
        }
        String string = this.h.b(ConfigProperty.VM_ID);
        if (legacyReport.getApplication() != null) {
            string = legacyReport.getApplication().getName();
        }
        if (o.isDebugEnabled()) {
            l l2 = null;
            String string2 = "Unable to generate report JSON";
            try {
                string2 = legacyReport.getPayload();
            }
            catch (l l3) {
                l2 = l3;
            }
            o.debug("\n\tApplication: {}\n\tReportMethod: {}\n\tReportURL(): {}\n\tReportLevel(): {}\n\tReportType(): {}\n\tReportJSON():\n{}\n", new Object[]{string, legacyReport.getMethod(), legacyReport.getURL(), legacyReport.getLevel(), legacyReport.getClass().getSimpleName(), string2, l2});
        }
        return this.c(legacyReport);
    }

    boolean g() {
        return this.k.b();
    }

    boolean h() {
        return this.k.b();
    }

    void j() {
        this.b.clear();
        o.warn("Clearing reporting service queue and pausing reports because of paused TeamServer channel");
    }

    void k() {
        this.a.clear();
    }

    void l() {
        this.b.clear();
    }

    static SaveReportMode a(com.contrastsecurity.agent.config.g g2) {
        String string = g2.b(ConfigProperty.SAVERESULTS);
        SaveReportMode saveReportMode = SaveReportMode.valueOfIgnoreCase(string);
        if (saveReportMode == null) {
            throw new i("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.SAVERESULTS) + ". Valid values are Always, Never, OnError.");
        }
        return saveReportMode;
    }
}

