/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace.snapshot;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.m;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.snapshot.CharSequenceSnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.DataSnapshot;
import com.contrastsecurity.agent.trace.snapshot.c;
import com.contrastsecurity.agent.trace.snapshot.u;
import com.contrastsecurity.agent.trace.snapshot.v;
import com.contrastsecurity.agent.z;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.Weigher;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;

@DontObfuscate
final class StringCacheSnapshotFactory
implements u<String> {
    @z
    final Map<String, char[]> truncatedCache;
    @z
    final Map<String, char[]> untruncatedCache;
    private final int minStringSize;
    private final int maxStringSize;
    private final CharSequenceSnapshotFactory csFactory;
    private static final int ESTIMATED_CONCURRENT_THREADS = 25;
    private static final String LM_CACHE_LOOKUP = "StringSnapshotCache";
    private static final Logger logger = LoggerFactory.getLogger(StringCacheSnapshotFactory.class);

    StringCacheSnapshotFactory(g g2, CharSequenceSnapshotFactory charSequenceSnapshotFactory) {
        this.csFactory = charSequenceSnapshotFactory;
        this.minStringSize = g2.d(ConfigProperty.ASSESS_SNAPSHOT_CACHE_MIN_STRING_SIZE);
        this.maxStringSize = g2.d(ConfigProperty.ASSESS_SNAPSHOT_CACHE_MAX_STRING_SIZE);
        int n2 = g2.d(ConfigProperty.ASSESS_SNAPSHOT_CACHE_MAX_SIZE);
        m.a(n2 % 4 == 0, "need maxCacheSize % 4 == 0");
        m.a(this.minStringSize > 0, "need minStringSize > 0");
        m.a(this.maxStringSize > this.minStringSize, "need maxStringSize > minStringSize");
        m.a(n2 >= this.minStringSize, "need cache to be bigger than at least 1 minStringSize");
        int n3 = n2 / 4;
        Weigher<char[]> weigher = cArray -> ((char[])cArray).length;
        this.untruncatedCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(n3 / 2).concurrencyLevel(25).maximumWeightedCapacity(n3).weigher(weigher).build();
        int n4 = n3 * 3;
        this.truncatedCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(n4 / 2).concurrencyLevel(25).maximumWeightedCapacity(n4).weigher(weigher).build();
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof String;
    }

    @Override
    public char[] snapshot(String string) {
        int n2 = string.length();
        if (n2 > this.maxStringSize || n2 < this.minStringSize) {
            this.logCacheLookupMiss(v.a, a.a, string);
            return null;
        }
        char[] cArray = this.untruncatedCache.get(string);
        if (cArray != null) {
            this.logCacheLookupHit(v.a, n2, string);
            return cArray;
        }
        this.logCacheLookupMiss(v.a, a.b, string);
        cArray = this.csFactory.snapshot(string);
        this.tryCache(this.untruncatedCache, string, cArray);
        return cArray;
    }

    @Override
    public char[] snapshotAndTruncate(String string) {
        int n2 = string.length();
        if (n2 > this.maxStringSize || n2 < this.minStringSize) {
            this.logCacheLookupMiss(v.b, a.a, string);
            return null;
        }
        char[] cArray = this.truncatedCache.get(string);
        if (cArray != null) {
            this.logCacheLookupHit(v.b, n2, string);
            return cArray;
        }
        cArray = this.csFactory.snapshotAndTruncate(string);
        this.tryCache(this.truncatedCache, string, cArray);
        return cArray;
    }

    @Override
    public DataSnapshot snapshotAndTruncate(String string, TagRanges tagRanges) {
        return null;
    }

    private void tryCache(Map<String, char[]> map, String string, char[] cArray) {
        if (cArray != null) {
            map.put(string, cArray);
        }
    }

    private void logCacheLookupMiss(v v2, a a2, String string) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}|{}|snapshotType={}&reason={}&value={}", new Object[]{LM_CACHE_LOOKUP, c.b, v2, a2, string});
        }
    }

    private void logCacheLookupHit(v v2, int n2, Object object) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}|{}|snapshotType={}&size={}&value={}", new Object[]{LM_CACHE_LOOKUP, c.a, v2, n2, object});
        }
    }

    private static enum a {
        a("TooBigOrSmall"),
        b("NotInCache");

        private final String c;

        private a(String string2) {
            this.c = string2;
        }

        public String toString() {
            return this.c;
        }
    }
}

