/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.m.d;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonWriter;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@DontObfuscate
public class ContrastJsonWriter
extends JsonWriter {
    private Field stackField;
    private Field stackSizeField;
    private Method pushMethod;
    private static final String RESET_KEY = "ContrastJsonWriter.reset";
    private static final String RESET_ELIGIBLE_KEY = "ContrastJsonWriter.resetEligible";
    private static final Logger logger = LoggerFactory.getLogger(ContrastJsonWriter.class);

    public ContrastJsonWriter(Writer writer) {
        super(writer);
        Class<?> clazz = this.getClass().getSuperclass();
        this.reflectStack(clazz);
        this.reflectStackSize(clazz);
        this.reflectPush(clazz);
    }

    public boolean reset() {
        boolean bl;
        block3: {
            bl = false;
            if (this.canReset()) {
                try {
                    this.stackField.set(this, new int[32]);
                    this.stackSizeField.setInt(this, 0);
                    this.pushMethod.invoke((Object)this, 6);
                    bl = true;
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) break block3;
                    a.a(RESET_KEY, logger, "Unable to reset JsonWriter {(stackfield:" + this.stackField + "),(stackSizeField:" + this.stackSizeField + "),(pushMethod:" + this.pushMethod + ")}.", (Throwable)exception);
                }
            }
        }
        return bl;
    }

    private void reflectStack(Class<?> clazz) {
        try {
            this.stackField = d.d(clazz, "stack");
        }
        catch (Exception exception) {
            logger.error("Unable to reflect JsonWriter stack field.", exception);
        }
    }

    private void reflectStackSize(Class<?> clazz) {
        try {
            this.stackSizeField = d.d(clazz, "stackSize");
        }
        catch (Exception exception) {
            logger.error("Unable to reflect JsonWriter stackSize field.", exception);
        }
    }

    private void reflectPush(Class<?> clazz) {
        try {
            this.pushMethod = d.d(clazz, "push", Integer.TYPE);
        }
        catch (Exception exception) {
            logger.error("Unable to reflect JsonWriter push method.", exception);
        }
    }

    private boolean canReset() {
        if (this.stackField != null && this.stackSizeField != null && this.pushMethod != null) {
            return true;
        }
        a.a(RESET_ELIGIBLE_KEY, logger, "Cannot reset JsonWriter because not all fields are available {(stackfield:" + this.stackField + "),(stackSizeField:" + this.stackSizeField + "),(pushMethod:" + this.pushMethod + ")}. Will continue without reusing writer.");
        return false;
    }
}

