/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.action.analyzelog.h;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.commons.t;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.server.features.assessment.SamplingFeatures;
import com.contrastsecurity.agent.plugins.security.c.f;
import com.contrastsecurity.agent.plugins.security.model.i;
import com.contrastsecurity.agent.util.q;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.math.NumberUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;

public final class H {
    private final d a;
    private final boolean b;
    private final SamplingFeatures c;
    private final g d;
    private final Map<Long, f> e;
    private static final int f = 180;
    private static final int g = 5;
    private static final int h = 5;
    private static final int i = 25;
    private static final Logger j = LoggerFactory.getLogger(H.class);

    public H(g g2) {
        this(g2, new t());
    }

    H(g g2, d d2) {
        Objects.requireNonNull(g2, () -> "config parameter cannot be null");
        Objects.requireNonNull(d2, () -> "clock parameter cannot be null");
        this.a = d2;
        this.d = g2;
        this.e = new ConcurrentHashMap<Long, f>();
        String string = g2.c(ConfigProperty.SAMPLING);
        boolean bl = this.b = string != null;
        if (this.b) {
            com.contrastsecurity.agent.action.analyzelog.h.a("Sampling");
            this.c = new SamplingFeatures();
            int n2 = 5;
            int n3 = 5;
            int n4 = 180;
            if (!StringUtils.isEmpty(string)) {
                String[] stringArray = string.split(",");
                if (stringArray.length == 3) {
                    n2 = NumberUtils.toInt(stringArray[0], 5);
                    n3 = NumberUtils.toInt(stringArray[1], 5);
                    n4 = NumberUtils.toInt(stringArray[2], 180);
                }
                if (n2 <= 0) {
                    j.warn("Invalid sampling baseline value {} -- overriding to {}", (Object)n2, (Object)5);
                    n2 = 5;
                }
                if (n3 <= 0) {
                    j.warn("Invalid sampling request frequency value {} -- overriding to {}", (Object)n3, (Object)5);
                    n3 = 5;
                }
                if (n4 <= 0) {
                    j.warn("Invalid sampling window value {} -- overriding to {}", (Object)n4, (Object)180);
                    n4 = 180;
                }
                this.c.setBaseline(n2);
                this.c.setRequestFrequency(n3);
                this.c.setResponseFrequency(25);
                this.c.setWindow(n4);
            }
        } else {
            this.c = null;
        }
    }

    public i a(HttpRequest httpRequest) {
        boolean bl;
        boolean bl2;
        int n2;
        int n3;
        int n4;
        int n5;
        i i2 = new i();
        f f2 = this.b(httpRequest);
        ++f2.b;
        ++f2.a;
        if (this.b) {
            n5 = this.c.getBaseline();
            n4 = this.c.getRequestFrequency();
            n3 = this.c.getResponseFrequency();
            n2 = this.c.getWindow();
        } else if (this.d.f(ConfigProperty.ASSESS_SAMPLING_ENABLED)) {
            n5 = this.d.d(ConfigProperty.ASSESS_SAMPLING_BASELINE);
            n4 = this.d.d(ConfigProperty.ASSESS_SAMPLING_REQ_FREQUENCY);
            n3 = this.d.d(ConfigProperty.ASSESS_SAMPLING_RES_FREQUENCY);
            n2 = this.d.d(ConfigProperty.ASSESS_SAMPLING_WINDOW_MS) / 1000;
        } else {
            i2.a = true;
            i2.b = f2.b % 25 == 1;
            return i2;
        }
        long l2 = this.a.a();
        long l3 = (l2 - f2.c) / 1000L;
        String string = httpRequest.getUri();
        if (l3 >= (long)n2) {
            j.debug("Resetting sampling window for {} (was {})", (Object)string, (Object)l3);
            f2.c = l2;
            f2.a = 1;
            bl2 = true;
            bl = true;
        } else if (f2.a <= n5) {
            j.debug("Analyzing baseline sample {} for {}", (Object)f2.a, (Object)string);
            bl2 = f2.a == 1;
            bl = true;
        } else {
            int n6 = f2.a - n5;
            bl2 = n6 % n3 == 0;
            boolean bl3 = bl = n6 % n4 == 0;
            if (bl2) {
                j.debug("Analyzing sampling response {} for {}", (Object)f2.a, (Object)string);
            }
            if (bl) {
                j.debug("Analyzing sampling request {} for {}", (Object)f2.a, (Object)string);
            }
        }
        i2.a = bl;
        i2.b = bl2;
        return i2;
    }

    private f b(HttpRequest httpRequest) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(httpRequest.getMethod().getBytes());
        String string = q.a(httpRequest.getUri());
        cRC32.update(string.getBytes());
        String string2 = httpRequest.getQueryString();
        if (string2 != null) {
            cRC32.update(string2.getBytes());
        }
        int n2 = this.c(httpRequest);
        int n3 = H.a(n2);
        cRC32.update(n3);
        long l2 = cRC32.getValue();
        f f2 = this.e.get(l2);
        if (f2 == null) {
            f2 = new f();
            f2.c = this.a.a();
            f2.b = 0;
            f2.a = 0;
            this.e.put(l2, f2);
        }
        return f2;
    }

    private int c(HttpRequest httpRequest) {
        String string = httpRequest.getHeader("Content-Length");
        int n2 = 0;
        if (!StringUtils.isEmpty(string)) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    static int a(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 <= 10) {
            return 10;
        }
        if (n2 <= 100) {
            return 100;
        }
        if (n2 <= 1000) {
            return 1000;
        }
        if (n2 <= 10000) {
            return 10000;
        }
        if (n2 <= 100000) {
            return 100000;
        }
        return Integer.MAX_VALUE;
    }
}

