/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans;

import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.Beans;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.YamlException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

class DeferredConstruction {
    private final Constructor constructor;
    private final String[] parameterNames;
    private final ParameterValue[] parameterValues;
    private final List<PropertyValue> propertyValues = new ArrayList<PropertyValue>(16);

    public DeferredConstruction(Constructor constructor, String[] stringArray) {
        this.constructor = constructor;
        this.parameterNames = stringArray;
        this.parameterValues = new ParameterValue[stringArray.length];
    }

    public Object construct() throws InvocationTargetException {
        try {
            Object[] objectArray = new Object[this.parameterValues.length];
            int n2 = 0;
            for (ParameterValue parameterValue : this.parameterValues) {
                if (parameterValue == null) {
                    throw new InvocationTargetException(new YamlException("Missing constructor property: " + this.parameterNames[n2]));
                }
                objectArray[n2++] = parameterValue.value;
            }
            Object t2 = this.constructor.newInstance(objectArray);
            for (PropertyValue propertyValue : this.propertyValues) {
                propertyValue.property.set(t2, propertyValue.value);
            }
            return t2;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception, "Error constructing instance of class: " + this.constructor.getDeclaringClass().getName());
        }
    }

    public void storeProperty(Beans.Property property, Object object) {
        int n2 = 0;
        for (String string : this.parameterNames) {
            if (property.getName().equals(string)) {
                ParameterValue parameterValue = new ParameterValue();
                parameterValue.value = object;
                this.parameterValues[n2] = parameterValue;
                return;
            }
            ++n2;
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.property = property;
        propertyValue.value = object;
        this.propertyValues.add(propertyValue);
    }

    public boolean hasParameter(String string) {
        for (String string2 : this.parameterNames) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    static class ParameterValue {
        Object value;

        ParameterValue() {
        }
    }

    static class PropertyValue {
        Beans.Property property;
        Object value;

        PropertyValue() {
        }
    }
}

