/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.emitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

class EmitterWriter {
    private static final Map<Integer, String> ESCAPE_REPLACEMENTS = new HashMap<Integer, String>();
    private final Writer writer;
    private boolean whitespace = true;
    int column = 0;
    boolean indentation = true;

    public EmitterWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeStreamStart() {
    }

    public void writeStreamEnd() throws IOException {
        this.flushStream();
    }

    public void writeIndicator(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string2 = null;
        string2 = this.whitespace || !bl ? string : " " + string;
        this.whitespace = bl2;
        this.indentation = this.indentation && bl3;
        this.column += string2.length();
        this.writer.write(string2);
    }

    public void writeIndent(int n2) throws IOException {
        if (n2 == -1) {
            n2 = 0;
        }
        if (!this.indentation || this.column > n2 || this.column == n2 && !this.whitespace) {
            this.writeLineBreak(null);
        }
        if (this.column < n2) {
            this.whitespace = true;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = n2 - this.column;
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuffer.append(" ");
            }
            this.column = n2;
            this.writer.write(stringBuffer.toString());
        }
    }

    public void writeVersionDirective(String string) throws IOException {
        this.writer.write("%YAML " + string);
        this.writeLineBreak(null);
    }

    public void writeTagDirective(String string, String string2) throws IOException {
        this.writer.write("%TAG " + string + " " + string2);
        this.writeLineBreak(null);
    }

    public void writeDoubleQuoted(String string, boolean bl, int n2, int n3, boolean bl2) throws IOException {
        this.writeIndicator("\"", true, false, false);
        int n4 = 0;
        String string2 = null;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            int n5 = 0;
            if (i2 < string.length()) {
                n5 = string.codePointAt(i2);
            }
            if (n5 == 0 || "\"\\\u0085".indexOf(n5) != -1 || 32 > n5 || n5 > 126) {
                if (n4 < i2) {
                    string2 = string.substring(n4, i2);
                    this.column += string2.length();
                    this.writer.write(string2);
                    n4 = i2;
                }
                if (n5 != 0) {
                    if (ESCAPE_REPLACEMENTS.containsKey(n5)) {
                        string2 = "\\" + ESCAPE_REPLACEMENTS.get(n5);
                    } else if (bl2) {
                        string2 = Integer.toString(n5, 16);
                        if (string2.length() == 1) {
                            string2 = "000" + string2;
                        } else if (string2.length() == 2) {
                            string2 = "00" + string2;
                        } else if (string2.length() == 3) {
                            string2 = "0" + string2;
                        }
                        string2 = "\\u" + string2;
                    } else {
                        string2 = new String(Character.toChars(n5));
                    }
                    this.column += string2.length();
                    this.writer.write(string2);
                    n4 = i2 + 1;
                }
            }
            if (0 >= i2 || i2 >= string.length() - 1 || n5 != 32 && n4 > i2 || this.column + (i2 - n4) <= n3 || !bl) continue;
            string2 = n4 < i2 ? string.substring(n4, i2) + '\\' : "\\";
            if (n4 < i2) {
                n4 = i2;
            }
            this.column += string2.length();
            this.writer.write(string2);
            this.writeIndent(n2);
            this.whitespace = false;
            this.indentation = false;
            if (string.charAt(n4) != ' ') continue;
            string2 = "\\";
            this.column += string2.length();
            this.writer.write(string2);
        }
        this.writeIndicator("\"", false, false, false);
    }

    public void writeSingleQuoted(String string, boolean bl, int n2, int n3) throws IOException {
        this.writeIndicator("'", true, false, false);
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        char c2 = '\u0000';
        String string2 = null;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl2) {
                if (c2 == '\u0000' || c2 != ' ') {
                    if (n4 + 1 == i2 && this.column > n3 && bl && n4 != 0 && i2 != string.length()) {
                        this.writeIndent(n2);
                    } else {
                        string2 = string.substring(n4, i2);
                        this.column += string2.length();
                        this.writer.write(string2);
                    }
                    n4 = i2;
                }
            } else if (bl3) {
                if (c2 == '\u0000' || '\n' != c2 && '\u0085' != c2) {
                    string2 = string.substring(n4, i2);
                    int n5 = string2.length();
                    for (int i3 = 0; i3 < n5; ++i3) {
                        char c3 = string2.charAt(i3);
                        if ('\n' == c3) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c3);
                    }
                    this.writeIndent(n2);
                    n4 = i2;
                }
            } else if ((c2 == '\u0000' || '\n' != c2 && '\u0085' != c2) && n4 < i2) {
                string2 = string.substring(n4, i2);
                this.column += string2.length();
                this.writer.write(string2);
                n4 = i2;
            }
            if (c2 == '\'') {
                string2 = "''";
                this.column += 2;
                this.writer.write(string2);
                n4 = i2 + 1;
            }
            if (c2 == '\u0000') continue;
            bl2 = c2 == ' ';
            bl3 = c2 == '\n' || c2 == '\u0085';
        }
        this.writeIndicator("'", false, false, false);
    }

    public void writeFolded(String string, int n2, int n3) throws IOException {
        String string2 = this.determineChomp(string);
        this.writeIndicator(">" + string2, true, false, false);
        this.writeIndent(n2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        String string3 = null;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl3) {
                if (c2 == '\u0000' || '\n' != c2 && '\u0085' != c2) {
                    if (!bl && c2 != '\u0000' && c2 != ' ' && string.charAt(n4) == '\n') {
                        this.writeLineBreak(null);
                    }
                    bl = c2 == ' ';
                    string3 = string.substring(n4, i2);
                    int n5 = string3.length();
                    for (int i3 = 0; i3 < n5; ++i3) {
                        char c3 = string3.charAt(i3);
                        if ('\n' == c3) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c3);
                    }
                    if (c2 != '\u0000') {
                        this.writeIndent(n2);
                    }
                    n4 = i2;
                }
            } else if (bl2) {
                if (c2 != ' ') {
                    if (n4 + 1 == i2 && this.column > n3) {
                        this.writeIndent(n2);
                    } else {
                        string3 = string.substring(n4, i2);
                        this.column += string3.length();
                        this.writer.write(string3);
                    }
                    n4 = i2;
                }
            } else if (c2 == '\u0000' || ' ' == c2 || '\n' == c2 || '\u0085' == c2) {
                string3 = string.substring(n4, i2);
                this.writer.write(string3);
                if (c2 == '\u0000') {
                    this.writeLineBreak(null);
                }
                n4 = i2;
            }
            if (c2 == '\u0000') continue;
            bl3 = '\n' == c2 || '\u0085' == c2;
            bl2 = c2 == ' ';
        }
    }

    public void writeLiteral(String string, int n2) throws IOException {
        String string2 = this.determineChomp(string);
        this.writeIndicator("|" + string2, true, false, false);
        this.writeIndent(n2);
        boolean bl = false;
        int n3 = 0;
        String string3 = null;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl) {
                if (c2 == '\u0000' || '\n' != c2 && '\u0085' != c2) {
                    string3 = string.substring(n3, i2);
                    int n4 = string3.length();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        char c3 = string3.charAt(i3);
                        if ('\n' == c3) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c3);
                    }
                    if (c2 != '\u0000') {
                        this.writeIndent(n2);
                    }
                    n3 = i2;
                }
            } else if (c2 == '\u0000' || '\n' == c2 || '\u0085' == c2) {
                string3 = string.substring(n3, i2);
                this.writer.write(string3);
                if (c2 == '\u0000') {
                    this.writeLineBreak(null);
                }
                n3 = i2;
            }
            if (c2 == '\u0000') continue;
            bl = '\n' == c2 || '\u0085' == c2;
        }
    }

    public void writePlain(String string, boolean bl, int n2, int n3) throws IOException {
        if (string == null || "".equals(string)) {
            return;
        }
        String string2 = null;
        if (!this.whitespace) {
            string2 = " ";
            this.column += string2.length();
            this.writer.write(string2);
        }
        this.whitespace = false;
        this.indentation = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl2) {
                if (c2 != ' ') {
                    if (n4 + 1 == i2 && this.column > n3 && bl) {
                        this.writeIndent(n2);
                        this.whitespace = false;
                        this.indentation = false;
                    } else {
                        string2 = string.substring(n4, i2);
                        this.column += string2.length();
                        this.writer.write(string2);
                    }
                    n4 = i2;
                }
            } else if (bl3) {
                if (c2 != '\n' && c2 != '\u0085') {
                    if (string.charAt(n4) == '\n') {
                        this.writeLineBreak(null);
                    }
                    string2 = string.substring(n4, i2);
                    int n5 = string2.length();
                    for (int i3 = 0; i3 < n5; ++i3) {
                        char c3 = string2.charAt(i3);
                        if ('\n' == c3) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c3);
                    }
                    this.writeIndent(n2);
                    this.whitespace = false;
                    this.indentation = false;
                    n4 = i2;
                }
            } else if (c2 == '\u0000' || ' ' == c2 || '\n' == c2 || '\u0085' == c2) {
                string2 = string.substring(n4, i2);
                this.column += string2.length();
                this.writer.write(string2);
                n4 = i2;
            }
            if (c2 == '\u0000') continue;
            bl2 = c2 == ' ';
            bl3 = c2 == '\n' || c2 == '\u0085';
        }
    }

    public void writeLineBreak(String string) throws IOException {
        if (string == null) {
            string = System.getProperty("line.separator");
        }
        this.whitespace = true;
        this.indentation = true;
        this.column = 0;
        this.writer.write(string);
    }

    public void flushStream() throws IOException {
        this.writer.flush();
    }

    private String determineChomp(String string) {
        String string2 = string.substring(string.length() - 2, string.length() - 1);
        while (string2.length() < 2) {
            string2 = " " + string2;
        }
        char c2 = string2.charAt(string2.length() - 1);
        char c3 = string2.charAt(string2.length() - 2);
        return c2 == '\n' || c2 == '\u0085' ? (c3 == '\n' || c3 == '\u0085' ? "+" : "") : "-";
    }

    public void close() throws IOException {
        this.writer.close();
    }

    static {
        ESCAPE_REPLACEMENTS.put(0, "0");
        ESCAPE_REPLACEMENTS.put(7, "a");
        ESCAPE_REPLACEMENTS.put(8, "b");
        ESCAPE_REPLACEMENTS.put(9, "t");
        ESCAPE_REPLACEMENTS.put(10, "n");
        ESCAPE_REPLACEMENTS.put(11, "v");
        ESCAPE_REPLACEMENTS.put(12, "f");
        ESCAPE_REPLACEMENTS.put(13, "r");
        ESCAPE_REPLACEMENTS.put(27, "e");
        ESCAPE_REPLACEMENTS.put(34, "\"");
        ESCAPE_REPLACEMENTS.put(92, "\\");
        ESCAPE_REPLACEMENTS.put(133, "N");
        ESCAPE_REPLACEMENTS.put(160, "_");
    }
}

