/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer;

import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.AliasToken;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.AnchorToken;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.DirectiveToken;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.ScalarToken;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.TagToken;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.Token;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.TokenType;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    private static final String LINEBR = "\n\u0085\u2028\u2029";
    private static final String NULL_BL_LINEBR = "\u0000 \r\n\u0085";
    private static final String NULL_BL_T_LINEBR = "\u0000 \t\r\n\u0085";
    private static final String NULL_OR_OTHER = "\u0000 \t\r\n\u0085";
    private static final String NULL_OR_LINEBR = "\u0000\r\n\u0085";
    private static final String FULL_LINEBR = "\r\n\u0085";
    private static final String BLANK_OR_LINEBR = " \r\n\u0085";
    private static final String S4 = "\u0000 \t\r\n([]{}";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    private static final String STRANGE_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789][-';/?:@&=+$,.!~*()%";
    private static final String RN = "\r\n";
    private static final String BLANK_T = " \t";
    private static final String SPACES_AND_STUFF = "'\"\\\u0000 \t\r\n\u0085";
    private static final String DOUBLE_ESC = "\"\\";
    private static final String NON_ALPHA_OR_NUM = "\u0000 \t\r\n\u0085?:,]}%@`";
    private static final Pattern NON_PRINTABLE = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\u00ff]");
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    private static final Pattern NON_ALPHA = Pattern.compile("[^-0-9A-Za-z_]");
    private static final Pattern R_FLOWZERO = Pattern.compile("[\u0000 \t\r\n\u0085]|(:[\u0000 \t\r\n(])");
    private static final Pattern R_FLOWNONZERO = Pattern.compile("[\u0000 \t\r\n\u0085\\[\\]{},:?]");
    private static final Pattern END_OR_START = Pattern.compile("^(---|\\.\\.\\.)[\u0000 \t\r\n\u0085]$");
    private static final Pattern ENDING = Pattern.compile("^---[\u0000 \t\r\n\u0085]$");
    private static final Pattern START = Pattern.compile("^\\.\\.\\.[\u0000 \t\r\n\u0085]$");
    private static final Pattern BEG = Pattern.compile("^([^\u0000 \t\r\n\u0085\\-?:,\\[\\]{}#&*!|>'\"%@]|([\\-?:][^\u0000 \t\r\n\u0085]))");
    private static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    private static final Map<Character, Integer> ESCAPE_CODES = new HashMap<Character, Integer>();
    private boolean done = false;
    private int flowLevel = 0;
    private int tokensTaken = 0;
    private int indent = -1;
    private boolean allowSimpleKey = true;
    private boolean eof;
    private int lineNumber = 0;
    private int column = 0;
    private int pointer = 0;
    private final StringBuilder buffer;
    private final Reader reader;
    private final List<Token> tokens = new LinkedList<Token>();
    private final List<Integer> indents = new LinkedList<Integer>();
    private final Map<Integer, SimpleKey> possibleSimpleKeys = new HashMap<Integer, SimpleKey>();
    private boolean docStart = false;

    public Tokenizer(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null.");
        }
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
        this.buffer = new StringBuilder();
        this.eof = false;
        this.fetchStreamStart();
    }

    public Tokenizer(String string) {
        this(new StringReader(string));
    }

    public Token peekNextToken() throws TokenizerException {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.isEmpty() ? null : this.tokens.get(0);
    }

    public TokenType peekNextTokenType() throws TokenizerException {
        Token token = this.peekNextToken();
        if (token == null) {
            return null;
        }
        return token.type;
    }

    public Token getNextToken() throws TokenizerException {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            Token token = this.tokens.remove(0);
            return token;
        }
        return null;
    }

    public Iterator iterator() {
        return new Iterator(){

            public boolean hasNext() {
                return null != Tokenizer.this.peekNextToken();
            }

            public Object next() {
                return Tokenizer.this.getNextToken();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private char peek() {
        if (this.pointer + 1 > this.buffer.length()) {
            this.update(1);
        }
        return this.buffer.charAt(this.pointer);
    }

    private char peek(int n2) {
        if (this.pointer + n2 + 1 > this.buffer.length()) {
            this.update(n2 + 1);
        }
        return this.buffer.charAt(this.pointer + n2);
    }

    private String prefix(int n2) {
        if (this.pointer + n2 >= this.buffer.length()) {
            this.update(n2);
        }
        if (this.pointer + n2 > this.buffer.length()) {
            return this.buffer.substring(this.pointer, this.buffer.length());
        }
        return this.buffer.substring(this.pointer, this.pointer + n2);
    }

    private String prefixForward(int n2) {
        if (this.pointer + n2 + 1 >= this.buffer.length()) {
            this.update(n2 + 1);
        }
        String string = null;
        string = this.pointer + n2 > this.buffer.length() ? this.buffer.substring(this.pointer, this.buffer.length()) : this.buffer.substring(this.pointer, this.pointer + n2);
        char c2 = '\u0000';
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            c2 = string.charAt(i2);
            ++this.pointer;
            if (LINEBR.indexOf(c2) != -1 || c2 == '\r' && string.charAt(i2 + 1) != '\n') {
                this.column = 0;
                ++this.lineNumber;
                continue;
            }
            if (c2 == '\ufeff') continue;
            ++this.column;
        }
        return string;
    }

    private void forward() {
        if (this.pointer + 2 >= this.buffer.length()) {
            this.update(2);
        }
        char c2 = this.buffer.charAt(this.pointer);
        ++this.pointer;
        if (c2 == '\n' || c2 == '\u0085' || c2 == '\r' && this.buffer.charAt(this.pointer) != '\n') {
            this.column = 0;
            ++this.lineNumber;
        } else {
            ++this.column;
        }
    }

    private void forward(int n2) {
        if (this.pointer + n2 + 1 >= this.buffer.length()) {
            this.update(n2 + 1);
        }
        char c2 = '\u0000';
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = this.buffer.charAt(this.pointer);
            ++this.pointer;
            if (LINEBR.indexOf(c2) != -1 || c2 == '\r' && this.buffer.charAt(this.pointer) != '\n') {
                this.column = 0;
                ++this.lineNumber;
                continue;
            }
            if (c2 == '\ufeff') continue;
            ++this.column;
        }
    }

    private void update(int n2) {
        this.buffer.delete(0, this.pointer);
        this.pointer = 0;
        while (this.buffer.length() < n2) {
            String string = "";
            if (!this.eof) {
                char[] cArray = new char[1024];
                int n3 = -2;
                try {
                    n3 = this.reader.read(cArray);
                }
                catch (IOException iOException) {
                    throw new TokenizerException("Error reading from stream.", iOException);
                }
                if (n3 == -1) {
                    this.eof = true;
                } else {
                    string = String.valueOf(cArray, 0, n3);
                }
            }
            this.buffer.append(string);
            if (!this.eof) continue;
            this.buffer.append('\u0000');
            break;
        }
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        return this.tokens.isEmpty() || this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private Token fetchMoreTokens() {
        this.scanToNextToken();
        this.unwindIndent(this.column);
        char c2 = this.peek();
        boolean bl = this.column == 0;
        switch (c2) {
            case '\u0000': {
                return this.fetchStreamEnd();
            }
            case '\'': {
                return this.fetchSingle();
            }
            case '\"': {
                return this.fetchDouble();
            }
            case '?': {
                if (this.flowLevel == 0 && "\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchKey();
            }
            case ':': {
                if (this.flowLevel == 0 && "\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchValue();
            }
            case '%': {
                if (!bl) break;
                return this.fetchDirective();
            }
            case '-': {
                if ((bl || this.docStart) && ENDING.matcher(this.prefix(4)).matches()) {
                    return this.fetchDocumentStart();
                }
                if ("\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchBlockEntry();
            }
            case '.': {
                if (!bl || !START.matcher(this.prefix(4)).matches()) break;
                return this.fetchDocumentEnd();
            }
            case '[': {
                return this.fetchFlowSequenceStart();
            }
            case '{': {
                return this.fetchFlowMappingStart();
            }
            case ']': {
                return this.fetchFlowSequenceEnd();
            }
            case '}': {
                return this.fetchFlowMappingEnd();
            }
            case ',': {
                return this.fetchFlowEntry();
            }
            case '*': {
                return this.fetchAlias();
            }
            case '&': {
                return this.fetchAnchor();
            }
            case '!': {
                return this.fetchTag();
            }
            case '|': {
                if (this.flowLevel != 0) break;
                return this.fetchLiteral();
            }
            case '>': {
                if (this.flowLevel != 0) break;
                return this.fetchFolded();
            }
        }
        if (BEG.matcher(this.prefix(2)).find()) {
            return this.fetchPlain();
        }
        if (c2 == '\t') {
            throw new TokenizerException("Tabs cannot be used for indentation.");
        }
        throw new TokenizerException("While scanning for the next token, a character that cannot begin a token was found: " + this.ch(c2));
    }

    private int nextPossibleSimpleKey() {
        for (SimpleKey simpleKey : this.possibleSimpleKeys.values()) {
            if (simpleKey.tokenNumber <= 0) continue;
            return simpleKey.tokenNumber;
        }
        return -1;
    }

    private void savePossibleSimpleKey() {
        if (this.allowSimpleKey) {
            this.possibleSimpleKeys.put(this.flowLevel, new SimpleKey(this.tokensTaken + this.tokens.size(), this.column));
        }
    }

    private void unwindIndent(int n2) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > n2) {
            this.indent = this.indents.remove(0);
            this.tokens.add(Token.BLOCK_END);
        }
    }

    private boolean addIndent(int n2) {
        if (this.indent < n2) {
            this.indents.add(0, this.indent);
            this.indent = n2;
            return true;
        }
        return false;
    }

    private Token fetchStreamStart() {
        this.docStart = true;
        this.tokens.add(Token.STREAM_START);
        return Token.STREAM_START;
    }

    private Token fetchStreamEnd() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        this.tokens.add(Token.STREAM_END);
        this.done = true;
        return Token.STREAM_END;
    }

    private Token fetchDirective() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        Token token = this.scanDirective();
        this.tokens.add(token);
        return token;
    }

    private Token fetchDocumentStart() {
        this.docStart = false;
        return this.fetchDocumentIndicator(Token.DOCUMENT_START);
    }

    private Token fetchDocumentEnd() {
        return this.fetchDocumentIndicator(Token.DOCUMENT_END);
    }

    private Token fetchDocumentIndicator(Token token) {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.forward(3);
        this.tokens.add(token);
        return token;
    }

    private Token fetchFlowSequenceStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_SEQUENCE_START);
    }

    private Token fetchFlowMappingStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_MAPPING_START);
    }

    private Token fetchFlowCollectionStart(Token token) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        this.forward(1);
        this.tokens.add(token);
        return token;
    }

    private Token fetchFlowSequenceEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_SEQUENCE_END);
    }

    private Token fetchFlowMappingEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_MAPPING_END);
    }

    private Token fetchFlowCollectionEnd(Token token) {
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.forward(1);
        this.tokens.add(token);
        return token;
    }

    private Token fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.forward(1);
        this.tokens.add(Token.FLOW_ENTRY);
        return Token.FLOW_ENTRY;
    }

    private Token fetchBlockEntry() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new TokenizerException("Found a sequence entry where it is not allowed.");
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_SEQUENCE_START);
            }
        }
        this.allowSimpleKey = true;
        this.forward();
        this.tokens.add(Token.BLOCK_ENTRY);
        return Token.BLOCK_ENTRY;
    }

    private Token fetchKey() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new TokenizerException("Found a mapping key where it is not allowed.");
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_MAPPING_START);
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.forward();
        this.tokens.add(Token.KEY);
        return Token.KEY;
    }

    private Token fetchValue() {
        SimpleKey simpleKey = this.possibleSimpleKeys.get(this.flowLevel);
        if (null == simpleKey) {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                throw new TokenizerException("Found a mapping value where it is not allowed.");
            }
        } else {
            this.possibleSimpleKeys.remove(this.flowLevel);
            this.tokens.add(simpleKey.tokenNumber - this.tokensTaken, Token.KEY);
            if (this.flowLevel == 0 && this.addIndent(simpleKey.column)) {
                this.tokens.add(simpleKey.tokenNumber - this.tokensTaken, Token.BLOCK_MAPPING_START);
            }
            this.allowSimpleKey = false;
        }
        this.forward();
        this.tokens.add(Token.VALUE);
        return Token.VALUE;
    }

    private Token fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(new AliasToken());
        this.tokens.add(token);
        return token;
    }

    private Token fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(new AnchorToken());
        this.tokens.add(token);
        return token;
    }

    private Token fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.tokens.add(token);
        return token;
    }

    private Token fetchLiteral() {
        return this.fetchBlockScalar('|');
    }

    private Token fetchFolded() {
        return this.fetchBlockScalar('>');
    }

    private Token fetchBlockScalar(char c2) {
        this.allowSimpleKey = true;
        Token token = this.scanBlockScalar(c2);
        this.tokens.add(token);
        return token;
    }

    private Token fetchSingle() {
        return this.fetchFlowScalar('\'');
    }

    private Token fetchDouble() {
        return this.fetchFlowScalar('\"');
    }

    private Token fetchFlowScalar(char c2) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanFlowScalar(c2);
        this.tokens.add(token);
        return token;
    }

    private Token fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanPlain();
        this.tokens.add(token);
        return token;
    }

    private void scanToNextToken() {
        while (true) {
            if (this.peek() == ' ') {
                this.forward();
                continue;
            }
            if (this.peek() == '#') {
                while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                    this.forward();
                }
            }
            if (this.scanLineBreak().length() == 0) break;
            if (this.flowLevel != 0) continue;
            this.allowSimpleKey = true;
        }
    }

    private Token scanDirective() {
        this.forward();
        String string = this.scanDirectiveName();
        String string2 = null;
        if (string.equals("YAML")) {
            string2 = this.scanYamlDirectiveValue();
        } else if (string.equals("TAG")) {
            string2 = this.scanTagDirectiveValue();
        } else {
            char c2;
            StringBuilder stringBuilder = new StringBuilder();
            while (NULL_OR_LINEBR.indexOf(c2 = this.peek()) == -1) {
                stringBuilder.append(c2);
                this.forward();
            }
            string2 = stringBuilder.toString().trim();
        }
        this.scanDirectiveIgnoredLine();
        return new DirectiveToken(string, string2);
    }

    private String scanDirectiveName() {
        int n2 = 0;
        char c2 = this.peek(n2);
        boolean bl = true;
        while (ALPHA.indexOf(c2) != -1) {
            bl = false;
            c2 = this.peek(++n2);
        }
        if (bl) {
            throw new TokenizerException("While scanning for a directive name, expected an alpha or numeric character but found: " + this.ch(c2));
        }
        String string = this.prefixForward(n2);
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning for a directive name, expected an alpha or numeric character but found: " + this.ch(c2));
        }
        return string;
    }

    private String scanYamlDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String string = this.scanYamlDirectiveNumber();
        if (this.peek() != '.') {
            throw new TokenizerException("While scanning for a directive value, expected a digit or '.' but found: " + this.ch(this.peek()));
        }
        this.forward();
        String string2 = this.scanYamlDirectiveNumber();
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning for a directive value, expected a digit or '.' but found: " + this.ch(this.peek()));
        }
        return string + "." + string2;
    }

    private String scanYamlDirectiveNumber() {
        char c2 = this.peek();
        if (!Character.isDigit(c2)) {
            throw new TokenizerException("While scanning for a directive number, expected a digit but found: " + this.ch(c2));
        }
        int n2 = 0;
        while (Character.isDigit(this.peek(n2))) {
            ++n2;
        }
        String string = this.prefixForward(n2);
        return string;
    }

    private String scanTagDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String string = this.scanTagDirectiveHandle();
        while (this.peek() == ' ') {
            this.forward();
        }
        String string2 = this.scanTagDirectivePrefix();
        return string + " " + string2;
    }

    private String scanTagDirectiveHandle() {
        String string = this.scanTagHandle("directive");
        if (this.peek() != ' ') {
            throw new TokenizerException("While scanning for a directive tag handle, expected ' ' but found: " + this.ch(this.peek()));
        }
        return string;
    }

    private String scanTagDirectivePrefix() {
        String string = this.scanTagUri("directive");
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning for a directive tag prefix, expected ' ' but found: " + this.ch(this.peek()));
        }
        return string;
    }

    private String scanDirectiveIgnoredLine() {
        char c2;
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '\"') {
            while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                this.forward();
            }
        }
        if (NULL_OR_LINEBR.indexOf(c2 = this.peek()) == -1) {
            throw new TokenizerException("While scanning a directive, expected a comment or line break but found: " + this.ch(this.peek()));
        }
        return this.scanLineBreak();
    }

    private Token scanAnchor(Token token) {
        String string;
        char c2 = this.peek();
        String string2 = c2 == '*' ? "alias" : "anchor";
        this.forward();
        int n2 = 0;
        int n3 = 16;
        Matcher matcher = null;
        while (!(matcher = NON_ALPHA.matcher(string = this.prefix(n3))).find()) {
            n3 += 16;
        }
        n2 = matcher.start();
        if (n2 == 0) {
            throw new TokenizerException("While scanning an " + string2 + ", a non-alpha, non-numeric character was found.");
        }
        string = this.prefixForward(n2);
        if (NON_ALPHA_OR_NUM.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning an " + string2 + ", expected an alpha or numeric character but found: " + this.ch(this.peek()));
        }
        if (token instanceof AnchorToken) {
            ((AnchorToken)token).setInstanceName(string);
        } else {
            ((AliasToken)token).setInstanceName(string);
        }
        return token;
    }

    private Token scanTag() {
        char c2 = this.peek(1);
        String string = null;
        String string2 = null;
        if (c2 == '<') {
            this.forward(2);
            string2 = this.scanTagUri("tag");
            if (this.peek() != '>') {
                throw new TokenizerException("While scanning a tag, expected '>' but found: " + this.ch(this.peek()));
            }
            this.forward();
        } else if ("\u0000 \t\r\n\u0085".indexOf(c2) != -1) {
            string2 = "!";
            this.forward();
        } else {
            int n2 = 1;
            boolean bl = false;
            while ("\u0000 \t\r\n\u0085".indexOf(c2) == -1) {
                if (c2 == '!') {
                    bl = true;
                    break;
                }
                c2 = this.peek(++n2);
            }
            string = "!";
            if (bl) {
                string = this.scanTagHandle("tag");
            } else {
                string = "!";
                this.forward();
            }
            string2 = this.scanTagUri("tag");
        }
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning a tag, expected ' ' but found: " + this.ch(this.peek()));
        }
        return new TagToken(string, string2);
    }

    private Token scanBlockScalar(char c2) {
        Object object;
        boolean bl = c2 == '>';
        StringBuilder stringBuilder = new StringBuilder();
        this.forward();
        Object[] objectArray = this.scanBlockScalarIndicators();
        boolean bl2 = (Boolean)objectArray[0];
        int n2 = (Integer)objectArray[1];
        this.scanBlockScalarIgnoredLine();
        int n3 = this.indent + 1;
        if (n3 < 1) {
            n3 = 1;
        }
        String string = null;
        int n4 = 0;
        int n5 = 0;
        if (n2 == -1) {
            object = this.scanBlockScalarIndentation();
            string = (String)object[0];
            n4 = (Integer)object[1];
            n5 = n3 > n4 ? n3 : n4;
        } else {
            n5 = n3 + n2 - 1;
            string = this.scanBlockScalarBreaks(n5);
        }
        object = "";
        while (this.column == n5 && this.peek() != '\u0000') {
            stringBuilder.append(string);
            boolean bl3 = BLANK_T.indexOf(this.peek()) == -1;
            int n6 = 0;
            while (NULL_OR_LINEBR.indexOf(this.peek(n6)) == -1) {
                ++n6;
            }
            stringBuilder.append(this.prefixForward(n6));
            object = this.scanLineBreak();
            string = this.scanBlockScalarBreaks(n5);
            if (this.column != n5 || this.peek() == '\u0000') break;
            if (bl && ((String)object).equals("\n") && bl3 && BLANK_T.indexOf(this.peek()) == -1) {
                if (string.length() != 0) continue;
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append((String)object);
        }
        if (bl2) {
            stringBuilder.append((String)object);
            stringBuilder.append(string);
        }
        return new ScalarToken(stringBuilder.toString(), false, c2);
    }

    private Object[] scanBlockScalarIndicators() {
        boolean bl = false;
        int n2 = -1;
        char c2 = this.peek();
        if (c2 == '-' || c2 == '+') {
            bl = c2 == '+';
            this.forward();
            c2 = this.peek();
            if (Character.isDigit(c2)) {
                n2 = Integer.parseInt("" + c2);
                if (n2 == 0) {
                    throw new TokenizerException("While scanning a black scaler, expected indentation indicator between 1 and 9 but found: 0");
                }
                this.forward();
            }
        } else if (Character.isDigit(c2)) {
            n2 = Integer.parseInt("" + c2);
            if (n2 == 0) {
                throw new TokenizerException("While scanning a black scaler, expected indentation indicator between 1 and 9 but found: 0");
            }
            this.forward();
            c2 = this.peek();
            if (c2 == '-' || c2 == '+') {
                bl = c2 == '+';
                this.forward();
            }
        }
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning a block scalar, expected chomping or indentation indicators but found: " + this.ch(this.peek()));
        }
        return new Object[]{bl, n2};
    }

    private String scanBlockScalarIgnoredLine() {
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '#') {
            while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                this.forward();
            }
        }
        if (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
            throw new TokenizerException("While scanning a block scalar, expected a comment or line break but found: " + this.ch(this.peek()));
        }
        return this.scanLineBreak();
    }

    private Object[] scanBlockScalarIndentation() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (BLANK_OR_LINEBR.indexOf(this.peek()) != -1) {
            if (this.peek() != ' ') {
                stringBuilder.append(this.scanLineBreak());
                continue;
            }
            this.forward();
            if (this.column <= n2) continue;
            n2 = this.column;
        }
        return new Object[]{stringBuilder.toString(), n2};
    }

    private String scanBlockScalarBreaks(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.column < n2 && this.peek() == ' ') {
            this.forward();
        }
        while (FULL_LINEBR.indexOf(this.peek()) != -1) {
            stringBuilder.append(this.scanLineBreak());
            while (this.column < n2 && this.peek() == ' ') {
                this.forward();
            }
        }
        return stringBuilder.toString();
    }

    private Token scanFlowScalar(char c2) {
        boolean bl = c2 == '\"';
        StringBuilder stringBuilder = new StringBuilder();
        char c3 = this.peek();
        this.forward();
        stringBuilder.append(this.scanFlowScalarNonSpaces(bl));
        while (this.peek() != c3) {
            stringBuilder.append(this.scanFlowScalarSpaces());
            stringBuilder.append(this.scanFlowScalarNonSpaces(bl));
        }
        this.forward();
        return new ScalarToken(stringBuilder.toString(), false, c2);
    }

    private String scanFlowScalarNonSpaces(boolean bl) {
        StringBuilder stringBuilder;
        block8: {
            char c2;
            stringBuilder = new StringBuilder();
            while (true) {
                int n2 = 0;
                while (SPACES_AND_STUFF.indexOf(this.peek(n2)) == -1) {
                    ++n2;
                }
                if (n2 != 0) {
                    stringBuilder.append(this.prefixForward(n2));
                }
                c2 = this.peek();
                if (!bl && c2 == '\'' && this.peek(1) == '\'') {
                    stringBuilder.append("'");
                    this.forward(2);
                    continue;
                }
                if (bl && c2 == '\'' || !bl && DOUBLE_ESC.indexOf(c2) != -1) {
                    stringBuilder.append(c2);
                    this.forward();
                    continue;
                }
                if (!bl || c2 != '\\') break block8;
                this.forward();
                c2 = this.peek();
                if (ESCAPE_REPLACEMENTS.containsKey(Character.valueOf(c2))) {
                    stringBuilder.append(ESCAPE_REPLACEMENTS.get(Character.valueOf(c2)));
                    this.forward();
                    continue;
                }
                if (ESCAPE_CODES.containsKey(Character.valueOf(c2))) {
                    n2 = ESCAPE_CODES.get(Character.valueOf(c2));
                    this.forward();
                    String string = this.prefix(n2);
                    if (NOT_HEXA.matcher(string).find()) {
                        throw new TokenizerException("While scanning a double quoted scalar, expected an escape sequence of " + n2 + " hexadecimal numbers but found: " + this.ch(this.peek()));
                    }
                    stringBuilder.append(Character.toChars(Integer.parseInt(string, 16)));
                    this.forward(n2);
                    continue;
                }
                if (FULL_LINEBR.indexOf(c2) == -1) break;
                this.scanLineBreak();
                stringBuilder.append(this.scanFlowScalarBreaks());
            }
            throw new TokenizerException("While scanning a double quoted scalar, found unknown escape character: " + this.ch(c2));
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarSpaces() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (BLANK_T.indexOf(this.peek(n2)) != -1) {
            ++n2;
        }
        String string = this.prefixForward(n2);
        char c2 = this.peek();
        if (c2 == '\u0000') {
            throw new TokenizerException("While scanning a quoted scalar, found unexpected end of stream.");
        }
        if (FULL_LINEBR.indexOf(c2) != -1) {
            String string2 = this.scanLineBreak();
            String string3 = this.scanFlowScalarBreaks();
            if (!string2.equals("\n")) {
                stringBuilder.append(string2);
            } else if (string3.length() == 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string3);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarBreaks() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        while (true) {
            if (((string = this.prefix(3)).equals("---") || string.equals("...")) && "\u0000 \t\r\n\u0085".indexOf(this.peek(3)) != -1) {
                throw new TokenizerException("While scanning a quoted scalar, found unexpected document separator.");
            }
            while (BLANK_T.indexOf(this.peek()) != -1) {
                this.forward();
            }
            if (FULL_LINEBR.indexOf(this.peek()) == -1) break;
            stringBuilder.append(this.scanLineBreak());
        }
        return stringBuilder.toString();
    }

    private Token scanPlain() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.indent + 1;
        String string = "";
        boolean bl = true;
        Pattern pattern = R_FLOWNONZERO;
        if (this.flowLevel == 0) {
            bl = false;
            pattern = R_FLOWZERO;
        }
        while (this.peek() != '#') {
            int n3 = 0;
            int n4 = 32;
            Matcher matcher = null;
            while (!(matcher = pattern.matcher(this.prefix(n4))).find()) {
                n4 += 32;
            }
            n3 = matcher.start();
            char c2 = this.peek(n3);
            if (bl && c2 == ':' && S4.indexOf(this.peek(n3 + 1)) == -1) {
                this.forward(n3);
                throw new TokenizerException("While scanning a plain scalar, found unexpected ':'. See: http://pyyaml.org/wiki/YAMLColonInFlowContext");
            }
            if (n3 == 0) break;
            this.allowSimpleKey = false;
            stringBuilder.append(string);
            stringBuilder.append(this.prefixForward(n3));
            string = this.scanPlainSpaces();
            if (string != null && (this.flowLevel != 0 || this.column >= n2)) continue;
            break;
        }
        return new ScalarToken(stringBuilder.toString(), true);
    }

    private String scanPlainSpaces() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (this.peek(n2) == ' ') {
            ++n2;
        }
        String string = this.prefixForward(n2);
        char c2 = this.peek();
        if (FULL_LINEBR.indexOf(c2) != -1) {
            String string2 = this.scanLineBreak();
            this.allowSimpleKey = true;
            if (END_OR_START.matcher(this.prefix(4)).matches()) {
                return "";
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            while (BLANK_OR_LINEBR.indexOf(this.peek()) != -1) {
                if (' ' == this.peek()) {
                    this.forward();
                    continue;
                }
                stringBuilder2.append(this.scanLineBreak());
                if (!END_OR_START.matcher(this.prefix(4)).matches()) continue;
                return "";
            }
            if (!string2.equals("\n")) {
                stringBuilder.append(string2);
            } else if (stringBuilder2.length() == 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append((CharSequence)stringBuilder2);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String scanTagHandle(String string) {
        char c2 = this.peek();
        if (c2 != '!') {
            throw new TokenizerException("While scanning a " + string + ", expected '!' but found: " + this.ch(c2));
        }
        int n2 = 1;
        c2 = this.peek(n2);
        if (c2 != ' ') {
            while (ALPHA.indexOf(c2) != -1) {
                c2 = this.peek(++n2);
            }
            if ('!' != c2) {
                this.forward(n2);
                throw new TokenizerException("While scanning a " + string + ", expected '!' but found: " + this.ch(c2));
            }
            ++n2;
        }
        String string2 = this.prefixForward(n2);
        return string2;
    }

    private String scanTagUri(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        char c2 = this.peek(n2);
        while (STRANGE_CHAR.indexOf(c2) != -1) {
            if ('%' == c2) {
                stringBuilder.append(this.prefixForward(n2));
                n2 = 0;
                stringBuilder.append(this.scanUriEscapes(string));
            } else {
                ++n2;
            }
            c2 = this.peek(n2);
        }
        if (n2 != 0) {
            stringBuilder.append(this.prefixForward(n2));
        }
        if (stringBuilder.length() == 0) {
            throw new TokenizerException("While scanning a " + string + ", expected a URI but found: " + this.ch(c2));
        }
        return stringBuilder.toString();
    }

    private String scanUriEscapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.peek() == '%') {
            this.forward();
            try {
                stringBuilder.append(Integer.parseInt(this.prefix(2), 16));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TokenizerException("While scanning a " + string + ", expected a URI escape sequence of 2 hexadecimal numbers but found: " + this.ch(this.peek(1)) + " and " + this.ch(this.peek(2)));
            }
            this.forward(2);
        }
        return stringBuilder.toString();
    }

    private String scanLineBreak() {
        char c2 = this.peek();
        if (FULL_LINEBR.indexOf(c2) != -1) {
            if (RN.equals(this.prefix(2))) {
                this.forward(2);
            } else {
                this.forward();
            }
            return "\n";
        }
        return "";
    }

    private String ch(char c2) {
        return "'" + c2 + "' (" + c2 + ")";
    }

    public static void main(String[] stringArray) throws Exception {
        Iterator iterator = new Tokenizer(new FileReader("test/test.yml")).iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('0'), "\u0000");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('a'), "\u0007");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('b'), "\b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('t'), "\t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\t'), "\t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('n'), "\n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('v'), "\u000b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('f'), "\f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('r'), "\r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('e'), "\u001b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf(' '), " ");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('N'), "\u0085");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('_'), "\u00a0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('L'), "\u2028");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('P'), "\u2029");
        ESCAPE_CODES.put(Character.valueOf('x'), 2);
        ESCAPE_CODES.put(Character.valueOf('u'), 4);
        ESCAPE_CODES.put(Character.valueOf('U'), 8);
    }

    static class SimpleKey {
        public final int tokenNumber;
        public final int column;

        public SimpleKey(int n2, int n3) {
            this.tokenNumber = n2;
            this.column = n3;
        }
    }

    public class TokenizerException
    extends RuntimeException {
        public TokenizerException(String string, Throwable throwable) {
            super("Line " + Tokenizer.this.getLineNumber() + ", column " + Tokenizer.this.getColumn() + ": " + string, throwable);
        }

        public TokenizerException(String string) {
            this(string, null);
        }
    }
}

