/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.gson.internal.sql;

import com.contrastsecurity.thirdparty.com.google.gson.Gson;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.com.google.gson.TypeAdapter;
import com.contrastsecurity.thirdparty.com.google.gson.TypeAdapterFactory;
import com.contrastsecurity.thirdparty.com.google.gson.reflect.TypeToken;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonReader;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonToken;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    @Override
    public synchronized Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        try {
            long l2 = this.format.parse(jsonReader.nextString()).getTime();
            return new Date(l2);
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException(parseException);
        }
    }

    @Override
    public synchronized void write(JsonWriter jsonWriter, Date date) throws IOException {
        jsonWriter.value(date == null ? null : this.format.format(date));
    }
}

