/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Address;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.AddressResolver;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Connection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionFactoryConfigurator;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionPostProcessor;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionPostProcessors;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.DefaultSaslConfig;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.DnsRecordIpAddressResolver;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ExceptionHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ListAddressResolver;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.NoOpMetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.RecoveryDelayHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.SaslConfig;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.SocketConfigurator;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.SocketConfigurators;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.TrafficListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.TrustEverythingTrustManager;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConnectionParams;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.CredentialsProvider;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.DefaultCredentialsProvider;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.DefaultExceptionHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ErrorOnWriteListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandlerFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.SocketFrameHandlerFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioParams;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RetryHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.TopologyRecoveryFilter;
import com.contrastsecurity.thirdparty.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ConnectionFactory
implements Cloneable {
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_PASS = "guest";
    public static final String DEFAULT_VHOST = "/";
    public static final int DEFAULT_CHANNEL_MAX = 2047;
    public static final int DEFAULT_FRAME_MAX = 0;
    public static final int DEFAULT_HEARTBEAT = 60;
    public static final String DEFAULT_HOST = "localhost";
    public static final int USE_DEFAULT_PORT = -1;
    public static final int DEFAULT_AMQP_PORT = 5672;
    public static final int DEFAULT_AMQP_OVER_SSL_PORT = 5671;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_HANDSHAKE_TIMEOUT = 10000;
    public static final int DEFAULT_SHUTDOWN_TIMEOUT = 10000;
    public static final int DEFAULT_CHANNEL_RPC_TIMEOUT = (int)TimeUnit.MINUTES.toMillis(10L);
    public static final long DEFAULT_NETWORK_RECOVERY_INTERVAL = 5000L;
    public static final int DEFAULT_WORK_POOL_TIMEOUT = -1;
    private static final String PREFERRED_TLS_PROTOCOL = "TLSv1.2";
    private static final String FALLBACK_TLS_PROTOCOL = "TLSv1";
    private String virtualHost = "/";
    private String host = "localhost";
    private int port = -1;
    private int requestedChannelMax = 2047;
    private int requestedFrameMax = 0;
    private int requestedHeartbeat = 60;
    private int connectionTimeout = 60000;
    private int handshakeTimeout = 10000;
    private int shutdownTimeout = 10000;
    private Map<String, Object> _clientProperties = AMQConnection.defaultClientProperties();
    private SocketFactory factory = SocketFactory.getDefault();
    private SaslConfig saslConfig = DefaultSaslConfig.PLAIN;
    private ExecutorService sharedExecutor;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private ExecutorService shutdownExecutor;
    private ScheduledExecutorService heartbeatExecutor;
    private SocketConfigurator socketConf = SocketConfigurators.defaultConfigurator();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private CredentialsProvider credentialsProvider = new DefaultCredentialsProvider("guest", "guest");
    private boolean automaticRecovery = true;
    private boolean topologyRecovery = true;
    private ExecutorService topologyRecoveryExecutor;
    private long networkRecoveryInterval = 5000L;
    private RecoveryDelayHandler recoveryDelayHandler;
    private MetricsCollector metricsCollector;
    private boolean nio = false;
    private FrameHandlerFactory frameHandlerFactory;
    private NioParams nioParams = new NioParams();
    private SSLContext sslContext;
    private int channelRpcTimeout = DEFAULT_CHANNEL_RPC_TIMEOUT;
    private boolean channelShouldCheckRpcResponseType = false;
    private ErrorOnWriteListener errorOnWriteListener;
    private int workPoolTimeout = -1;
    private TopologyRecoveryFilter topologyRecoveryFilter;
    private RetryHandler topologyRecoveryRetryHandler;
    private ConnectionPostProcessor connectionPostProcessor = new ConnectionPostProcessor(){

        @Override
        public void postProcess(ConnectionContext connectionContext) {
        }
    };
    private TrafficListener trafficListener = TrafficListener.NO_OP;

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public static int portOrDefault(int n2, boolean bl) {
        if (n2 != -1) {
            return n2;
        }
        if (bl) {
            return 5671;
        }
        return 5672;
    }

    public int getPort() {
        return ConnectionFactory.portOrDefault(this.port, this.isSSL());
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getUsername() {
        return this.credentialsProvider.getUsername();
    }

    public void setUsername(String string) {
        this.credentialsProvider = new DefaultCredentialsProvider(string, this.credentialsProvider.getPassword());
    }

    public String getPassword() {
        return this.credentialsProvider.getPassword();
    }

    public void setPassword(String string) {
        this.credentialsProvider = new DefaultCredentialsProvider(this.credentialsProvider.getUsername(), string);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String string) {
        this.virtualHost = string;
    }

    public void setUri(URI uRI) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        String[] stringArray;
        String string;
        int n2;
        String string2;
        if (!"amqp".equals(uRI.getScheme().toLowerCase())) {
            if ("amqps".equals(uRI.getScheme().toLowerCase())) {
                this.setPort(5671);
                if (this.sslContext == null) {
                    this.useSslProtocol();
                }
            } else {
                throw new IllegalArgumentException("Wrong scheme in AMQP URI: " + uRI.getScheme());
            }
        }
        if ((string2 = uRI.getHost()) != null) {
            this.setHost(string2);
        }
        if ((n2 = uRI.getPort()) != -1) {
            this.setPort(n2);
        }
        if ((string = uRI.getRawUserInfo()) != null) {
            stringArray = string.split(":");
            if (stringArray.length > 2) {
                throw new IllegalArgumentException("Bad user info in AMQP URI: " + string);
            }
            this.setUsername(ConnectionFactory.uriDecode(stringArray[0]));
            if (stringArray.length == 2) {
                this.setPassword(ConnectionFactory.uriDecode(stringArray[1]));
            }
        }
        if ((stringArray = uRI.getRawPath()) != null && stringArray.length() > 0) {
            if (stringArray.indexOf(47, 1) != -1) {
                throw new IllegalArgumentException("Multiple segments in path of AMQP URI: " + (String)stringArray);
            }
            this.setVirtualHost(ConnectionFactory.uriDecode(uRI.getPath().substring(1)));
        }
    }

    public void setUri(String string) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.setUri(new URI(string));
    }

    private static String uriDecode(String string) {
        try {
            return URLDecoder.decode(string.replace("+", "%2B"), "US-ASCII");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int n2) {
        this.requestedChannelMax = n2;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int n2) {
        this.requestedFrameMax = n2;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setConnectionTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("TCP connection timeout cannot be negative");
        }
        this.connectionTimeout = n2;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public void setHandshakeTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("handshake timeout cannot be negative");
        }
        this.handshakeTimeout = n2;
    }

    public void setShutdownTimeout(int n2) {
        this.shutdownTimeout = n2;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setRequestedHeartbeat(int n2) {
        this.requestedHeartbeat = n2;
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public void setClientProperties(Map<String, Object> map) {
        this._clientProperties = map;
    }

    public SaslConfig getSaslConfig() {
        return this.saslConfig;
    }

    public void setSaslConfig(SaslConfig saslConfig) {
        this.saslConfig = saslConfig;
    }

    public SocketFactory getSocketFactory() {
        return this.factory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.factory = socketFactory;
    }

    public SocketConfigurator getSocketConfigurator() {
        return this.socketConf;
    }

    public void setSocketConfigurator(SocketConfigurator socketConfigurator) {
        this.socketConf = socketConfigurator;
    }

    public void setSharedExecutor(ExecutorService executorService) {
        this.sharedExecutor = executorService;
    }

    public void setShutdownExecutor(ExecutorService executorService) {
        this.shutdownExecutor = executorService;
    }

    public void setHeartbeatExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.heartbeatExecutor = scheduledExecutorService;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exception handler cannot be null!");
        }
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isSSL() {
        return this.getSocketFactory() instanceof SSLSocketFactory;
    }

    public void useSslProtocol() throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(ConnectionFactory.computeDefaultTlsProcotol(SSLContext.getDefault().getSupportedSSLParameters().getProtocols()));
    }

    public void useSslProtocol(String string) throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(string, new TrustEverythingTrustManager());
    }

    public void useSslProtocol(String string, TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance(string);
        sSLContext.init(null, new TrustManager[]{trustManager}, null);
        this.useSslProtocol(sSLContext);
    }

    public void useSslProtocol(SSLContext sSLContext) {
        this.setSocketFactory(sSLContext.getSocketFactory());
        this.sslContext = sSLContext;
    }

    public void enableHostnameVerification() {
        if (this.isJava6()) {
            this.enableHostnameVerification(new DefaultHostnameVerifier());
        } else {
            this.enableHostnameVerificationForNio();
            this.enableHostnameVerificationForBlockingIo();
        }
    }

    public void enableHostnameVerification(HostnameVerifier hostnameVerifier) {
        this.connectionPostProcessor = this.connectionPostProcessor == null ? ConnectionPostProcessors.builder().enableHostnameVerification(hostnameVerifier).build() : ConnectionPostProcessors.builder().add(this.connectionPostProcessor).enableHostnameVerification(hostnameVerifier).build();
    }

    protected boolean isJava6() {
        return System.getProperty("java.specification.version").startsWith("1.6");
    }

    protected void enableHostnameVerificationForNio() {
        if (this.nioParams == null) {
            this.nioParams = new NioParams();
        }
        this.nioParams = this.nioParams.enableHostnameVerification();
    }

    protected void enableHostnameVerificationForBlockingIo() {
        this.socketConf = this.socketConf == null ? SocketConfigurators.builder().defaultConfigurator().enableHostnameVerification().build() : SocketConfigurators.builder().add(this.socketConf).enableHostnameVerification().build();
    }

    public static String computeDefaultTlsProcotol(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!PREFERRED_TLS_PROTOCOL.equalsIgnoreCase(string)) continue;
                return string;
            }
        }
        return FALLBACK_TLS_PROTOCOL;
    }

    public boolean isAutomaticRecoveryEnabled() {
        return this.automaticRecovery;
    }

    public void setAutomaticRecoveryEnabled(boolean bl) {
        this.automaticRecovery = bl;
    }

    public boolean isTopologyRecoveryEnabled() {
        return this.topologyRecovery;
    }

    public void setTopologyRecoveryEnabled(boolean bl) {
        this.topologyRecovery = bl;
    }

    public ExecutorService getTopologyRecoveryExecutor() {
        return this.topologyRecoveryExecutor;
    }

    public void setTopologyRecoveryExecutor(ExecutorService executorService) {
        this.topologyRecoveryExecutor = executorService;
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    protected synchronized FrameHandlerFactory createFrameHandlerFactory() throws IOException {
        if (this.nio) {
            if (this.frameHandlerFactory == null) {
                if (this.nioParams.getNioExecutor() == null && this.nioParams.getThreadFactory() == null) {
                    this.nioParams.setThreadFactory(this.getThreadFactory());
                }
                this.frameHandlerFactory = new SocketChannelFrameHandlerFactory(this.connectionTimeout, this.nioParams, this.isSSL(), this.sslContext, this.connectionPostProcessor);
            }
            return this.frameHandlerFactory;
        }
        return new SocketFrameHandlerFactory(this.connectionTimeout, this.factory, this.socketConf, this.isSSL(), this.shutdownExecutor, this.connectionPostProcessor);
    }

    public Connection newConnection(Address[] addressArray) throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, Arrays.asList(addressArray), null);
    }

    public Connection newConnection(AddressResolver addressResolver) throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, addressResolver, null);
    }

    public Connection newConnection(Address[] addressArray, String string) throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, Arrays.asList(addressArray), string);
    }

    public Connection newConnection(List<Address> list) throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, list, null);
    }

    public Connection newConnection(List<Address> list, String string) throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, list, string);
    }

    public Connection newConnection(ExecutorService executorService, Address[] addressArray) throws IOException, TimeoutException {
        return this.newConnection(executorService, Arrays.asList(addressArray), null);
    }

    public Connection newConnection(ExecutorService executorService, Address[] addressArray, String string) throws IOException, TimeoutException {
        return this.newConnection(executorService, Arrays.asList(addressArray), string);
    }

    public Connection newConnection(ExecutorService executorService, List<Address> list) throws IOException, TimeoutException {
        return this.newConnection(executorService, list, null);
    }

    public Connection newConnection(ExecutorService executorService, AddressResolver addressResolver) throws IOException, TimeoutException {
        return this.newConnection(executorService, addressResolver, null);
    }

    public Connection newConnection(ExecutorService executorService, List<Address> list, String string) throws IOException, TimeoutException {
        return this.newConnection(executorService, this.createAddressResolver(list), string);
    }

    public Connection newConnection(ExecutorService executorService, AddressResolver addressResolver, String string) throws IOException, TimeoutException {
        Object object;
        if (this.metricsCollector == null) {
            this.metricsCollector = new NoOpMetricsCollector();
        }
        FrameHandlerFactory frameHandlerFactory = this.createFrameHandlerFactory();
        ConnectionParams connectionParams = this.params(executorService);
        if (string != null) {
            object = new HashMap<String, Object>(connectionParams.getClientProperties());
            object.put("connection_name", string);
            connectionParams.setClientProperties((Map<String, Object>)object);
        }
        if (this.isAutomaticRecoveryEnabled()) {
            object = new AutorecoveringConnection(connectionParams, frameHandlerFactory, addressResolver, this.metricsCollector);
            ((AutorecoveringConnection)object).init();
            return object;
        }
        object = addressResolver.getAddresses();
        Exception exception = null;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Address address = (Address)iterator.next();
            try {
                FrameHandler frameHandler = frameHandlerFactory.create(address);
                AMQConnection aMQConnection = this.createConnection(connectionParams, frameHandler, this.metricsCollector);
                aMQConnection.start();
                this.metricsCollector.newConnection(aMQConnection);
                return aMQConnection;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (TimeoutException timeoutException) {
                exception = timeoutException;
            }
        }
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof TimeoutException) {
                throw (TimeoutException)exception;
            }
        }
        throw new IOException("failed to connect");
    }

    public ConnectionParams params(ExecutorService executorService) {
        ConnectionParams connectionParams = new ConnectionParams();
        connectionParams.setCredentialsProvider(this.credentialsProvider);
        connectionParams.setConsumerWorkServiceExecutor(executorService);
        connectionParams.setVirtualHost(this.virtualHost);
        connectionParams.setClientProperties(this.getClientProperties());
        connectionParams.setRequestedFrameMax(this.requestedFrameMax);
        connectionParams.setRequestedChannelMax(this.requestedChannelMax);
        connectionParams.setShutdownTimeout(this.shutdownTimeout);
        connectionParams.setSaslConfig(this.saslConfig);
        connectionParams.setNetworkRecoveryInterval(this.networkRecoveryInterval);
        connectionParams.setRecoveryDelayHandler(this.recoveryDelayHandler);
        connectionParams.setTopologyRecovery(this.topologyRecovery);
        connectionParams.setTopologyRecoveryExecutor(this.topologyRecoveryExecutor);
        connectionParams.setExceptionHandler(this.exceptionHandler);
        connectionParams.setThreadFactory(this.threadFactory);
        connectionParams.setHandshakeTimeout(this.handshakeTimeout);
        connectionParams.setRequestedHeartbeat(this.requestedHeartbeat);
        connectionParams.setShutdownExecutor(this.shutdownExecutor);
        connectionParams.setHeartbeatExecutor(this.heartbeatExecutor);
        connectionParams.setChannelRpcTimeout(this.channelRpcTimeout);
        connectionParams.setChannelShouldCheckRpcResponseType(this.channelShouldCheckRpcResponseType);
        connectionParams.setWorkPoolTimeout(this.workPoolTimeout);
        connectionParams.setErrorOnWriteListener(this.errorOnWriteListener);
        connectionParams.setTopologyRecoveryFilter(this.topologyRecoveryFilter);
        connectionParams.setTopologyRecoveryRetryHandler(this.topologyRecoveryRetryHandler);
        connectionParams.setTrafficListener(this.trafficListener);
        return connectionParams;
    }

    protected AMQConnection createConnection(ConnectionParams connectionParams, FrameHandler frameHandler, MetricsCollector metricsCollector) {
        return new AMQConnection(connectionParams, frameHandler, metricsCollector);
    }

    public Connection newConnection() throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, Collections.singletonList(new Address(this.getHost(), this.getPort())));
    }

    public Connection newConnection(String string) throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, Collections.singletonList(new Address(this.getHost(), this.getPort())), string);
    }

    public Connection newConnection(ExecutorService executorService) throws IOException, TimeoutException {
        return this.newConnection(executorService, Collections.singletonList(new Address(this.getHost(), this.getPort())));
    }

    public Connection newConnection(ExecutorService executorService, String string) throws IOException, TimeoutException {
        return this.newConnection(executorService, Collections.singletonList(new Address(this.getHost(), this.getPort())), string);
    }

    protected AddressResolver createAddressResolver(List<Address> list) {
        if (list.size() == 1 && !this.isSSL()) {
            return new DnsRecordIpAddressResolver(list.get(0), this.isSSL());
        }
        return new ListAddressResolver(list);
    }

    public ConnectionFactory clone() {
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)super.clone();
            return connectionFactory;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    public ConnectionFactory load(String string) throws IOException {
        ConnectionFactoryConfigurator.load(this, string);
        return this;
    }

    public ConnectionFactory load(String string, String string2) throws IOException {
        ConnectionFactoryConfigurator.load(this, string, string2);
        return this;
    }

    public ConnectionFactory load(Properties properties) {
        ConnectionFactoryConfigurator.load(this, properties);
        return this;
    }

    public ConnectionFactory load(Properties properties, String string) {
        ConnectionFactoryConfigurator.load(this, (Map<String, String>)properties, string);
        return this;
    }

    public ConnectionFactory load(Map<String, String> map) {
        ConnectionFactoryConfigurator.load(this, map);
        return this;
    }

    public ConnectionFactory load(Map<String, String> map, String string) {
        ConnectionFactoryConfigurator.load(this, map, string);
        return this;
    }

    public long getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public void setNetworkRecoveryInterval(int n2) {
        this.networkRecoveryInterval = n2;
    }

    public void setNetworkRecoveryInterval(long l2) {
        this.networkRecoveryInterval = l2;
    }

    public RecoveryDelayHandler getRecoveryDelayHandler() {
        return this.recoveryDelayHandler;
    }

    public void setRecoveryDelayHandler(RecoveryDelayHandler recoveryDelayHandler) {
        this.recoveryDelayHandler = recoveryDelayHandler;
    }

    public void setNioParams(NioParams nioParams) {
        this.nioParams = nioParams;
    }

    public NioParams getNioParams() {
        return this.nioParams;
    }

    public void useNio() {
        this.nio = true;
    }

    public void useBlockingIo() {
        this.nio = false;
    }

    public void setChannelRpcTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Timeout cannot be less than 0");
        }
        this.channelRpcTimeout = n2;
    }

    public int getChannelRpcTimeout() {
        return this.channelRpcTimeout;
    }

    public void setChannelShouldCheckRpcResponseType(boolean bl) {
        this.channelShouldCheckRpcResponseType = bl;
    }

    public boolean isChannelShouldCheckRpcResponseType() {
        return this.channelShouldCheckRpcResponseType;
    }

    public void setWorkPoolTimeout(int n2) {
        this.workPoolTimeout = n2;
    }

    public int getWorkPoolTimeout() {
        return this.workPoolTimeout;
    }

    public void setErrorOnWriteListener(ErrorOnWriteListener errorOnWriteListener) {
        this.errorOnWriteListener = errorOnWriteListener;
    }

    public void setTopologyRecoveryFilter(TopologyRecoveryFilter topologyRecoveryFilter) {
        this.topologyRecoveryFilter = topologyRecoveryFilter;
    }

    public void setTopologyRecoveryRetryHandler(RetryHandler retryHandler) {
        this.topologyRecoveryRetryHandler = retryHandler;
    }

    public void setConnectionPostProcessor(ConnectionPostProcessor connectionPostProcessor) {
        this.connectionPostProcessor = connectionPostProcessor;
    }

    public void setTrafficListener(TrafficListener trafficListener) {
        this.trafficListener = trafficListener;
    }
}

