/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionPostProcessor;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public abstract class ConnectionPostProcessors {
    public static AbstractConnectionPostProcessor hostnameVerificationConnectionPostProcessor(HostnameVerifier hostnameVerifier) {
        return new HostnameVerificationConnectionPostProcessor(hostnameVerifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AbstractConnectionPostProcessor postProcessor = new AbstractConnectionPostProcessor(){

            @Override
            public void postProcess(ConnectionContext connectionContext) {
            }
        };

        public Builder enableHostnameVerification(HostnameVerifier hostnameVerifier) {
            this.postProcessor = this.postProcessor.andThen(ConnectionPostProcessors.hostnameVerificationConnectionPostProcessor(hostnameVerifier));
            return this;
        }

        public Builder add(ConnectionPostProcessor connectionPostProcessor) {
            this.postProcessor = this.postProcessor.andThen(connectionPostProcessor);
            return this;
        }

        public ConnectionPostProcessor build() {
            return this.postProcessor;
        }
    }

    public static abstract class AbstractConnectionPostProcessor
    implements ConnectionPostProcessor {
        public AbstractConnectionPostProcessor andThen(final ConnectionPostProcessor connectionPostProcessor) {
            if (connectionPostProcessor == null) {
                throw new NullPointerException();
            }
            return new AbstractConnectionPostProcessor(){

                @Override
                public void postProcess(ConnectionContext connectionContext) throws IOException {
                    AbstractConnectionPostProcessor.this.postProcess(connectionContext);
                    connectionPostProcessor.postProcess(connectionContext);
                }
            };
        }
    }

    private static class HostnameVerificationConnectionPostProcessor
    extends AbstractConnectionPostProcessor {
        private final HostnameVerifier verifier;

        private HostnameVerificationConnectionPostProcessor(HostnameVerifier hostnameVerifier) {
            this.verifier = hostnameVerifier;
        }

        @Override
        public void postProcess(ConnectionContext connectionContext) throws IOException {
            String string;
            SSLSession sSLSession = connectionContext.getSslSession();
            if (sSLSession == null && connectionContext.getSocket() instanceof SSLSocket) {
                sSLSession = ((SSLSocket)connectionContext.getSocket()).getSession();
            }
            if (sSLSession != null && !this.verifier.verify(string = connectionContext.getAddress().getHost(), sSLSession)) {
                throw new SSLHandshakeException("Hostname " + string + " does not match TLS certificate SAN or CN");
            }
        }
    }
}

