/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.AlreadyClosedException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ChannelContinuationTimeoutException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Command;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.TrafficListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQCommand;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Method;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.BlockingValueOrException;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public abstract class AMQChannel
extends ShutdownNotifierComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQChannel.class);
    protected static final int NO_RPC_TIMEOUT = 0;
    protected final Object _channelMutex = new Object();
    private final AMQConnection _connection;
    private final int _channelNumber;
    private AMQCommand _command = new AMQCommand();
    private RpcContinuation _activeRpc = null;
    public volatile boolean _blockContent = false;
    protected final int _rpcTimeout;
    private final boolean _checkRpcResponseType;
    private final TrafficListener _trafficListener;

    public AMQChannel(AMQConnection aMQConnection, int n2) {
        this._connection = aMQConnection;
        this._channelNumber = n2;
        if (aMQConnection.getChannelRpcTimeout() < 0) {
            throw new IllegalArgumentException("Continuation timeout on RPC calls cannot be less than 0");
        }
        this._rpcTimeout = aMQConnection.getChannelRpcTimeout();
        this._checkRpcResponseType = aMQConnection.willCheckRpcResponseType();
        this._trafficListener = aMQConnection.getTrafficListener();
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    public void handleFrame(Frame frame) throws IOException {
        AMQCommand aMQCommand = this._command;
        if (aMQCommand.handleFrame(frame)) {
            this._command = new AMQCommand();
            this.handleCompleteInboundCommand(aMQCommand);
        }
    }

    public static IOException wrap(ShutdownSignalException shutdownSignalException) {
        return AMQChannel.wrap(shutdownSignalException, null);
    }

    public static IOException wrap(ShutdownSignalException shutdownSignalException, String string) {
        IOException iOException = new IOException(string);
        iOException.initCause(shutdownSignalException);
        return iOException;
    }

    public AMQCommand exnWrappingRpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) throws IOException {
        try {
            return this.privateRpc(method);
        }
        catch (AlreadyClosedException alreadyClosedException) {
            throw alreadyClosedException;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            throw AMQChannel.wrap(shutdownSignalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompleteInboundCommand(AMQCommand aMQCommand) throws IOException {
        this._trafficListener.read(aMQCommand);
        if (!this.processAsync(aMQCommand)) {
            Object object;
            if (this._checkRpcResponseType) {
                object = this._channelMutex;
                synchronized (object) {
                    if (this._activeRpc != null && !this._activeRpc.canHandleReply(aMQCommand)) {
                        return;
                    }
                }
            }
            if ((object = this.nextOutstandingRpc()) != null) {
                object.handleCommand(aMQCommand);
                this.markRpcFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueRpc(RpcContinuation rpcContinuation) {
        Object object = this._channelMutex;
        synchronized (object) {
            boolean bl = false;
            while (this._activeRpc != null) {
                try {
                    this._channelMutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            this._activeRpc = rpcContinuation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            return this._activeRpc != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcContinuation nextOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            RpcContinuation rpcContinuation = this._activeRpc;
            this._activeRpc = null;
            this._channelMutex.notifyAll();
            return rpcContinuation;
        }
    }

    protected void markRpcFinished() {
    }

    public void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException(this.getCloseReason());
        }
    }

    public AMQCommand rpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) throws IOException, ShutdownSignalException {
        return this.privateRpc(method);
    }

    public AMQCommand rpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, int n2) throws IOException, ShutdownSignalException, TimeoutException {
        return this.privateRpc(method, n2);
    }

    private AMQCommand privateRpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) throws IOException, ShutdownSignalException {
        SimpleBlockingRpcContinuation simpleBlockingRpcContinuation = new SimpleBlockingRpcContinuation(method);
        this.rpc(method, simpleBlockingRpcContinuation);
        if (this._rpcTimeout == 0) {
            return (AMQCommand)simpleBlockingRpcContinuation.getReply();
        }
        try {
            return (AMQCommand)simpleBlockingRpcContinuation.getReply(this._rpcTimeout);
        }
        catch (TimeoutException timeoutException) {
            throw this.wrapTimeoutException(method, timeoutException);
        }
    }

    private void cleanRpcChannelState() {
        try {
            this.nextOutstandingRpc();
            this.markRpcFinished();
        }
        catch (Exception exception) {
            LOGGER.warn("Error while cleaning timed out channel RPC: {}", (Object)exception.getMessage());
        }
    }

    protected ChannelContinuationTimeoutException wrapTimeoutException(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, TimeoutException timeoutException) {
        this.cleanRpcChannelState();
        return new ChannelContinuationTimeoutException(timeoutException, this, this._channelNumber, method);
    }

    private AMQCommand privateRpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, int n2) throws IOException, ShutdownSignalException, TimeoutException {
        SimpleBlockingRpcContinuation simpleBlockingRpcContinuation = new SimpleBlockingRpcContinuation(method);
        this.rpc(method, simpleBlockingRpcContinuation);
        try {
            return (AMQCommand)simpleBlockingRpcContinuation.getReply(n2);
        }
        catch (TimeoutException timeoutException) {
            this.cleanRpcChannelState();
            throw timeoutException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, RpcContinuation rpcContinuation) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingRpc(method, rpcContinuation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingRpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, RpcContinuation rpcContinuation) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.enqueueRpc(rpcContinuation);
            this.quiescingTransmit(method);
        }
    }

    public abstract boolean processAsync(Command var1) throws IOException;

    public String toString() {
        return "AMQChannel(" + this._connection + "," + this._channelNumber + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processShutdownSignal(ShutdownSignalException shutdownSignalException, boolean bl, boolean bl2) {
        try {
            Object object = this._channelMutex;
            synchronized (object) {
                if (!this.setShutdownCauseIfOpen(shutdownSignalException) && !bl) {
                    throw new AlreadyClosedException(this.getCloseReason());
                }
                this._channelMutex.notifyAll();
            }
        }
        finally {
            if (bl2) {
                this.notifyOutstandingRpc(shutdownSignalException);
            }
        }
    }

    public void notifyOutstandingRpc(ShutdownSignalException shutdownSignalException) {
        RpcContinuation rpcContinuation = this.nextOutstandingRpc();
        if (rpcContinuation != null) {
            rpcContinuation.handleShutdownSignal(shutdownSignalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.transmit(new AMQCommand(method));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(AMQCommand aMQCommand) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingTransmit(aMQCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.quiescingTransmit(new AMQCommand(method));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(AMQCommand aMQCommand) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            if (aMQCommand.getMethod().hasContent()) {
                while (this._blockContent) {
                    try {
                        this._channelMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.ensureIsOpen();
                }
            }
            this._trafficListener.write(aMQCommand);
            aMQCommand.transmit(this);
        }
    }

    public AMQConnection getConnection() {
        return this._connection;
    }

    public static class SimpleBlockingRpcContinuation
    extends BlockingRpcContinuation<AMQCommand> {
        public SimpleBlockingRpcContinuation() {
        }

        public SimpleBlockingRpcContinuation(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) {
            super(method);
        }

        @Override
        public AMQCommand transformReply(AMQCommand aMQCommand) {
            return aMQCommand;
        }
    }

    public static abstract class BlockingRpcContinuation<T>
    implements RpcContinuation {
        public final BlockingValueOrException<T, ShutdownSignalException> _blocker = new BlockingValueOrException();
        protected final com.contrastsecurity.thirdparty.com.rabbitmq.client.Method request;

        public BlockingRpcContinuation() {
            this.request = null;
        }

        public BlockingRpcContinuation(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) {
            this.request = method;
        }

        @Override
        public void handleCommand(AMQCommand aMQCommand) {
            this._blocker.setValue(this.transformReply(aMQCommand));
        }

        @Override
        public void handleShutdownSignal(ShutdownSignalException shutdownSignalException) {
            this._blocker.setException(shutdownSignalException);
        }

        public T getReply() throws ShutdownSignalException {
            return this._blocker.uninterruptibleGetValue();
        }

        public T getReply(int n2) throws ShutdownSignalException, TimeoutException {
            return this._blocker.uninterruptibleGetValue(n2);
        }

        @Override
        public boolean canHandleReply(AMQCommand aMQCommand) {
            if (this.request != null) {
                Method method = aMQCommand.getMethod();
                if (this.request instanceof AMQP.Basic.Qos) {
                    return method instanceof AMQP.Basic.QosOk;
                }
                if (this.request instanceof AMQP.Basic.Get) {
                    return method instanceof AMQP.Basic.GetOk || method instanceof AMQP.Basic.GetEmpty;
                }
                if (this.request instanceof AMQP.Basic.Consume) {
                    if (!(method instanceof AMQP.Basic.ConsumeOk)) {
                        return false;
                    }
                    String string = ((AMQP.Basic.Consume)this.request).getConsumerTag();
                    return string == null || string.equals("") || string.equals(((AMQP.Basic.ConsumeOk)((Object)method)).getConsumerTag());
                }
                if (this.request instanceof AMQP.Basic.Cancel) {
                    if (!(method instanceof AMQP.Basic.CancelOk)) {
                        return false;
                    }
                    return ((AMQP.Basic.Cancel)this.request).getConsumerTag().equals(((AMQP.Basic.CancelOk)((Object)method)).getConsumerTag());
                }
                if (this.request instanceof AMQP.Basic.Recover) {
                    return method instanceof AMQP.Basic.RecoverOk;
                }
                if (this.request instanceof AMQP.Exchange.Declare) {
                    return method instanceof AMQP.Exchange.DeclareOk;
                }
                if (this.request instanceof AMQP.Exchange.Delete) {
                    return method instanceof AMQP.Exchange.DeleteOk;
                }
                if (this.request instanceof AMQP.Exchange.Bind) {
                    return method instanceof AMQP.Exchange.BindOk;
                }
                if (this.request instanceof AMQP.Exchange.Unbind) {
                    return method instanceof AMQP.Exchange.UnbindOk;
                }
                if (this.request instanceof AMQP.Queue.Declare) {
                    return method instanceof AMQP.Queue.DeclareOk;
                }
                if (this.request instanceof AMQP.Queue.Delete) {
                    return method instanceof AMQP.Queue.DeleteOk;
                }
                if (this.request instanceof AMQP.Queue.Bind) {
                    return method instanceof AMQP.Queue.BindOk;
                }
                if (this.request instanceof AMQP.Queue.Unbind) {
                    return method instanceof AMQP.Queue.UnbindOk;
                }
                if (this.request instanceof AMQP.Queue.Purge) {
                    return method instanceof AMQP.Queue.PurgeOk;
                }
                if (this.request instanceof AMQP.Tx.Select) {
                    return method instanceof AMQP.Tx.SelectOk;
                }
                if (this.request instanceof AMQP.Tx.Commit) {
                    return method instanceof AMQP.Tx.CommitOk;
                }
                if (this.request instanceof AMQP.Tx.Rollback) {
                    return method instanceof AMQP.Tx.RollbackOk;
                }
                if (this.request instanceof AMQP.Confirm.Select) {
                    return method instanceof AMQP.Confirm.SelectOk;
                }
            }
            return true;
        }

        public abstract T transformReply(AMQCommand var1);
    }

    public static interface RpcContinuation {
        public void handleCommand(AMQCommand var1);

        public boolean canHandleReply(AMQCommand var1);

        public void handleShutdownSignal(ShutdownSignalException var1);
    }
}

