/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Connection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractMetricsCollector
implements MetricsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetricsCollector.class);
    private final ConcurrentMap<String, ConnectionState> connectionState = new ConcurrentHashMap<String, ConnectionState>();
    private final Runnable markAcknowledgedMessageAction = new Runnable(){

        @Override
        public void run() {
            AbstractMetricsCollector.this.markAcknowledgedMessage();
        }
    };
    private final Runnable markRejectedMessageAction = new Runnable(){

        @Override
        public void run() {
            AbstractMetricsCollector.this.markRejectedMessage();
        }
    };

    @Override
    public void newConnection(final Connection connection) {
        try {
            if (connection.getId() == null) {
                connection.setId(UUID.randomUUID().toString());
            }
            this.incrementConnectionCount(connection);
            this.connectionState.put(connection.getId(), new ConnectionState(connection));
            connection.addShutdownListener(new ShutdownListener(){

                @Override
                public void shutdownCompleted(ShutdownSignalException shutdownSignalException) {
                    AbstractMetricsCollector.this.closeConnection(connection);
                }
            });
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in newConnection: " + exception.getMessage());
        }
    }

    @Override
    public void closeConnection(Connection connection) {
        try {
            ConnectionState connectionState = (ConnectionState)this.connectionState.remove(connection.getId());
            if (connectionState != null) {
                this.decrementConnectionCount(connection);
            }
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in closeConnection: " + exception.getMessage());
        }
    }

    @Override
    public void newChannel(final Channel channel) {
        try {
            this.incrementChannelCount(channel);
            channel.addShutdownListener(new ShutdownListener(){

                @Override
                public void shutdownCompleted(ShutdownSignalException shutdownSignalException) {
                    AbstractMetricsCollector.this.closeChannel(channel);
                }
            });
            this.connectionState((Connection)channel.getConnection()).channelState.put(channel.getChannelNumber(), new ChannelState(channel));
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in newChannel: " + exception.getMessage());
        }
    }

    @Override
    public void closeChannel(Channel channel) {
        try {
            ChannelState channelState = (ChannelState)this.connectionState((Connection)channel.getConnection()).channelState.remove(channel.getChannelNumber());
            if (channelState != null) {
                this.decrementChannelCount(channel);
            }
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in closeChannel: " + exception.getMessage());
        }
    }

    @Override
    public void basicPublish(Channel channel) {
        try {
            this.markPublishedMessage();
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in basicPublish: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicConsume(Channel channel, String string, boolean bl) {
        block5: {
            try {
                if (bl) break block5;
                ChannelState channelState = this.channelState(channel);
                channelState.lock.lock();
                try {
                    this.channelState((Channel)channel).consumersWithManualAck.add(string);
                }
                finally {
                    channelState.lock.unlock();
                }
            }
            catch (Exception exception) {
                LOGGER.info("Error while computing metrics in basicConsume: " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicCancel(Channel channel, String string) {
        try {
            ChannelState channelState = this.channelState(channel);
            channelState.lock.lock();
            try {
                this.channelState((Channel)channel).consumersWithManualAck.remove(string);
            }
            finally {
                channelState.lock.unlock();
            }
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in basicCancel: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumedMessage(Channel channel, long l2, boolean bl) {
        block5: {
            try {
                this.markConsumedMessage();
                if (bl) break block5;
                ChannelState channelState = this.channelState(channel);
                channelState.lock.lock();
                try {
                    this.channelState((Channel)channel).unackedMessageDeliveryTags.add(l2);
                }
                finally {
                    channelState.lock.unlock();
                }
            }
            catch (Exception exception) {
                LOGGER.info("Error while computing metrics in consumedMessage: " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumedMessage(Channel channel, long l2, String string) {
        try {
            this.markConsumedMessage();
            ChannelState channelState = this.channelState(channel);
            channelState.lock.lock();
            try {
                if (channelState.consumersWithManualAck.contains(string)) {
                    channelState.unackedMessageDeliveryTags.add(l2);
                }
            }
            finally {
                channelState.lock.unlock();
            }
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in consumedMessage: " + exception.getMessage());
        }
    }

    @Override
    public void basicAck(Channel channel, long l2, boolean bl) {
        try {
            this.updateChannelStateAfterAckReject(channel, l2, bl, this.markAcknowledgedMessageAction);
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in basicAck: " + exception.getMessage());
        }
    }

    @Override
    public void basicNack(Channel channel, long l2) {
        try {
            this.updateChannelStateAfterAckReject(channel, l2, true, this.markRejectedMessageAction);
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in basicNack: " + exception.getMessage());
        }
    }

    @Override
    public void basicReject(Channel channel, long l2) {
        try {
            this.updateChannelStateAfterAckReject(channel, l2, false, this.markRejectedMessageAction);
        }
        catch (Exception exception) {
            LOGGER.info("Error while computing metrics in basicReject: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannelStateAfterAckReject(Channel channel, long l2, boolean bl, Runnable runnable) {
        ChannelState channelState = this.channelState(channel);
        channelState.lock.lock();
        try {
            if (bl) {
                Iterator<Long> iterator = channelState.unackedMessageDeliveryTags.iterator();
                while (iterator.hasNext()) {
                    long l3 = iterator.next();
                    if (l3 > l2) continue;
                    iterator.remove();
                    runnable.run();
                }
            } else if (channelState.unackedMessageDeliveryTags.remove(l2)) {
                runnable.run();
            }
        }
        finally {
            channelState.lock.unlock();
        }
    }

    private ConnectionState connectionState(Connection connection) {
        return (ConnectionState)this.connectionState.get(connection.getId());
    }

    private ChannelState channelState(Channel channel) {
        return (ChannelState)this.connectionState((Connection)channel.getConnection()).channelState.get(channel.getChannelNumber());
    }

    public void cleanStaleState() {
        try {
            Iterator iterator = this.connectionState.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Connection connection = ((ConnectionState)entry.getValue()).connection;
                if (connection.isOpen()) {
                    Iterator iterator2 = ((ConnectionState)entry.getValue()).channelState.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry2 = iterator2.next();
                        Channel channel = ((ChannelState)entry2.getValue()).channel;
                        if (channel.isOpen()) continue;
                        iterator2.remove();
                        this.decrementChannelCount(channel);
                        LOGGER.info("Ripped off state of channel {} of connection {}. This is abnormal, please report.", (Object)channel.getChannelNumber(), (Object)connection.getId());
                    }
                    continue;
                }
                iterator.remove();
                this.decrementConnectionCount(connection);
                for (int i2 = 0; i2 < ((ConnectionState)entry.getValue()).channelState.size(); ++i2) {
                    this.decrementChannelCount(null);
                }
                LOGGER.info("Ripped off state of connection {}. This is abnormal, please report.", (Object)connection.getId());
            }
        }
        catch (Exception exception) {
            LOGGER.info("Error during periodic clean of metricsCollector: " + exception.getMessage());
        }
    }

    protected abstract void incrementConnectionCount(Connection var1);

    protected abstract void decrementConnectionCount(Connection var1);

    protected abstract void incrementChannelCount(Channel var1);

    protected abstract void decrementChannelCount(Channel var1);

    protected abstract void markPublishedMessage();

    protected abstract void markConsumedMessage();

    protected abstract void markAcknowledgedMessage();

    protected abstract void markRejectedMessage();

    private static class ChannelState {
        final Lock lock = new ReentrantLock();
        final Set<Long> unackedMessageDeliveryTags = new HashSet<Long>();
        final Set<String> consumersWithManualAck = new HashSet<String>();
        final Channel channel;

        private ChannelState(Channel channel) {
            this.channel = channel;
        }
    }

    private static class ConnectionState {
        final ConcurrentMap<Integer, ChannelState> channelState = new ConcurrentHashMap<Integer, ChannelState>();
        final Connection connection;

        private ConnectionState(Connection connection) {
            this.connection = connection;
        }
    }
}

