/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.NoOpMetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ChannelN;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConsumerWorkService;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Environment;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.UnknownChannelException;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.IntAllocator;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private final Object monitor = new Object();
    private final Map<Integer, ChannelN> _channelMap = new HashMap<Integer, ChannelN>();
    private final IntAllocator channelNumberAllocator;
    private final ConsumerWorkService workService;
    private final Set<CountDownLatch> shutdownSet = new HashSet<CountDownLatch>();
    private final int _channelMax;
    private ExecutorService shutdownExecutor;
    private final ThreadFactory threadFactory;
    private int channelShutdownTimeout = 63000;
    protected final MetricsCollector metricsCollector;

    public int getChannelMax() {
        return this._channelMax;
    }

    public ChannelManager(ConsumerWorkService consumerWorkService, int n2) {
        this(consumerWorkService, n2, Executors.defaultThreadFactory());
    }

    public ChannelManager(ConsumerWorkService consumerWorkService, int n2, ThreadFactory threadFactory) {
        this(consumerWorkService, n2, threadFactory, new NoOpMetricsCollector());
    }

    public ChannelManager(ConsumerWorkService consumerWorkService, int n2, ThreadFactory threadFactory, MetricsCollector metricsCollector) {
        if (n2 == 0) {
            n2 = 65535;
        }
        this._channelMax = n2;
        this.channelNumberAllocator = new IntAllocator(1, n2);
        this.workService = consumerWorkService;
        this.threadFactory = threadFactory;
        this.metricsCollector = metricsCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN getChannel(int n2) {
        Object object = this.monitor;
        synchronized (object) {
            ChannelN channelN = this._channelMap.get(n2);
            if (channelN == null) {
                throw new UnknownChannelException(n2);
            }
            return channelN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSignal(final ShutdownSignalException shutdownSignalException) {
        HashSet<ChannelN> hashSet;
        Iterator iterator = this.monitor;
        synchronized (iterator) {
            hashSet = new HashSet<ChannelN>(this._channelMap.values());
        }
        for (final ChannelN channelN : hashSet) {
            this.releaseChannelNumber(channelN);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    channelN.processShutdownSignal(shutdownSignalException, true, true);
                }
            };
            if (this.shutdownExecutor == null) {
                runnable.run();
            } else {
                Future<?> future = this.shutdownExecutor.submit(runnable);
                try {
                    future.get(this.channelShutdownTimeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    LOGGER.warn("Couldn't properly close channel {} on shutdown after waiting for {} ms", (Object)channelN.getChannelNumber(), (Object)this.channelShutdownTimeout);
                    future.cancel(true);
                }
            }
            this.shutdownSet.add(channelN.getShutdownLatch());
            channelN.notifyListeners();
        }
        this.scheduleShutdownProcessing();
    }

    private void scheduleShutdownProcessing() {
        final HashSet<CountDownLatch> hashSet = new HashSet<CountDownLatch>(this.shutdownSet);
        final ConsumerWorkService consumerWorkService = this.workService;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (CountDownLatch countDownLatch : hashSet) {
                    try {
                        int n2 = consumerWorkService.getShutdownTimeout();
                        if (n2 == 0) {
                            countDownLatch.await();
                            continue;
                        }
                        countDownLatch.await(n2, TimeUnit.MILLISECONDS);
                    }
                    catch (Throwable throwable) {}
                }
                consumerWorkService.shutdown();
            }
        };
        if (this.shutdownExecutor != null) {
            this.shutdownExecutor.execute(runnable);
        } else {
            Thread thread = Environment.newThread(this.threadFactory, runnable, "ConsumerWorkService shutdown monitor", true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection aMQConnection) throws IOException {
        ChannelN channelN;
        Object object = this.monitor;
        synchronized (object) {
            int n2 = this.channelNumberAllocator.allocate();
            if (n2 == -1) {
                return null;
            }
            channelN = this.addNewChannel(aMQConnection, n2);
        }
        channelN.open();
        return channelN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection aMQConnection, int n2) throws IOException {
        ChannelN channelN;
        Object object = this.monitor;
        synchronized (object) {
            if (!this.channelNumberAllocator.reserve(n2)) {
                return null;
            }
            channelN = this.addNewChannel(aMQConnection, n2);
        }
        channelN.open();
        return channelN;
    }

    private ChannelN addNewChannel(AMQConnection aMQConnection, int n2) {
        if (this._channelMap.containsKey(n2)) {
            throw new IllegalStateException("We have attempted to create a channel with a number that is already in use. This should never happen. Please report this as a bug.");
        }
        ChannelN channelN = this.instantiateChannel(aMQConnection, n2, this.workService);
        this._channelMap.put(channelN.getChannelNumber(), channelN);
        return channelN;
    }

    protected ChannelN instantiateChannel(AMQConnection aMQConnection, int n2, ConsumerWorkService consumerWorkService) {
        return new ChannelN(aMQConnection, n2, consumerWorkService, this.metricsCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseChannelNumber(ChannelN channelN) {
        Object object = this.monitor;
        synchronized (object) {
            int n2 = channelN.getChannelNumber();
            ChannelN channelN2 = this._channelMap.remove(n2);
            if (channelN2 == null) {
                return;
            }
            if (channelN2 != channelN) {
                this._channelMap.put(n2, channelN2);
                return;
            }
            this.channelNumberAllocator.free(n2);
        }
    }

    public ExecutorService getShutdownExecutor() {
        return this.shutdownExecutor;
    }

    public void setShutdownExecutor(ExecutorService executorService) {
        this.shutdownExecutor = executorService;
    }

    public void setChannelShutdownTimeout(int n2) {
        this.channelShutdownTimeout = n2;
    }
}

