/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Consumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Envelope;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConsumerWorkService;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class ConsumerDispatcher {
    private final ConsumerWorkService workService;
    private final AMQConnection connection;
    private final Channel channel;
    private volatile boolean shuttingDown = false;
    private volatile boolean shutdownConsumersDriven = false;
    private volatile CountDownLatch shutdownConsumersComplete;
    private volatile ShutdownSignalException shutdownSignal = null;

    public ConsumerDispatcher(AMQConnection aMQConnection, Channel channel, ConsumerWorkService consumerWorkService) {
        this.connection = aMQConnection;
        this.channel = channel;
        consumerWorkService.registerKey(channel);
        this.workService = consumerWorkService;
    }

    public void quiesce() {
        this.shuttingDown = true;
    }

    public void setUnlimited(boolean bl) {
        this.workService.setUnlimited(this.channel, bl);
    }

    public void handleConsumeOk(final Consumer consumer, final String string) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleConsumeOk(string);
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string, "handleConsumeOk");
                }
            }
        });
    }

    public void handleCancelOk(final Consumer consumer, final String string) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleCancelOk(string);
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string, "handleCancelOk");
                }
            }
        });
    }

    public void handleCancel(final Consumer consumer, final String string) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleCancel(string);
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string, "handleCancel");
                }
            }
        });
    }

    public void handleRecoverOk(final Consumer consumer, final String string) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                consumer.handleRecoverOk(string);
            }
        });
    }

    public void handleDelivery(final Consumer consumer, final String string, final Envelope envelope, final AMQP.BasicProperties basicProperties, final byte[] byArray) throws IOException {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleDelivery(string, envelope, basicProperties, byArray);
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string, "handleDelivery");
                }
            }
        });
    }

    public CountDownLatch handleShutdownSignal(final Map<String, Consumer> map, final ShutdownSignalException shutdownSignalException) {
        if (!this.shutdownConsumersDriven) {
            CountDownLatch countDownLatch;
            this.shutdownConsumersComplete = countDownLatch = new CountDownLatch(1);
            this.shutdownConsumersDriven = true;
            this.execute(new Runnable(){

                @Override
                public void run() {
                    ConsumerDispatcher.this.notifyConsumersOfShutdown(map, shutdownSignalException);
                    ConsumerDispatcher.this.shutdown(shutdownSignalException);
                    ConsumerDispatcher.this.workService.stopWork(ConsumerDispatcher.this.channel);
                    countDownLatch.countDown();
                }
            });
        }
        return this.shutdownConsumersComplete;
    }

    private void notifyConsumersOfShutdown(Map<String, Consumer> map, ShutdownSignalException shutdownSignalException) {
        for (Map.Entry<String, Consumer> entry : map.entrySet()) {
            this.notifyConsumerOfShutdown(entry.getKey(), entry.getValue(), shutdownSignalException);
        }
    }

    private void notifyConsumerOfShutdown(String string, Consumer consumer, ShutdownSignalException shutdownSignalException) {
        try {
            consumer.handleShutdownSignal(string, shutdownSignalException);
        }
        catch (Throwable throwable) {
            this.connection.getExceptionHandler().handleConsumerException(this.channel, throwable, consumer, string, "handleShutdownSignal");
        }
    }

    private void executeUnlessShuttingDown(Runnable runnable) {
        if (!this.shuttingDown) {
            this.execute(runnable);
        }
    }

    private void execute(Runnable runnable) {
        this.checkShutdown();
        this.workService.addWork(this.channel, runnable);
    }

    private void shutdown(ShutdownSignalException shutdownSignalException) {
        this.shutdownSignal = shutdownSignalException;
    }

    private void checkShutdown() {
        if (this.shutdownSignal != null) {
            throw Utility.fixStackTrace(this.shutdownSignal);
        }
    }
}

