/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.SetQueue;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.VariableLinkedBlockingQueue;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.WorkPoolFullException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class WorkPool<K, W> {
    private static final int MAX_QUEUE_LENGTH = 1000;
    private final SetQueue<K> ready = new SetQueue();
    private final Set<K> inProgress = new HashSet<K>();
    private final Map<K, VariableLinkedBlockingQueue<W>> pool = new HashMap<K, VariableLinkedBlockingQueue<W>>();
    private final Set<K> unlimited = new HashSet<K>();
    private final EnqueueingCallback<W> enqueueingCallback;

    public WorkPool(final int n2) {
        this.enqueueingCallback = n2 > 0 ? new EnqueueingCallback<W>(){

            @Override
            public void enqueue(BlockingQueue<W> blockingQueue, W w2) {
                try {
                    boolean bl = blockingQueue.offer(w2, n2, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        throw new WorkPoolFullException("Could not enqueue in work pool after " + n2 + " ms.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread();
                }
            }
        } : new EnqueueingCallback<W>(){

            @Override
            public void enqueue(BlockingQueue<W> blockingQueue, W w2) {
                try {
                    blockingQueue.put(w2);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(K k2) {
        WorkPool workPool = this;
        synchronized (workPool) {
            if (!this.pool.containsKey(k2)) {
                int n2 = this.unlimited.isEmpty() ? 1000 : Integer.MAX_VALUE;
                this.pool.put(k2, new VariableLinkedBlockingQueue(n2));
            }
        }
    }

    public synchronized void limit(K k2) {
        this.unlimited.remove(k2);
        if (this.unlimited.isEmpty()) {
            this.setCapacities(1000);
        }
    }

    public synchronized void unlimit(K k2) {
        this.unlimited.add(k2);
        if (!this.unlimited.isEmpty()) {
            this.setCapacities(Integer.MAX_VALUE);
        }
    }

    private void setCapacities(int n2) {
        Iterator<VariableLinkedBlockingQueue<W>> iterator = this.pool.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setCapacity(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterKey(K k2) {
        WorkPool workPool = this;
        synchronized (workPool) {
            this.pool.remove(k2);
            this.ready.remove(k2);
            this.inProgress.remove(k2);
            this.unlimited.remove(k2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllKeys() {
        WorkPool workPool = this;
        synchronized (workPool) {
            this.pool.clear();
            this.ready.clear();
            this.inProgress.clear();
            this.unlimited.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K nextWorkBlock(Collection<W> collection, int n2) {
        WorkPool workPool = this;
        synchronized (workPool) {
            K k2 = this.readyToInProgress();
            if (k2 != null) {
                VariableLinkedBlockingQueue<W> variableLinkedBlockingQueue = this.pool.get(k2);
                this.drainTo(variableLinkedBlockingQueue, collection, n2);
            }
            return k2;
        }
    }

    private int drainTo(VariableLinkedBlockingQueue<W> variableLinkedBlockingQueue, Collection<W> collection, int n2) {
        W w2;
        int n3;
        for (n3 = 0; n3 < n2 && (w2 = variableLinkedBlockingQueue.poll()) != null; ++n3) {
            collection.add(w2);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWorkItem(K k2, W w2) {
        VariableLinkedBlockingQueue<W> variableLinkedBlockingQueue;
        WorkPool workPool = this;
        synchronized (workPool) {
            variableLinkedBlockingQueue = this.pool.get(k2);
        }
        if (variableLinkedBlockingQueue != null) {
            this.enqueueingCallback.enqueue(variableLinkedBlockingQueue, w2);
            workPool = this;
            synchronized (workPool) {
                if (this.isDormant(k2)) {
                    this.dormantToReady(k2);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWorkBlock(K k2) {
        WorkPool workPool = this;
        synchronized (workPool) {
            if (!this.isRegistered(k2)) {
                return false;
            }
            if (!this.inProgress.contains(k2)) {
                throw new IllegalStateException("Client " + k2 + " not in progress");
            }
            if (this.moreWorkItems(k2)) {
                this.inProgressToReady(k2);
                return true;
            }
            this.inProgressToDormant(k2);
            return false;
        }
    }

    private boolean moreWorkItems(K k2) {
        VariableLinkedBlockingQueue<W> variableLinkedBlockingQueue = this.pool.get(k2);
        return variableLinkedBlockingQueue != null && !variableLinkedBlockingQueue.isEmpty();
    }

    private boolean isInProgress(K k2) {
        return this.inProgress.contains(k2);
    }

    private boolean isReady(K k2) {
        return this.ready.contains(k2);
    }

    private boolean isRegistered(K k2) {
        return this.pool.containsKey(k2);
    }

    private boolean isDormant(K k2) {
        return !this.isInProgress(k2) && !this.isReady(k2) && this.isRegistered(k2);
    }

    private void inProgressToReady(K k2) {
        this.inProgress.remove(k2);
        this.ready.addIfNotPresent(k2);
    }

    private void inProgressToDormant(K k2) {
        this.inProgress.remove(k2);
    }

    private void dormantToReady(K k2) {
        this.ready.addIfNotPresent(k2);
    }

    private K readyToInProgress() {
        K k2 = this.ready.poll();
        if (k2 != null) {
            this.inProgress.add(k2);
        }
        return k2;
    }

    private static interface EnqueueingCallback<W> {
        public void enqueue(BlockingQueue<W> var1, W var2);
    }
}

