/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.BackoffPolicy;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedBinding;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedEntity;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedExchange;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RetryContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RetryHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RetryResult;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;

public class DefaultRetryHandler
implements RetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRetryHandler.class);
    private final RetryCondition<? super RecordedQueue> queueRecoveryRetryCondition;
    private final RetryCondition<? super RecordedExchange> exchangeRecoveryRetryCondition;
    private final RetryCondition<? super RecordedBinding> bindingRecoveryRetryCondition;
    private final RetryCondition<? super RecordedConsumer> consumerRecoveryRetryCondition;
    private final RetryOperation<?> queueRecoveryRetryOperation;
    private final RetryOperation<?> exchangeRecoveryRetryOperation;
    private final RetryOperation<?> bindingRecoveryRetryOperation;
    private final RetryOperation<?> consumerRecoveryRetryOperation;
    private final int retryAttempts;
    private final BackoffPolicy backoffPolicy;

    public DefaultRetryHandler(RetryCondition<? super RecordedQueue> retryCondition, RetryCondition<? super RecordedExchange> retryCondition2, RetryCondition<? super RecordedBinding> retryCondition3, RetryCondition<? super RecordedConsumer> retryCondition4, RetryOperation<?> retryOperation, RetryOperation<?> retryOperation2, RetryOperation<?> retryOperation3, RetryOperation<?> retryOperation4, int n2, BackoffPolicy backoffPolicy) {
        this.queueRecoveryRetryCondition = retryCondition;
        this.exchangeRecoveryRetryCondition = retryCondition2;
        this.bindingRecoveryRetryCondition = retryCondition3;
        this.consumerRecoveryRetryCondition = retryCondition4;
        this.queueRecoveryRetryOperation = retryOperation;
        this.exchangeRecoveryRetryOperation = retryOperation2;
        this.bindingRecoveryRetryOperation = retryOperation3;
        this.consumerRecoveryRetryOperation = retryOperation4;
        this.backoffPolicy = backoffPolicy;
        if (n2 <= 0) {
            throw new IllegalArgumentException("Number of retry attempts must be greater than 0");
        }
        this.retryAttempts = n2;
    }

    @Override
    public RetryResult retryQueueRecovery(RetryContext retryContext) throws Exception {
        return this.doRetry(this.queueRecoveryRetryCondition, this.queueRecoveryRetryOperation, retryContext.queue(), retryContext);
    }

    @Override
    public RetryResult retryExchangeRecovery(RetryContext retryContext) throws Exception {
        return this.doRetry(this.exchangeRecoveryRetryCondition, this.exchangeRecoveryRetryOperation, retryContext.exchange(), retryContext);
    }

    @Override
    public RetryResult retryBindingRecovery(RetryContext retryContext) throws Exception {
        return this.doRetry(this.bindingRecoveryRetryCondition, this.bindingRecoveryRetryOperation, retryContext.binding(), retryContext);
    }

    @Override
    public RetryResult retryConsumerRecovery(RetryContext retryContext) throws Exception {
        return this.doRetry(this.consumerRecoveryRetryCondition, this.consumerRecoveryRetryOperation, retryContext.consumer(), retryContext);
    }

    protected <T extends RecordedEntity> RetryResult doRetry(RetryCondition<T> retryCondition, RetryOperation<?> retryOperation, T t2, RetryContext retryContext) throws Exception {
        Exception exception = retryContext.exception();
        for (int i2 = 0; i2 < this.retryAttempts; ++i2) {
            if (retryCondition.test(t2, exception)) {
                this.log(t2, exception, i2);
                this.backoffPolicy.backoff(i2 + 1);
                try {
                    Object obj = retryOperation.call(retryContext);
                    return new RetryResult(t2, obj == null ? null : obj.toString());
                }
                catch (Exception exception2) {
                    exception = exception2;
                    continue;
                }
            }
            throw exception;
        }
        throw exception;
    }

    protected void log(RecordedEntity recordedEntity, Exception exception, int n2) {
        LOGGER.info("Error while recovering {}, retrying with {} more attempt(s).", recordedEntity, this.retryAttempts - n2, exception);
    }

    public static abstract class RetryCondition<E extends RecordedEntity> {
        public abstract boolean test(E var1, Exception var2);

        public RetryCondition<E> and(final RetryCondition<? super E> retryCondition) {
            if (retryCondition == null) {
                throw new IllegalArgumentException("Condition cannot be null");
            }
            return new RetryCondition<E>(){

                @Override
                public boolean test(E e2, Exception exception) {
                    return RetryCondition.this.test(e2, exception) && retryCondition.test(e2, exception);
                }
            };
        }

        public RetryCondition<E> negate(RetryCondition<? super E> retryCondition) {
            if (retryCondition == null) {
                throw new IllegalArgumentException("Condition cannot be null");
            }
            return new RetryCondition<E>(){

                @Override
                public boolean test(E e2, Exception exception) {
                    return !RetryCondition.this.test(e2, exception);
                }
            };
        }
    }

    public static abstract class RetryOperation<T> {
        public abstract T call(RetryContext var1) throws Exception;

        public <V> RetryOperation<V> andThen(final RetryOperation<V> retryOperation) {
            return new RetryOperation<V>(){

                @Override
                public V call(RetryContext retryContext) throws Exception {
                    RetryOperation.this.call(retryContext);
                    return retryOperation.call(retryContext);
                }
            };
        }
    }
}

