/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.tools.json;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JSONReader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    private static final Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private Object token;
    private final StringBuilder buf = new StringBuilder();

    private char next() {
        this.c = this.it.next();
        return this.c;
    }

    private void skipWhiteSpace() {
        boolean bl;
        do {
            bl = true;
            if (Character.isWhitespace(this.c)) {
                this.next();
                continue;
            }
            if (this.c == '/' && this.next() == '/') {
                while (this.c != '\n') {
                    this.next();
                }
            } else {
                bl = false;
            }
        } while (bl);
    }

    public Object read(String string) {
        this.it = new StringCharacterIterator(string);
        this.c = this.it.first();
        return this.read();
    }

    private Object read() {
        Object object = null;
        this.skipWhiteSpace();
        if (this.c == '\"' || this.c == '\'') {
            char c2 = this.c;
            this.next();
            object = this.string(c2);
        } else if (this.c == '[') {
            this.next();
            object = this.array();
        } else if (this.c == ']') {
            object = ARRAY_END;
            this.next();
        } else if (this.c == ',') {
            object = COMMA;
            this.next();
        } else if (this.c == '{') {
            this.next();
            object = this.object();
        } else if (this.c == '}') {
            object = OBJECT_END;
            this.next();
        } else if (this.c == ':') {
            object = COLON;
            this.next();
        } else if (this.c == 't' && this.next() == 'r' && this.next() == 'u' && this.next() == 'e') {
            object = Boolean.TRUE;
            this.next();
        } else if (this.c == 'f' && this.next() == 'a' && this.next() == 'l' && this.next() == 's' && this.next() == 'e') {
            object = Boolean.FALSE;
            this.next();
        } else if (this.c == 'n' && this.next() == 'u' && this.next() == 'l' && this.next() == 'l') {
            this.next();
        } else if (Character.isDigit(this.c) || this.c == '-') {
            object = this.number();
        } else {
            throw new IllegalStateException("Found invalid token while parsing JSON (around character " + (this.it.getIndex() - this.it.getBeginIndex()) + "): " + object);
        }
        this.token = object;
        return object;
    }

    private Object object() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = (String)this.read();
        while (this.token != OBJECT_END) {
            this.read();
            if (this.token == OBJECT_END) continue;
            hashMap.put(string, this.read());
            if (this.read() != COMMA) continue;
            string = (String)this.read();
        }
        return hashMap;
    }

    private Object array() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.read();
        while (this.token != ARRAY_END) {
            arrayList.add(object);
            if (this.read() != COMMA) continue;
            object = this.read();
        }
        return arrayList;
    }

    private Object number() {
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add();
        }
        this.addDigits();
        if (this.c == '.') {
            this.add();
            this.addDigits();
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
        }
        String string = this.buf.toString();
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.valueOf(string);
        }
    }

    private Object string(char c2) {
        this.buf.setLength(0);
        while (this.c != c2) {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character c3 = escapes.get(Character.valueOf(this.c));
                if (c3 != null) {
                    this.add(c3.charValue());
                    continue;
                }
                this.add();
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char c2) {
        this.buf.append(c2);
        this.next();
    }

    private void add() {
        this.add(this.c);
    }

    private void addDigits() {
        while (Character.isDigit(this.c)) {
            this.add();
        }
    }

    private char unicode() {
        int n2 = 0;
        block5: for (int i2 = 0; i2 < 4; ++i2) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n2 = (n2 << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    n2 = (n2 << 4) + this.c - 97 + 10;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    n2 = (n2 << 4) + this.c - 65 + 10;
                }
            }
        }
        return (char)n2;
    }

    static {
        escapes.put(Character.valueOf('\"'), Character.valueOf('\"'));
        escapes.put(Character.valueOf('\\'), Character.valueOf('\\'));
        escapes.put(Character.valueOf('/'), Character.valueOf('/'));
        escapes.put(Character.valueOf('b'), Character.valueOf('\b'));
        escapes.put(Character.valueOf('f'), Character.valueOf('\f'));
        escapes.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapes.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapes.put(Character.valueOf('t'), Character.valueOf('\t'));
    }
}

