/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.utility;

public class SingleShotLinearTimer {
    private volatile Runnable _task;
    private Thread _thread;
    private static final long NANOS_IN_MILLI = 1000000L;

    public synchronized void schedule(Runnable runnable, int n2) {
        if (runnable == null) {
            throw new IllegalArgumentException("Don't schedule a null task");
        }
        if (this._task != null) {
            throw new UnsupportedOperationException("Don't schedule more than one task");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        this._task = runnable;
        this._thread = new Thread(new TimerThread(n2));
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void cancel() {
        this._task = null;
    }

    private class TimerThread
    implements Runnable {
        private final long _runTime;

        public TimerThread(long l2) {
            this._runTime = System.nanoTime() / 1000000L + l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable runnable;
                boolean bl = false;
                try {
                    long l2;
                    while ((l2 = System.nanoTime() / 1000000L) < this._runTime) {
                        if (SingleShotLinearTimer.this._task == null) {
                            break;
                        }
                        try {
                            runnable = this;
                            synchronized (runnable) {
                                this.wait(this._runTime - l2);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    }
                }
                finally {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
                if ((runnable = SingleShotLinearTimer.this._task) != null) {
                    runnable.run();
                }
            }
            finally {
                SingleShotLinearTimer.this._task = null;
            }
        }
    }
}

