/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.Functions;
import com.contrastsecurity.thirdparty.dev.failsafe.Policy;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Assert;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.AsyncExecutionInternal;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.FailsafeFuture;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;

final class AsyncExecutionImpl<R>
extends ExecutionImpl<R>
implements AsyncExecutionInternal<R> {
    private final FailsafeFuture<R> future;
    private final boolean asyncExecution;
    private Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> outerFn;
    private final boolean[] policyPostExecuted;
    private volatile boolean recorded;

    AsyncExecutionImpl(List<Policy<R>> list, Scheduler scheduler, FailsafeFuture<R> failsafeFuture, boolean bl, Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function) {
        super(list);
        this.policyPostExecuted = new boolean[this.policyExecutors.size()];
        this.future = failsafeFuture;
        this.asyncExecution = bl;
        this.outerFn = bl ? Functions.toExecutionAware(function) : function;
        this.outerFn = Functions.toAsync(this.outerFn, scheduler, failsafeFuture);
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerFn = policyExecutor.applyAsync(this.outerFn, scheduler, failsafeFuture);
        }
    }

    private AsyncExecutionImpl(AsyncExecutionImpl<R> asyncExecutionImpl) {
        super(asyncExecutionImpl);
        this.policyPostExecuted = new boolean[this.policyExecutors.size()];
        this.outerFn = asyncExecutionImpl.outerFn;
        this.future = asyncExecutionImpl.future;
        this.asyncExecution = asyncExecutionImpl.asyncExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        Assert.state(!this.recorded, "The most recent execution has already been recorded or completed", new Object[0]);
        this.recorded = true;
        FailsafeFuture<R> failsafeFuture = this.future;
        synchronized (failsafeFuture) {
            ExecutionResult executionResult = this.result != null ? this.result : ExecutionResult.none();
            this.complete(this.postExecute(executionResult), null);
        }
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(R r2, Throwable throwable) {
        Assert.state(!this.recorded, "The most recent execution has already been recorded or completed", new Object[0]);
        this.recorded = true;
        FailsafeFuture<R> failsafeFuture = this.future;
        synchronized (failsafeFuture) {
            if (!this.attemptRecorded) {
                Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
                this.record(new ExecutionResult<R>(r2, throwable));
            }
            this.executeAsync();
        }
    }

    @Override
    public void recordResult(R r2) {
        this.record(r2, null);
    }

    @Override
    public void recordException(Throwable throwable) {
        this.record(null, throwable);
    }

    @Override
    @Deprecated
    public void recordFailure(Throwable throwable) {
        this.recordException(throwable);
    }

    @Override
    public boolean isAsyncExecution() {
        return this.asyncExecution;
    }

    @Override
    public boolean isRecorded() {
        return this.recorded;
    }

    @Override
    public synchronized void setPostExecuted(int n2) {
        this.policyPostExecuted[n2] = true;
    }

    @Override
    public synchronized boolean isPostExecuted(int n2) {
        return this.policyPostExecuted[n2];
    }

    @Override
    public AsyncExecutionInternal<R> copy() {
        return new AsyncExecutionImpl<R>(this);
    }

    void executeAsync() {
        this.outerFn.apply(this).whenComplete(this::complete);
    }

    private void complete(ExecutionResult<R> executionResult, Throwable throwable) {
        if (executionResult == null && throwable == null) {
            return;
        }
        this.completed = true;
        if (!this.future.isDone()) {
            if (executionResult != null) {
                this.future.completeResult(executionResult);
            } else {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                this.future.completeResult(ExecutionResult.exception(throwable));
            }
        }
    }
}

